/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.server;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.plugins.index.api.Extractor2;
import com.atlassian.confluence.plugins.index.api.FieldDescriptor;
import com.atlassian.confluence.plugins.index.api.StringFieldDescriptor;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import cz.morosystems.namymap.server.NamymapJsonTopicParser;
import cz.morosystems.namymap.server.model.EditorParametersDto;
import cz.morosystems.namymap.server.utils.NamymapUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MindMapContentExtractor
implements Extractor2 {
    private static final Logger log = LoggerFactory.getLogger(MindMapContentExtractor.class);
    private static final String[] EXTENSIONS = new String[0];
    private static final String[] CONTENT_TYPES = new String[]{"application/namymap+json", "application/json", "application/octet-stream"};
    private final BootstrapManager bootstrapManager;
    private final AttachmentManager attachmentManager;

    @Autowired
    public MindMapContentExtractor(@ComponentImport @NonNull BootstrapManager bootstrapManager, @ComponentImport @NonNull AttachmentManager attachmentManager) {
        if (bootstrapManager == null) {
            throw new NullPointerException("bootstrapManager");
        }
        if (attachmentManager == null) {
            throw new NullPointerException("attachmentManager");
        }
        this.bootstrapManager = bootstrapManager;
        this.attachmentManager = attachmentManager;
    }

    public Collection<FieldDescriptor> extractFields(Object searchable) {
        String contentType;
        Attachment attachment;
        String fileName;
        ImmutableList.Builder fieldBuilder = new ImmutableList.Builder();
        if (searchable instanceof Attachment && this.shouldExtractFrom(fileName = (attachment = (Attachment)searchable).getLowerTitle(), contentType = attachment.getMediaType()) && this.hasEasyMindLabel(attachment)) {
            fieldBuilder.add(new StringFieldDescriptor("urlPath", this.getReadOnlyEditorURL(attachment), FieldDescriptor.Store.YES));
        }
        return fieldBuilder.build();
    }

    private boolean hasEasyMindLabel(Attachment attachment) {
        return attachment.getLabels().stream().anyMatch(label -> "easyMindModel".equalsIgnoreCase(label.getName()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean shouldExtractFrom(String fileName, String contentType) {
        if (Arrays.stream(this.getMatchingFileExtensions()).anyMatch(fileName::endsWith)) return true;
        if (!Arrays.stream(this.getMatchingContentTypes()).anyMatch(contentType::equalsIgnoreCase)) return false;
        return true;
    }

    public StringBuilder extractText(Object searchable) {
        StringBuilder topics = new StringBuilder();
        if (searchable instanceof Attachment) {
            Attachment attachment = (Attachment)searchable;
            if (!this.shouldExtractFrom(attachment.getLowerTitle(), attachment.getMediaType()) || !this.hasEasyMindLabel(attachment)) {
                return new StringBuilder();
            }
            try (InputStream inputStream = this.attachmentManager.getAttachmentData(attachment);){
                String json = new String(ByteStreams.toByteArray(inputStream), StandardCharsets.UTF_8);
                NamymapJsonTopicParser parser = new NamymapJsonTopicParser();
                Set<String> topicList = parser.parseTopicsFromJson(json);
                topics.append(String.join((CharSequence)" ", topicList));
            }
            catch (IOException | RuntimeException ex) {
                log.error("Error reading mind map JSON attachment", (Throwable)ex);
            }
        }
        return topics;
    }

    protected String[] getMatchingContentTypes() {
        return CONTENT_TYPES;
    }

    protected String[] getMatchingFileExtensions() {
        return EXTENSIONS;
    }

    private String getReadOnlyEditorURL(Attachment attachment) {
        ContentEntityObject attachmentPage = attachment.getContainer();
        String mindmapName = attachment.getFileName();
        String lastPage = HtmlUtil.urlEncode((String)(this.bootstrapManager.getWebAppContextPath() + (attachmentPage == null ? "" : attachmentPage.getUrlPath())));
        EditorParametersDto namymapEditorActionParams = EditorParametersDto.builder().pageId(attachment.getContainer() == null ? "" : String.valueOf(attachment.getContainer().getId())).mindmapName(mindmapName).lastPage(lastPage).isViewMode(true).legacyExternalStorage(null).build();
        return NamymapUtil.generateShowEditorURL("", namymapEditorActionParams);
    }
}

