/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.common.expimp.xmind.guts.xml;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import cz.morosystems.namymap.common.expimp.ExportImportUtils;
import cz.morosystems.namymap.common.expimp.xmind.XmindParsingException;
import cz.morosystems.namymap.common.expimp.xmind.XmindUtils;
import cz.morosystems.namymap.common.expimp.xmind.format.Style;
import cz.morosystems.namymap.common.expimp.xmind.format.TopicProperties;
import cz.morosystems.namymap.common.expimp.xmind.guts.AbstractXmindParser;
import cz.morosystems.namymap.common.expimp.xmind.guts.Labels;
import cz.morosystems.namymap.common.expimp.xmind.guts.MarkerReference;
import cz.morosystems.namymap.common.expimp.xmind.guts.MarkerReferences;
import cz.morosystems.namymap.common.expimp.xmind.guts.Notes;
import cz.morosystems.namymap.common.expimp.xmind.guts.export.StyleExport;
import cz.morosystems.namymap.common.expimp.xmind.guts.export.StylesExport;
import cz.morosystems.namymap.common.expimp.xmind.guts.export.XmapJsonExport;
import cz.morosystems.namymap.common.expimp.xmind.guts.export.XmapStylesExport;
import cz.morosystems.namymap.common.expimp.xmind.guts.json.XmindParser;
import cz.morosystems.namymap.common.expimp.xmind.guts.xml.Children;
import cz.morosystems.namymap.common.expimp.xmind.guts.xml.Sheet;
import cz.morosystems.namymap.common.expimp.xmind.guts.xml.Topic;
import cz.morosystems.namymap.common.expimp.xmind.guts.xml.Topics;
import cz.morosystems.namymap.common.expimp.xmind.guts.xml.XmapContent;
import cz.morosystems.namymap.common.expimp.xmind.guts.xml.XmapJson;
import cz.morosystems.namymap.common.expimp.xmind.guts.xml.XmapStyles;
import cz.morosystems.namymap.common.expimp.xmind.json.EasyDocument;
import cz.morosystems.namymap.common.expimp.xmind.json.EasyTopic;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.xpath.jaxp.XPathFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMindXmlParser
extends AbstractXmindParser
implements XmindParser {
    private static final Logger log = LoggerFactory.getLogger(XMindXmlParser.class);
    private static final String XMLNAMESPACE = "xmlns";
    private static final String XML_NS_FO = "fo";
    private static final String XML_NS_SVG = "svg";
    private XmapJson xmapJson;
    private XmapJsonExport xmapJsonExport;
    private EasyDocument easyDoc;
    private HashMap<String, Integer> styleIndex = new HashMap();
    private List<Style> styles;
    private List<StyleExport> styleListExport;
    private XPath xpath;

    @Override
    public String parseXMind(InputStream is) throws XmindParsingException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.parseXMindDocument(is);
            this.writeEasyMind(baos, "Document");
            return baos.toString("UTF-8");
        }
        catch (Throwable t2) {
            log.error("Error while parsing Xmind map.", t2);
            throw new XmindParsingException("Error while parsing Xmind map.", t2);
        }
    }

    @Override
    public boolean isValidFormat(InputStream is) {
        try {
            this.parseXMindDocument(is);
        }
        catch (Throwable t2) {
            log.error("Error occurred while validating Xmind format", t2);
            return false;
        }
        return true;
    }

    @Override
    public byte[] parseEasyMind(InputStream is) throws XmindParsingException {
        try {
            this.parseJSON(is);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.writeXMind(baos);
            baos.flush();
            baos.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            log.error("Error occured while parsing EasyMind.", (Throwable)e);
            throw new XmindParsingException("Error occured while parsing EasyMind.", e);
        }
    }

    private void writeEasyMind(OutputStream os, String documentName) throws IOException {
        this.writeJSONStream(os, documentName);
    }

    private void writeXMind(OutputStream os) throws IOException {
        this.writeXMindStream(os, "EasyMind");
    }

    private void parseJSON(InputStream is) throws IOException {
        ObjectMapper mapper = this.initObjectMapperForDeserialization();
        this.easyDoc = mapper.readValue(is, EasyDocument.class);
    }

    private void writeXMindPart(String source, Object value, ZipOutputStream zos) throws IOException {
        XmlMapper xmlMapper = new XmlMapper();
        xmlMapper.configure(ToXmlGenerator.Feature.WRITE_XML_DECLARATION, true);
        xmlMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        ZipEntry ze = new ZipEntry(source + ".xml");
        zos.putNextEntry(ze);
        zos.write(xmlMapper.writeValueAsBytes(value));
        zos.closeEntry();
        zos.flush();
    }

    private Topic convertEasyTopicToTopic(EasyTopic easyTopic) {
        String styleId = XmindUtils.randomString(26);
        Topic topic = new Topic(easyTopic, styleId);
        this.styleListExport.add(new StyleExport(styleId, easyTopic.getStyle()));
        if (null != easyTopic.getSubtopics()) {
            ArrayList<Topic> topicList = new ArrayList<Topic>();
            for (EasyTopic item : easyTopic.getSubtopics()) {
                topicList.add(this.convertEasyTopicToTopic(item));
            }
            topic.setChildren(new Children(new Topics(topicList)));
        }
        return topic;
    }

    private void convertToXMind(String sheetTitle) {
        this.styleListExport = new ArrayList<StyleExport>();
        EasyTopic easyTopic = this.easyDoc.getRootTopic();
        Sheet sheet = new Sheet(XmindUtils.randomString(26), easyTopic.getTimestamp().toString());
        sheet.setTitle(sheetTitle);
        sheet.setTopic(this.convertEasyTopicToTopic(easyTopic));
        ArrayList<Sheet> sheets = new ArrayList<Sheet>();
        sheets.add(sheet);
        this.xmapJsonExport = new XmapJsonExport(new XmapContent("2.0", sheets), new XmapStylesExport("2.0", new StylesExport(this.styleListExport)));
    }

    private void writeXMindStream(OutputStream os, String fileName) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(os));
        zos.setLevel(0);
        this.convertToXMind(fileName);
        this.writeXMindPart("content", this.xmapJsonExport.getXmapContent(), zos);
        this.writeXMindPart("styles", this.xmapJsonExport.getXmapStyles(), zos);
        zos.flush();
        zos.close();
    }

    private EasyDocument convertToJson(String documentNme) {
        Sheet sheet = this.xmapJson.getXmapContent().getSheet().get(0);
        Topic rootTopic = sheet.getTopic();
        TopicProperties style = this.getStyle(rootTopic.getStyleId()).map(Style::getTopicProperties).orElse(null);
        EasyTopic topic = new EasyTopic(rootTopic, style);
        if (null != rootTopic.getChildren()) {
            topic.getSubtopics().addAll(this.getEasyTopicChildren(rootTopic.getChildren().getTopics().getTopic()));
        }
        String backgroundColor = this.getStyle(sheet.getStyleId()).map(sheetSheet -> sheetSheet.getMapProperties().getFill()).orElse("#FFFFFF");
        return new EasyDocument(documentNme, backgroundColor, topic);
    }

    private List<EasyTopic> getEasyTopicChildren(List<Topic> list) {
        ArrayList<EasyTopic> childList = new ArrayList<EasyTopic>();
        for (Topic item : list) {
            TopicProperties style = this.getStyle(item.getStyleId()).map(Style::getTopicProperties).orElse(null);
            EasyTopic child = new EasyTopic(item, style);
            if (null != item.getChildren()) {
                child.setSubtopics(this.getEasyTopicChildren(item.getChildren().getTopics().getTopic()));
            }
            childList.add(child);
        }
        return childList;
    }

    private void writeJSONStream(OutputStream os, String document) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        OutputStreamWriter wr = new OutputStreamWriter(os, StandardCharsets.UTF_8);
        wr.write(mapper.writeValueAsString(this.convertToJson(document)));
        ((Writer)wr).flush();
    }

    private void parseXMindDocument(InputStream document) throws IOException, ParserConfigurationException, SAXException, XPathExpressionException {
        ZipEntry ze;
        ZipInputStream zis = new ZipInputStream(document);
        boolean hasContent = false;
        this.xmapJson = new XmapJson();
        while ((ze = zis.getNextEntry()) != null) {
            XmlMapper mapper;
            XmapStyles xmapStyles;
            XPathFactoryImpl xpathFact;
            Document doc;
            DocumentBuilder dBuilder;
            DocumentBuilderFactory dbFactory;
            if ("content.xml".equals(ze.getName())) {
                hasContent = true;
                ArrayList<Sheet> sheets = new ArrayList<Sheet>();
                dbFactory = ExportImportUtils.createSecureDocumentBuilderFactory();
                dBuilder = dbFactory.newDocumentBuilder();
                doc = dBuilder.parse(this.getInputStream(zis));
                doc.getDocumentElement().normalize();
                xpathFact = new XPathFactoryImpl();
                this.xpath = ((XPathFactory)xpathFact).newXPath();
                Node contentNode = (Node)this.xpath.evaluate("/xmap-content", doc, XPathConstants.NODE);
                NodeList sheetsList = (NodeList)this.xpath.evaluate("//sheet", contentNode, XPathConstants.NODESET);
                for (int i = 0; i < sheetsList.getLength(); ++i) {
                    sheets.add(this.getSheetObject(sheetsList.item(i)));
                }
                this.xmapJson.setXmapContent(new XmapContent(contentNode.getAttributes().getNamedItem("version").getNodeValue(), sheets));
                continue;
            }
            if (!"styles.xml".equals(ze.getName())) continue;
            InputStream inputStream = this.getInputStream(zis);
            dbFactory = ExportImportUtils.createSecureDocumentBuilderFactory();
            dBuilder = dbFactory.newDocumentBuilder();
            doc = dBuilder.parse(inputStream);
            doc.getDocumentElement().normalize();
            xpathFact = new XPathFactoryImpl();
            this.xpath = ((XPathFactory)xpathFact).newXPath();
            Element xmapNode = (Element)this.xpath.evaluate("/xmap-styles", doc, XPathConstants.NODE);
            boolean foNs = false;
            boolean svgNs = false;
            NamedNodeMap attributes = xmapNode.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node currentAttribute = attributes.item(i);
                if (currentAttribute == null || currentAttribute.getNodeName() == null || !currentAttribute.getNodeName().startsWith(XMLNAMESPACE)) continue;
                if (currentAttribute.getNodeName().equals("xmlns:fo")) {
                    foNs = true;
                    continue;
                }
                if (!currentAttribute.getNodeName().equals("xmlns:svg")) continue;
                svgNs = true;
            }
            if (!foNs || !svgNs) {
                if (!foNs) {
                    xmapNode.setAttribute("xmlns:fo", "http://www.w3.org/1999/XSL/Format");
                }
                if (!svgNs) {
                    xmapNode.setAttribute("xmlns:svg", "http://www.w3.org/2000/svg");
                }
                DOMSource source = new DOMSource(doc);
                StringWriter xmlAsWriter = new StringWriter();
                StreamResult result = new StreamResult(xmlAsWriter);
                try {
                    TransformerFactory.newInstance().newTransformer().transform(source, result);
                    inputStream = new ByteArrayInputStream(xmlAsWriter.toString().getBytes("UTF-8"));
                }
                catch (TransformerException e) {
                    log.warn("Unable to transform updated xml.", (Throwable)e);
                    inputStream.reset();
                }
            } else {
                inputStream.reset();
            }
            if ((xmapStyles = (mapper = new XmlMapper()).readValue(inputStream, XmapStyles.class)) == null || xmapStyles.getStyles() == null) continue;
            this.styles = xmapStyles.getStyles().getStyle();
            this.xmapJson.setXmapStyles(xmapStyles);
            if (!CollectionUtils.isNotEmpty(this.styles)) continue;
            ListIterator<Style> stylesIterator = this.styles.listIterator();
            while (stylesIterator.hasNext()) {
                Integer index = stylesIterator.nextIndex();
                Style style = stylesIterator.next();
                if (style == null) continue;
                this.styleIndex.put(style.getId(), index);
            }
        }
        if (!hasContent) {
            throw new IOException("Invalid file format");
        }
        zis.close();
    }

    private Sheet getSheetObject(Node sheetNode) throws XPathExpressionException {
        NamedNodeMap attributes = sheetNode.getAttributes();
        String timestamp = String.valueOf(new Date().getTime());
        if (attributes.getNamedItem("timestamp") != null) {
            timestamp = attributes.getNamedItem("timestamp").getNodeValue();
        }
        Sheet sheet = new Sheet(attributes.getNamedItem("id").getNodeValue(), timestamp);
        if (null != attributes.getNamedItem("style-id")) {
            sheet.setStyleId(attributes.getNamedItem("style-id").getNodeValue());
        }
        Node rootElement = (Node)this.xpath.evaluate("//topic", sheetNode, XPathConstants.NODE);
        String id = null;
        if (null != rootElement.getAttributes().getNamedItem("id")) {
            id = rootElement.getAttributes().getNamedItem("id").getNodeValue();
        }
        if (rootElement.getAttributes().getNamedItem("timestamp") != null) {
            timestamp = rootElement.getAttributes().getNamedItem("timestamp").getNodeValue();
        }
        Topic rootTopic = new Topic(id, timestamp);
        this.addTopicAttributes(rootTopic, rootElement);
        this.addTopicChildren(rootTopic, rootElement.getChildNodes());
        sheet.setTopic(rootTopic);
        Node titleNode = (Node)this.xpath.evaluate("title", sheetNode, XPathConstants.NODE);
        if (null != titleNode) {
            sheet.setTitle(titleNode.getTextContent());
        }
        return sheet;
    }

    private void addTopicAttributes(Topic topic, Node element) {
        if (null != element.getAttributes().getNamedItem("structure-class")) {
            topic.setStructure(element.getAttributes().getNamedItem("structure-class").getNodeValue());
        }
        if (null != element.getAttributes().getNamedItem("style-id")) {
            topic.setStyleId(element.getAttributes().getNamedItem("style-id").getNodeValue());
        }
        if (null != element.getAttributes().getNamedItem("branch")) {
            topic.setBranch(element.getAttributes().getNamedItem("branch").getNodeValue());
        }
        if (null != element.getAttributes().getNamedItem("xlink:href")) {
            topic.setHref(element.getAttributes().getNamedItem("xlink:href").getNodeValue());
        }
    }

    private List<MarkerReference> getMarkers(NodeList markerNodes) {
        ArrayList<MarkerReference> markList = new ArrayList<MarkerReference>();
        for (int i = 0; i < markerNodes.getLength(); ++i) {
            String id = markerNodes.item(i).getAttributes().getNamedItem("marker-id").getNodeValue();
            markList.add(new MarkerReference(id));
        }
        return markList;
    }

    private List<String> getLabels(NodeList labelNodes) {
        ArrayList<String> labels = new ArrayList<String>();
        for (int i = 0; i < labelNodes.getLength(); ++i) {
            labels.add(labelNodes.item(i).getTextContent());
        }
        return labels;
    }

    private void addTopicChildren(Topic topic, NodeList childrenList) {
        for (int i = 0; i < childrenList.getLength(); ++i) {
            Node node = childrenList.item(i);
            String nodeName = node.getNodeName();
            if ("title".equals(nodeName)) {
                topic.setTitle(node.getTextContent());
                continue;
            }
            if ("notes".equals(nodeName)) {
                for (int j = 0; j < node.getChildNodes().getLength(); ++j) {
                    Node subNode = node.getChildNodes().item(j);
                    String subNodeName = subNode.getNodeName();
                    if (!"plain".equals(subNodeName)) continue;
                    Notes notes = new Notes();
                    notes.setPlain(subNode.getTextContent());
                    topic.setNotes(notes);
                }
                continue;
            }
            if ("children".equals(nodeName)) {
                Topics children = new Topics(this.parseChildren(node.getFirstChild().getChildNodes()));
                topic.setChildren(new Children(children));
                continue;
            }
            if ("xhtml:img".equals(nodeName)) {
                NamedNodeMap children = node.getAttributes();
                continue;
            }
            if ("marker-refs".equals(nodeName)) {
                MarkerReferences refs = new MarkerReferences();
                refs.setMarkerRef(this.getMarkers(node.getChildNodes()));
                topic.setMarkerReferences(refs);
                continue;
            }
            if (!"labels".equals(nodeName)) continue;
            topic.setLabels(new Labels(this.getLabels(node.getChildNodes())));
        }
    }

    private ArrayList<Topic> parseChildren(NodeList childNodes) {
        ArrayList<Topic> children = new ArrayList<Topic>();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            String id = childNode.getAttributes().getNamedItem("id").getNodeValue();
            String timestamp = String.valueOf(new Date().getTime());
            if (childNode.getAttributes().getNamedItem("timestamp") != null) {
                timestamp = childNode.getAttributes().getNamedItem("timestamp").getNodeValue();
            }
            Topic child = new Topic(id, timestamp);
            this.addTopicAttributes(child, childNode);
            this.addTopicChildren(child, childNode.getChildNodes());
            children.add(child);
        }
        return children;
    }

    private Optional<Style> getStyle(String styleId) {
        return this.styles != null && null != styleId && !styleId.contains("$") ? Optional.of(this.styles.get(this.styleIndex.get(styleId))) : Optional.empty();
    }
}

