/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.common.expimp.xmind.guts.xml;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import cz.morosystems.namymap.common.Marker;
import cz.morosystems.namymap.common.expimp.xmind.MarkerMapping;
import cz.morosystems.namymap.common.expimp.xmind.XmindUtils;
import cz.morosystems.namymap.common.expimp.xmind.guts.Labels;
import cz.morosystems.namymap.common.expimp.xmind.guts.MarkerReference;
import cz.morosystems.namymap.common.expimp.xmind.guts.MarkerReferences;
import cz.morosystems.namymap.common.expimp.xmind.guts.Notes;
import cz.morosystems.namymap.common.expimp.xmind.guts.StructureType;
import cz.morosystems.namymap.common.expimp.xmind.guts.xml.Children;
import cz.morosystems.namymap.common.expimp.xmind.json.EasyTopic;
import cz.morosystems.namymap.common.expimp.xmind.xhtml.Image;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;

@JacksonXmlRootElement(localName="topic")
@JsonIgnoreProperties(ignoreUnknown=true)
public class Topic
implements Serializable {
    private String branch;
    private String id;
    private String title;
    private String timestamp;
    private String structure;
    private String styleId;
    private Children children;
    private String href;
    private Image img;
    private MarkerReferences markerReferences;
    private Notes notes;
    private Labels labels;

    public Topic() {
    }

    public Topic(EasyTopic topic, String styleId) {
        this.id = XmindUtils.randomString(26);
        this.timestamp = topic.getTimestamp().toString();
        this.title = topic.getTitle();
        this.styleId = styleId;
        this.labels = new Labels(topic.getLabels());
        if (topic.isCollapsed()) {
            this.branch = "folded";
        }
        if (!"notDefined".equals(topic.getStyle().getTopicStructureType())) {
            this.structure = StructureType.getXMindStructure(topic.getStyle().getTopicStructureType());
        }
        if (CollectionUtils.isNotEmpty(topic.getMarkers())) {
            List<MarkerReference> references = topic.getMarkers().stream().map(this::convertToXMindMarker).flatMap(marker -> marker.map(Stream::of).orElseGet(Stream::empty)).collect(Collectors.toList());
            this.markerReferences = new MarkerReferences(references);
        }
        if (!"notDefined".equals(topic.getHyperlink())) {
            this.href = topic.getHyperlink();
        }
        if (!"notDefined".equals(topic.getNote())) {
            this.notes = new Notes();
            this.notes.setPlain(topic.getNote());
        }
        if (CollectionUtils.isNotEmpty(topic.getLabels())) {
            this.labels = new Labels(topic.getLabels());
        }
    }

    private Optional<MarkerReference> convertToXMindMarker(Marker marker) {
        return MarkerMapping.XMIND_MARKERS.entrySet().stream().filter(xMindMarker -> marker == xMindMarker.getValue()).map(Map.Entry::getKey).findFirst().map(MarkerReference::new);
    }

    public Topic(String id, String timestamp) {
        this.id = id;
        this.timestamp = timestamp;
    }

    @JacksonXmlProperty(isAttribute=true)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @JacksonXmlProperty
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @JacksonXmlProperty(isAttribute=true)
    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JacksonXmlProperty(localName="children")
    public Children getChildren() {
        return this.children;
    }

    public void setChildren(Children children) {
        this.children = children;
    }

    @JacksonXmlProperty(isAttribute=true, localName="structure-class")
    public String getStructure() {
        return this.structure;
    }

    public void setStructure(String structure) {
        this.structure = structure;
    }

    @JacksonXmlProperty(isAttribute=true, localName="style-id")
    public String getStyleId() {
        return this.styleId;
    }

    public void setStyleId(String styleId) {
        this.styleId = styleId;
    }

    @JacksonXmlProperty(namespace="http://www.w3.org/1999/xhtml", localName="img")
    public Image getImg() {
        return this.img;
    }

    public void setImg(Image img) {
        this.img = img;
    }

    @JacksonXmlProperty(isAttribute=true)
    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    @JacksonXmlProperty(localName="marker-refs")
    public MarkerReferences getMarkerReferences() {
        return this.markerReferences;
    }

    public void setMarkerReferences(MarkerReferences markerReferences) {
        this.markerReferences = markerReferences;
    }

    @JacksonXmlProperty(localName="labels")
    public Labels getLabels() {
        return this.labels;
    }

    public void setLabels(Labels labels) {
        this.labels = labels;
    }

    @JacksonXmlProperty(isAttribute=true, localName="xlink:href")
    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public Notes getNotes() {
        return this.notes;
    }

    public void setNotes(Notes notes) {
        this.notes = notes;
    }
}

