/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.common.expimp.xmind.guts.json;

import cz.morosystems.namymap.common.expimp.ExportImportException;
import cz.morosystems.namymap.common.expimp.xmind.XmindParsingException;
import cz.morosystems.namymap.common.expimp.xmind.guts.AbstractXmindExporter;
import cz.morosystems.namymap.common.expimp.xmind.guts.json.XMindJsonParser;
import cz.morosystems.namymap.common.expimp.xmind.guts.json.XmindParser;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmindJsonExporter
extends AbstractXmindExporter {
    private static final Logger log = LoggerFactory.getLogger(XmindJsonExporter.class);
    final XmindParser xmindParser;

    public static XmindJsonExporter initXmindJsonExporter() {
        return new XmindJsonExporter(new XMindJsonParser());
    }

    private XmindJsonExporter(XmindParser xmindParser) {
        this.xmindParser = xmindParser;
    }

    @Override
    public byte[] export(String stringifiedMindmapJson, Long pageId, String mindmapName, Integer fileVersion) {
        try {
            return this.xmindParser.parseEasyMind(new ByteArrayInputStream(stringifiedMindmapJson.getBytes(StandardCharsets.UTF_8)));
        }
        catch (XmindParsingException e) {
            log.error("Unable to export EasyMind into XML Xmind.", (Throwable)e);
            throw new ExportImportException("Unable to export EasyMind into XML Xmind.", e);
        }
    }
}

