/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.common.expimp.xmind;

import java.util.Random;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmindUtils {
    private static final Logger log = LoggerFactory.getLogger(XmindUtils.class);
    private static final String AB = "0123456789abcdefghijklmnopqrstuvwxyz";
    private static final String ID = "0123456789";
    private static final Random RANDOM = new Random();

    private XmindUtils() {
    }

    public static long getLong(String value) {
        long result = 0L;
        try {
            if (!"notDefined".equals(value)) {
                result = Long.parseLong(value);
            }
        }
        catch (NumberFormatException e) {
            log.trace("Unable to convert " + value + " to long", (Throwable)e);
        }
        return result;
    }

    public static String randomString(int len) {
        String random = UUID.randomUUID().toString().replaceAll("\\-", "");
        if (random.length() >= len) {
            return random.substring(0, len);
        }
        StringBuilder sb = new StringBuilder(len);
        int iteration = len - random.length();
        sb.append(random);
        for (int i = 0; i < iteration; ++i) {
            sb.append(AB.charAt(RANDOM.nextInt(AB.length())));
        }
        return sb.toString();
    }

    public static String getEasyMindId() {
        return XmindUtils.randomID(13) + "_" + XmindUtils.randomID(17);
    }

    public static String getIntegerValue(String declare) {
        int length = declare.length();
        if (length > 2) {
            return declare.substring(0, length - 2);
        }
        return declare;
    }

    public static String generateRandomUUID() {
        return UUID.randomUUID().toString();
    }

    private static String randomID(int len) {
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            sb.append(ID.charAt(RANDOM.nextInt(ID.length())));
        }
        return sb.toString();
    }
}

