/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.common.expimp.freeplane.guts;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import cz.morosystems.namymap.common.CommonUtil;
import cz.morosystems.namymap.common.exception.EasyMindException;
import cz.morosystems.namymap.common.expimp.ExportImportUtils;
import cz.morosystems.namymap.common.expimp.RichTextContent;
import cz.morosystems.namymap.common.expimp.freeplane.entity.EasyDocument;
import cz.morosystems.namymap.common.expimp.freeplane.entity.EasyTopic;
import cz.morosystems.namymap.common.expimp.freeplane.entity.FreePlaneDocument;
import cz.morosystems.namymap.common.expimp.freeplane.entity.FreePlaneEdge;
import cz.morosystems.namymap.common.expimp.freeplane.entity.FreePlaneFont;
import cz.morosystems.namymap.common.expimp.freeplane.entity.FreePlaneHook;
import cz.morosystems.namymap.common.expimp.freeplane.entity.FreePlaneIcon;
import cz.morosystems.namymap.common.expimp.freeplane.entity.FreePlaneMapStyles;
import cz.morosystems.namymap.common.expimp.freeplane.entity.FreePlaneNode;
import cz.morosystems.namymap.common.expimp.freeplane.entity.FreePlaneStyleNode;
import cz.morosystems.namymap.common.expimp.freeplane.guts.EasyStyleDeserializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FreePlaneParser {
    private static final Logger log = LoggerFactory.getLogger(FreePlaneParser.class);
    private static final String AB = "abcdefghijklmnopqrstuvwxyz";
    private static final String ID = "0123456789";
    private static final String MAP_STYLE = "MapStyle";
    private static Random RND = new Random();
    private String structureType = null;
    private FreePlaneDocument freePlaneDocument;
    private EasyDocument easyDoc;
    private HashMap<String, FreePlaneStyleNode> styleHashMap;
    private List<FreePlaneStyleNode> styleList;
    private Document doc;

    private static String randomString(int len) {
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            sb.append(AB.charAt(RND.nextInt(AB.length())));
        }
        return sb.toString();
    }

    public static String randomID(int len) {
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            sb.append(ID.charAt(RND.nextInt(10)));
        }
        return sb.toString();
    }

    public static String getEasyMindId() {
        return FreePlaneParser.randomID(13) + "_" + FreePlaneParser.randomID(17);
    }

    public void parseEasyMind(InputStream em) throws IOException {
        this.easyDoc = this.parseEasyMindStream(em);
    }

    public void writeFreePlan(OutputStream fp) throws IOException {
        this.writeFreePlanDoc(fp);
    }

    public void parseFreePlan(InputStream fp) {
        try {
            this.freePlaneDocument = this.parseFreePlaneStream(fp);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new EasyMindException("Error while parsing Free Plane document.", e);
        }
    }

    public void writeEasyMind(OutputStream em, String docName) throws IOException {
        this.writeJSON(em, docName);
    }

    private EasyDocument parseEasyMindStream(InputStream in) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        SimpleModule module = new SimpleModule("BooleanDeserializerModule");
        module.addDeserializer(Boolean.class, new EasyStyleDeserializer());
        mapper.registerModule(module);
        return mapper.readValue(in, EasyDocument.class);
    }

    private void convertToFreePlane() {
        this.styleList = new ArrayList<FreePlaneStyleNode>();
        String styleId = FreePlaneParser.randomString(10);
        EasyTopic rootTopic = this.easyDoc.getRootTopic();
        FreePlaneNode root = new FreePlaneNode(rootTopic, styleId);
        this.styleList.add(new FreePlaneStyleNode(styleId, rootTopic.getStyle(), "notDefined"));
        if (null != rootTopic.getSubtopics()) {
            root.setNode(this.convertEasyTopicToFreePlaneNode(rootTopic.getSubtopics(), rootTopic.getStyle().getStrokeType()));
        }
        ArrayList<FreePlaneHook> hooks = new ArrayList<FreePlaneHook>();
        hooks.add(new FreePlaneHook(MAP_STYLE, rootTopic.getStyle().getTopicStructureType(), new FreePlaneMapStyles(this.styleList)));
        root.setHook(hooks);
        this.freePlaneDocument = new FreePlaneDocument(root);
    }

    private List<FreePlaneNode> convertEasyTopicToFreePlaneNode(List<EasyTopic> subtopics, String strokeType) {
        ArrayList<FreePlaneNode> children = new ArrayList<FreePlaneNode>(subtopics.size());
        for (EasyTopic child : subtopics) {
            String styleId = FreePlaneParser.randomString(10);
            FreePlaneNode node = new FreePlaneNode(child, styleId);
            children.add(node);
            this.styleList.add(new FreePlaneStyleNode(styleId, child.getStyle(), strokeType));
            if (null == child.getSubtopics()) continue;
            node.setNode(this.convertEasyTopicToFreePlaneNode(child.getSubtopics(), child.getStyle().getStrokeType()));
        }
        return children;
    }

    private void writeFreePlanDoc(OutputStream os) throws IOException {
        this.convertToFreePlane();
        XmlMapper mapper = new XmlMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        OutputStreamWriter out = new OutputStreamWriter(os, StandardCharsets.UTF_8);
        mapper.writeValue(out, (Object)this.freePlaneDocument);
        out.close();
    }

    private void writeJSON(OutputStream out, String docName) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.writeValue(out, this.convertToJson(docName));
    }

    private Object convertToJson(String docName) {
        String backgroundColor = "#FFFFFF";
        String rootStructureType = null;
        FreePlaneNode rootNode = this.freePlaneDocument.getNode();
        FreePlaneStyleNode style = this.getFreePlaneStyleNode(rootNode);
        for (FreePlaneHook hook : rootNode.getHook()) {
            if (!MAP_STYLE.equals(hook.getName())) continue;
            if (!"OUTLINE".equals(hook.getLayout())) break;
            rootStructureType = "logchart-left";
            this.structureType = "logchart-right";
            break;
        }
        EasyTopic topic = new EasyTopic(rootNode, style, rootStructureType);
        if (CollectionUtils.isNotEmpty(rootNode.getNode())) {
            topic.setSubtopics(this.getEasyTopicChildren(rootNode.getNode()));
        }
        return new EasyDocument(docName, backgroundColor, topic);
    }

    private FreePlaneStyleNode getFreePlaneStyleNode(FreePlaneNode rootNode) {
        FreePlaneStyleNode style = null != rootNode.getStyleRef() ? this.styleHashMap.get(rootNode.getStyleRef()) : (null != rootNode.getLocalizedStyleRef() ? this.styleHashMap.get(rootNode.getLocalizedStyleRef()) : this.styleHashMap.get("default"));
        return style;
    }

    private List<EasyTopic> getEasyTopicChildren(List<FreePlaneNode> nodes) {
        ArrayList<EasyTopic> childList = new ArrayList<EasyTopic>();
        for (FreePlaneNode item : nodes) {
            FreePlaneStyleNode style = this.getFreePlaneStyleNode(item);
            EasyTopic child = new EasyTopic(item, style, this.structureType);
            if (CollectionUtils.isNotEmpty(item.getNode())) {
                child.setSubtopics(this.getEasyTopicChildren(item.getNode()));
            }
            childList.add(child);
        }
        return childList;
    }

    private FreePlaneDocument parseFreePlaneStream(InputStream in) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory dbFactory = ExportImportUtils.createSecureDocumentBuilderFactory();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        this.doc = dBuilder.parse(in);
        this.doc.getDocumentElement().normalize();
        Node contentNode = this.doc.getFirstChild();
        FreePlaneDocument fpDocument = new FreePlaneDocument();
        for (int i = 0; i < contentNode.getChildNodes().getLength(); ++i) {
            if (!"node".equals(contentNode.getChildNodes().item(i).getNodeName())) continue;
            fpDocument.setNode(this.getTopicNode(contentNode.getChildNodes().item(i)));
        }
        return fpDocument;
    }

    private FreePlaneNode getTopicNode(Node topicNode) {
        FreePlaneNode topic = new FreePlaneNode();
        this.addTopicAttributes(topic, topicNode.getAttributes());
        if (topicNode.hasChildNodes()) {
            NodeList children = topicNode.getChildNodes();
            ArrayList<FreePlaneIcon> icons = new ArrayList<FreePlaneIcon>();
            ArrayList<FreePlaneHook> hooks = new ArrayList<FreePlaneHook>();
            ArrayList<FreePlaneNode> nodes = new ArrayList<FreePlaneNode>();
            block16: for (int i = 0; i < children.getLength(); ++i) {
                switch (children.item(i).getNodeName()) {
                    case "icon": {
                        icons.add(new FreePlaneIcon(children.item(i).getAttributes().getNamedItem("BUILTIN").getNodeValue()));
                        continue block16;
                    }
                    case "font": {
                        topic.setFont(this.getFont(children.item(i).getAttributes()));
                        continue block16;
                    }
                    case "hook": {
                        hooks.add(this.getHook(children.item(i)));
                        continue block16;
                    }
                    case "edge": {
                        topic.setEdge(this.getEdge(children.item(i).getAttributes()));
                        continue block16;
                    }
                    case "node": {
                        nodes.add(this.getTopicNode(children.item(i)));
                        continue block16;
                    }
                    case "richcontent": {
                        this.processRichContent(topic, children.item(i));
                        continue block16;
                    }
                    default: {
                        log.trace("Unknown value for node name {}", (Object)children.item(i).getNodeName());
                    }
                }
            }
            topic.setIcon(icons);
            topic.setHook(hooks);
            topic.setNode(nodes);
        }
        return topic;
    }

    private void processRichContent(FreePlaneNode topic, Node node) {
        String typeValue = Optional.ofNullable(node.getAttributes().getNamedItem("TYPE")).map(Node::getNodeValue).orElse("");
        if ("NOTE".equals(typeValue)) {
            topic.setNote(this.getRichText(FreePlaneParser.htmlNodeToString(node, false)));
        } else if ("NODE".equals(typeValue)) {
            topic.setText(FreePlaneParser.htmlNodeToString(node, true));
        }
    }

    private RichTextContent getRichText(String text) {
        return RichTextContent.builder().text(text).build();
    }

    private static String htmlNodeToString(Node node, boolean clean) {
        try {
            StringWriter sw = new StringWriter();
            Transformer t2 = TransformerFactory.newInstance().newTransformer();
            t2.setOutputProperty("omit-xml-declaration", "yes");
            t2.setOutputProperty("indent", "yes");
            t2.transform(new DOMSource(node), new StreamResult(sw));
            return CommonUtil.convertHtmlToPlainText(sw.toString(), clean);
        }
        catch (TransformerException e) {
            log.trace("Error while parsing xml to string.", (Throwable)e);
            return "";
        }
    }

    private FreePlaneHook getHook(Node item) {
        NamedNodeMap attributes = item.getAttributes();
        String name = attributes.getNamedItem("NAME").getNodeValue();
        FreePlaneHook hook = new FreePlaneHook(name);
        if (MAP_STYLE.equals(name)) {
            if (attributes.getNamedItem("layout") != null) {
                hook.setLayout(attributes.getNamedItem("layout").getNodeValue());
            }
            this.styleHashMap = new HashMap();
            NodeList mapStyles = this.doc.getElementsByTagName("map_styles");
            NodeList styles = mapStyles.item(0).getChildNodes();
            for (int i = 0; i < styles.getLength(); ++i) {
                if (!"stylenode".equals(styles.item(i).getNodeName())) continue;
                this.getStyle(styles.item(i));
            }
        }
        return hook;
    }

    private void getStyle(Node styleNode) {
        String name = null;
        NamedNodeMap attributes = styleNode.getAttributes();
        if (attributes.getNamedItem("TEXT") != null) {
            name = attributes.getNamedItem("TEXT").getNodeValue();
        } else if (attributes.getNamedItem("LOCALIZED_TEXT") != null) {
            name = attributes.getNamedItem("LOCALIZED_TEXT").getNodeValue();
        }
        FreePlaneStyleNode style = new FreePlaneStyleNode(name);
        if (attributes.getNamedItem("COLOR") != null) {
            style.setColor(attributes.getNamedItem("COLOR").getNodeValue());
        }
        if (attributes.getNamedItem("BACKGROUND_COLOR") != null) {
            style.setBackgroundColor(attributes.getNamedItem("BACKGROUND_COLOR").getNodeValue());
        }
        if (attributes.getNamedItem("STYLE") != null) {
            style.setStyle(attributes.getNamedItem("STYLE").getNodeValue());
        }
        if (styleNode.hasChildNodes()) {
            this.parseStyleChildNodes(style, styleNode.getChildNodes());
        }
        this.styleHashMap.put(name, style);
    }

    private void parseStyleChildNodes(FreePlaneStyleNode style, NodeList childNodes) {
        for (int i = 0; i < childNodes.getLength(); ++i) {
            String nodeName = childNodes.item(i).getNodeName();
            if ("font".equals(nodeName)) {
                style.setFont(this.getFont(childNodes.item(i).getAttributes()));
                continue;
            }
            if ("icon".equals(nodeName)) {
                style.setIcon(new FreePlaneIcon(childNodes.item(i).getAttributes().getNamedItem("BUILTIN").getNodeValue()));
                continue;
            }
            if (!"stylenode".equals(nodeName)) continue;
            this.getStyle(childNodes.item(i));
        }
    }

    private FreePlaneEdge getEdge(NamedNodeMap attributes) {
        FreePlaneEdge edge = new FreePlaneEdge();
        if (attributes.getNamedItem("STYLE") != null) {
            edge.setColor(attributes.getNamedItem("STYLE").getNodeValue());
        }
        if (attributes.getNamedItem("COLOR") != null) {
            edge.setColor(attributes.getNamedItem("COLOR").getNodeValue());
        }
        if (attributes.getNamedItem("WIDTH") != null) {
            edge.setColor(attributes.getNamedItem("WIDTH").getNodeValue());
        }
        return edge;
    }

    private FreePlaneFont getFont(NamedNodeMap attributes) {
        FreePlaneFont font = new FreePlaneFont();
        if (attributes.getNamedItem("NAME") != null) {
            font.setName(attributes.getNamedItem("NAME").getNodeValue());
        }
        if (attributes.getNamedItem("SIZE") != null) {
            font.setSize(Integer.valueOf(attributes.getNamedItem("SIZE").getNodeValue()));
        }
        if (attributes.getNamedItem("BOLD") != null) {
            font.setBold(Boolean.valueOf(attributes.getNamedItem("BOLD").getNodeValue()));
        }
        if (attributes.getNamedItem("ITALIC") != null) {
            font.setItalic(Boolean.valueOf(attributes.getNamedItem("ITALIC").getNodeValue()));
        }
        return font;
    }

    private void addTopicAttributes(FreePlaneNode topic, NamedNodeMap attributes) {
        topic.setId(attributes.getNamedItem("ID").getNodeValue());
        topic.setCreated(Long.valueOf(attributes.getNamedItem("CREATED").getNodeValue()));
        topic.setModified(Long.valueOf(attributes.getNamedItem("MODIFIED").getNodeValue()));
        if (attributes.getNamedItem("LOCALIZED_TEXT") != null) {
            topic.setLocalizedText(attributes.getNamedItem("LOCALIZED_TEXT").getNodeValue());
        } else if (attributes.getNamedItem("TEXT") != null) {
            topic.setText(attributes.getNamedItem("TEXT").getNodeValue());
        }
        if (attributes.getNamedItem("COLOR") != null) {
            topic.setColor(attributes.getNamedItem("COLOR").getNodeValue());
        }
        if (attributes.getNamedItem("BACKGROUND_COLOR") != null) {
            topic.setBackgroundColor(attributes.getNamedItem("BACKGROUND_COLOR").getNodeValue());
        }
        if (attributes.getNamedItem("STYLE_REF") != null) {
            topic.setStyleRef(attributes.getNamedItem("STYLE_REF").getNodeValue());
        } else if (attributes.getNamedItem("LOCALIZED_STYLE_REF") != null) {
            topic.setLocalizedStyleRef(attributes.getNamedItem("LOCALIZED_STYLE_REF").getNodeValue());
        }
        if (attributes.getNamedItem("POSITION") != null) {
            topic.setPosition(attributes.getNamedItem("POSITION").getNodeValue());
        }
        if (attributes.getNamedItem("LINK") != null) {
            topic.setLink(attributes.getNamedItem("LINK").getNodeValue());
        }
        if (attributes.getNamedItem("STYLE") != null) {
            topic.setStyle(attributes.getNamedItem("STYLE").getNodeValue());
        }
    }
}

