/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.common.expimp.freeplane.entity;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import cz.morosystems.namymap.common.Marker;
import cz.morosystems.namymap.common.expimp.RichTextContent;
import cz.morosystems.namymap.common.expimp.freeplane.MarkerMapping;
import cz.morosystems.namymap.common.expimp.freeplane.entity.EasyTopic;
import cz.morosystems.namymap.common.expimp.freeplane.entity.FreePlaneEdge;
import cz.morosystems.namymap.common.expimp.freeplane.entity.FreePlaneFont;
import cz.morosystems.namymap.common.expimp.freeplane.entity.FreePlaneHook;
import cz.morosystems.namymap.common.expimp.freeplane.entity.FreePlaneIcon;
import cz.morosystems.namymap.common.expimp.freeplane.guts.FreePlaneParser;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.Validate;

@JacksonXmlRootElement(localName="node")
public class FreePlaneNode {
    private String text;
    private String localizedText;
    private String position;
    private String styleRef;
    private String localizedStyleRef;
    private String id;
    private Long created;
    private Long modified;
    private String color;
    private String backgroundColor;
    private String link;
    private String style;
    private List<FreePlaneIcon> icon;
    private FreePlaneFont font;
    private List<FreePlaneHook> hook;
    private FreePlaneEdge edge;
    private List<FreePlaneNode> node;
    private RichTextContent note;

    public FreePlaneNode() {
    }

    public FreePlaneNode(EasyTopic easyTopic, String styleId) {
        this.id = "ID_" + FreePlaneParser.randomID(10);
        this.created = easyTopic.getTimestamp();
        this.modified = easyTopic.getTimestamp();
        this.text = easyTopic.getTitle();
        this.styleRef = styleId;
        if (CollectionUtils.isNotEmpty(easyTopic.getMarkers())) {
            this.icon = new LinkedList<FreePlaneIcon>();
            easyTopic.getMarkers().forEach(marker -> this.convertToFreePlaneIcon((Marker)((Object)marker)).ifPresent(this.icon::add));
        }
        if (!"notDefined".equals(easyTopic.getHyperlink())) {
            this.link = easyTopic.getHyperlink();
        }
        if (!"notDefined".equals(easyTopic.getNote())) {
            this.note = RichTextContent.builder().text(easyTopic.getNote()).type("NOTE").build();
        }
    }

    private Optional<FreePlaneIcon> convertToFreePlaneIcon(Marker marker) {
        Validate.notNull(marker);
        return MarkerMapping.FREE_PLANE_MARKERS.entrySet().stream().filter(markerMapping -> marker == markerMapping.getValue()).map(Map.Entry::getKey).findFirst().map(FreePlaneIcon::new);
    }

    @JacksonXmlProperty(isAttribute=true, localName="TEXT")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @JacksonXmlProperty(isAttribute=true, localName="LOCALIZED_TEXT")
    public String getLocalizedText() {
        return this.localizedText;
    }

    public void setLocalizedText(String localizedText) {
        this.localizedText = localizedText;
    }

    @JacksonXmlProperty(isAttribute=true, localName="POSITION")
    public String getPosition() {
        return this.position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    @JacksonXmlProperty(isAttribute=true, localName="STYLE_REF")
    public String getStyleRef() {
        return this.styleRef;
    }

    public void setStyleRef(String styleRef) {
        this.styleRef = styleRef;
    }

    @JacksonXmlProperty(isAttribute=true, localName="LOCALIZED_STYLE_REF")
    public String getLocalizedStyleRef() {
        return this.localizedStyleRef;
    }

    public void setLocalizedStyleRef(String localizedStyleRef) {
        this.localizedStyleRef = localizedStyleRef;
    }

    @JacksonXmlProperty(isAttribute=true, localName="ID")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @JacksonXmlProperty(isAttribute=true, localName="CREATED")
    public Long getCreated() {
        return this.created;
    }

    public void setCreated(Long created) {
        this.created = created;
    }

    @JacksonXmlProperty(isAttribute=true, localName="MODIFIED")
    public Long getModified() {
        return this.modified;
    }

    public void setModified(Long modified) {
        this.modified = modified;
    }

    @JacksonXmlProperty(isAttribute=true, localName="COLOR")
    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    @JacksonXmlProperty(isAttribute=true, localName="BACKGROUND_COLOR")
    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    @JacksonXmlProperty(isAttribute=true, localName="LINK")
    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    @JacksonXmlProperty(isAttribute=true, localName="STYLE")
    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    @JacksonXmlElementWrapper(useWrapping=false)
    public List<FreePlaneHook> getHook() {
        return this.hook;
    }

    public void setHook(List<FreePlaneHook> hook) {
        this.hook = hook;
    }

    @JacksonXmlProperty
    public FreePlaneFont getFont() {
        return this.font;
    }

    public void setFont(FreePlaneFont font) {
        this.font = font;
    }

    @JacksonXmlElementWrapper(useWrapping=false)
    public List<FreePlaneIcon> getIcon() {
        return this.icon;
    }

    public void setIcon(List<FreePlaneIcon> icon) {
        this.icon = icon;
    }

    @JacksonXmlProperty
    public FreePlaneEdge getEdge() {
        return this.edge;
    }

    public void setEdge(FreePlaneEdge edge) {
        this.edge = edge;
    }

    @JacksonXmlElementWrapper(useWrapping=false)
    public List<FreePlaneNode> getNode() {
        return this.node;
    }

    public void setNode(List<FreePlaneNode> node) {
        this.node = node;
    }

    @JacksonXmlProperty(localName="richcontent")
    public RichTextContent getNote() {
        return this.note;
    }

    public void setNote(RichTextContent note) {
        this.note = note;
    }
}

