/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.common.expimp.freeplane;

import cz.morosystems.namymap.common.expimp.ExportImportException;
import cz.morosystems.namymap.common.expimp.ExportImportValidationHandler;
import cz.morosystems.namymap.common.expimp.freeplane.guts.FreePlaneParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreePlaneExporterImporterValidator
implements ExportImportValidationHandler {
    private static final Logger log = LoggerFactory.getLogger(FreePlaneExporterImporterValidator.class);

    @Override
    public String importMindMap(InputStream in) {
        try {
            FreePlaneParser fpParser = new FreePlaneParser();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            fpParser.parseFreePlan(in);
            fpParser.writeEasyMind(baos, "Document");
            in.close();
            return baos.toString("UTF-8");
        }
        catch (Exception e) {
            throw new ExportImportException("Unable to parse freeplan format :" + e.getMessage(), e);
        }
    }

    @Override
    public boolean validate(InputStream in) {
        try {
            FreePlaneParser fpParser = new FreePlaneParser();
            fpParser.parseFreePlan(in);
            return true;
        }
        catch (Exception e) {
            log.warn("Unable to parse freeplane format :" + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public byte[] export(String stringifiedMindmapJson, Long pageId, String mindmapName, Integer fileVersion) {
        try {
            FreePlaneParser fp = new FreePlaneParser();
            fp.parseEasyMind(new ByteArrayInputStream(stringifiedMindmapJson.getBytes(StandardCharsets.UTF_8)));
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            fp.writeFreePlan(baos);
            return baos.toByteArray();
        }
        catch (Exception e) {
            log.error("Unable to convert to FreePlane :" + e.getMessage());
            throw new ExportImportException("Unable to convert to freeplane", e);
        }
    }

    @Override
    public String getContentType() {
        return "application/octet-stream";
    }

    @Override
    public String getExtension() {
        return "mm";
    }
}

