/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.common.expimp.freemind.guts;

import cz.morosystems.namymap.common.CommonUtil;
import cz.morosystems.namymap.common.Marker;
import cz.morosystems.namymap.common.expimp.freemind.MarkerMapping;
import cz.morosystems.namymap.common.expimp.freemind.common.JsonParsingTypeException;
import cz.morosystems.namymap.common.expimp.freemind.model.MindNode;
import cz.morosystems.namymap.common.expimp.freemind.model.impl.FreeMindNode;
import cz.morosystems.namymap.common.expimp.freemind.model.impl.FreeMindRootDto;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.Validate;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class FreeMindFromJsonConverter {
    public FreeMindRootDto convertFromJsonString(String json) throws IOException, ParseException {
        JSONObject jsonDocument;
        JSONObject jsonRootTopic;
        Validate.notBlank(json);
        StringReader reader = new StringReader(json);
        FreeMindRootDto freeMindRoot = new FreeMindRootDto();
        JSONParser jsonParser = new JSONParser();
        Object object = jsonParser.parse(reader);
        if (object instanceof JSONObject && (jsonRootTopic = (JSONObject)(jsonDocument = (JSONObject)object).get("rootTopic")) != null) {
            freeMindRoot.setRootNode(this.convertFromJsonNode(jsonRootTopic));
        }
        return freeMindRoot;
    }

    private MindNode convertFromJsonNode(JSONObject jsonTopic) {
        JSONArray jsonMarkers;
        FreeMindNode mindNode = new FreeMindNode();
        String topicTitle = this.getJsonString(jsonTopic, "title");
        mindNode.setText(topicTitle);
        boolean tpcCollapsed = this.getJsonBoolean(jsonTopic, "collapsed", false);
        mindNode.setFoldedDef(tpcCollapsed);
        JSONObject jsonStyle = this.getJsonObject(jsonTopic, "style");
        if (jsonStyle != null) {
            this.convertFromJsonStyle(jsonStyle, mindNode);
        }
        if ((jsonMarkers = this.getJsonArray(jsonTopic, "markers")) != null) {
            this.convertFromJsonMarkers(jsonMarkers, mindNode);
        }
        Optional.ofNullable(this.getJsonString(jsonTopic, "note")).ifPresent(mindNode::setNote);
        List<MindNode> childrenNodes = mindNode.getChildrenNodes();
        JSONArray jsonSubtopics = this.getJsonArray(jsonTopic, "subtopics");
        if (jsonSubtopics != null) {
            for (Object jsonSubtopic : jsonSubtopics) {
                childrenNodes.add(this.convertFromJsonNode((JSONObject)jsonSubtopic));
            }
        }
        return mindNode;
    }

    private void convertFromJsonStyle(JSONObject jsonStyle, MindNode mindNode) {
        Long styleSize = this.getJsonLong(jsonStyle, "fontSize");
        if (styleSize != null) {
            mindNode.setFontSize(styleSize.intValue());
        } else {
            String size = this.getJsonString(jsonStyle, "fontSize");
            if (size != null) {
                mindNode.setFontSize(Integer.valueOf(size));
            }
        }
        boolean styleBold = this.getJsonBoolean(jsonStyle, "fontBold", false);
        mindNode.setFontBoldDef(styleBold);
        boolean styleItalic = this.getJsonBoolean(jsonStyle, "fontItalic", false);
        mindNode.setFontItalicDef(styleItalic);
        String styleColor = this.getJsonString(jsonStyle, "fontColor");
        if (styleColor != null) {
            mindNode.setColorDef(styleColor);
        }
        String fontFamily = CommonUtil.getFirstFontFamilyFromStringList(this.getJsonString(jsonStyle, "fontFamily"));
        mindNode.setFontName(fontFamily);
    }

    private void convertFromJsonMarkers(JSONArray jsonMarkers, MindNode mindNode) {
        for (Object markerId : jsonMarkers) {
            if (markerId == null) continue;
            this.convertToFreeMindMarker((String)markerId).ifPresent(mindNode.getIcons()::add);
        }
    }

    private Optional<String> convertToFreeMindMarker(String markerId) {
        Validate.notBlank(markerId);
        return MarkerMapping.FREE_MIND_MARKERS.entrySet().stream().filter(marker -> Objects.equals(markerId, ((Marker)((Object)((Object)marker.getValue()))).name())).map(Map.Entry::getKey).findFirst();
    }

    private String getJsonString(JSONObject jsonObj, String name) {
        Object valueObj = jsonObj.get(name);
        if (valueObj == null) {
            return null;
        }
        if (valueObj instanceof String) {
            String value = (String)valueObj;
            if ("notDefined".equals(value)) {
                return null;
            }
            return value;
        }
        return null;
    }

    private Boolean getJsonBoolean(JSONObject jsonObj, String name, Boolean defaultValue) {
        Object valueObj = jsonObj.get(name);
        if (valueObj == null) {
            return defaultValue;
        }
        if (valueObj instanceof Boolean) {
            return (Boolean)valueObj;
        }
        if (valueObj instanceof String && "notDefined".equals(valueObj)) {
            return Boolean.FALSE;
        }
        throw new JsonParsingTypeException("JSON property is not type Boolean (type: " + valueObj.getClass().getSimpleName() + ", obj: " + valueObj + ")");
    }

    private Long getJsonLong(JSONObject jsonObj, String name) {
        Object valueObj = jsonObj.get(name);
        if (valueObj == null) {
            return null;
        }
        if (valueObj instanceof Long) {
            return (Long)valueObj;
        }
        return null;
    }

    private JSONArray getJsonArray(JSONObject jsonObj, String name) {
        Object valueObj = jsonObj.get(name);
        if (valueObj == null) {
            return null;
        }
        if (valueObj instanceof JSONArray) {
            return (JSONArray)valueObj;
        }
        throw new JsonParsingTypeException("JSON property is not type JSONArray (type: " + valueObj.getClass().getSimpleName() + ", obj: " + valueObj + ")");
    }

    private JSONObject getJsonObject(JSONObject jsonObj, String name) {
        Object valueObj = jsonObj.get(name);
        if (valueObj == null) {
            return null;
        }
        if (valueObj instanceof JSONObject) {
            return (JSONObject)valueObj;
        }
        throw new JsonParsingTypeException("JSON property is not type JSONObject (type: " + valueObj.getClass().getSimpleName() + ", obj: " + valueObj + ")");
    }
}

