/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.common.expimp.freemind;

import cz.morosystems.namymap.common.expimp.ExportImportException;
import cz.morosystems.namymap.common.expimp.ExportImportValidationHandler;
import cz.morosystems.namymap.common.expimp.freemind.guts.FreeMindFromJsonConverter;
import cz.morosystems.namymap.common.expimp.freemind.guts.FreeMindParser;
import cz.morosystems.namymap.common.expimp.freemind.guts.FreeMindToJsonConverter;
import cz.morosystems.namymap.common.expimp.freemind.model.impl.FreeMindRootDto;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.xml.stream.XMLStreamException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreeMindExporterImporterValidator
implements ExportImportValidationHandler {
    private static final Logger log = LoggerFactory.getLogger(FreeMindExporterImporterValidator.class);

    @Override
    public String importMindMap(InputStream in) {
        try {
            FreeMindToJsonConverter converter = new FreeMindToJsonConverter();
            FreeMindParser parser = new FreeMindParser();
            FreeMindRootDto root = parser.readFromStream(in);
            return converter.convertToJson(root);
        }
        catch (XMLStreamException e) {
            throw new ExportImportException("Unable to import from FreeMind :" + e.getMessage(), e);
        }
    }

    @Override
    public boolean validate(InputStream in) {
        try {
            return this.doValidate(in);
        }
        catch (Exception e) {
            throw new ExportImportException("Unable to import from FreeMind :" + e.getMessage(), e);
        }
    }

    private boolean doValidate(InputStream in) {
        FreeMindParser parser = new FreeMindParser();
        try {
            parser.readFromStream(in);
        }
        catch (XMLStreamException e) {
            log.info("Unable to validate FreeMind " + e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public byte[] export(String stringifiedMindmapJson, Long pageId, String mindmapName, Integer fileVersion) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            FreeMindFromJsonConverter converter = new FreeMindFromJsonConverter();
            FreeMindParser parser = new FreeMindParser();
            FreeMindRootDto freeMindRoot = converter.convertFromJsonString(stringifiedMindmapJson);
            parser.writeToStream(freeMindRoot, baos);
            return baos.toByteArray();
        }
        catch (Exception e) {
            throw new ExportImportException("Unable to export mind map to FreeMind :" + e.getMessage(), e);
        }
    }

    @Override
    public String getContentType() {
        return "application/octet-stream";
    }

    @Override
    public String getExtension() {
        return "mm";
    }
}

