/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.common.expimp.em;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import cz.morosystems.namymap.common.Constants;
import cz.morosystems.namymap.common.EasyMindVersionConverter;
import cz.morosystems.namymap.common.expimp.ExportImportValidationHandler;
import cz.morosystems.namymap.common.expimp.em.AbstractValidator;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EasyMindExporterImporterValidator
extends AbstractValidator
implements ExportImportValidationHandler {
    private static final Logger log = LoggerFactory.getLogger(EasyMindExporterImporterValidator.class);

    @Override
    public String importMindMap(InputStream in) throws IOException {
        return EasyMindVersionConverter.convertFromInputStream(in);
    }

    @Override
    public boolean validate(InputStream in) throws IOException {
        try {
            JsonNode doc = Constants.OBJECT_MAPPER.readTree(in);
            if (doc.get("name") == null) {
                return false;
            }
            JsonNode rootTopic = doc.get("rootTopic");
            if (rootTopic == null) {
                return false;
            }
            if (!this.isColor(rootTopic.get("backgroundColor"), true)) {
                return false;
            }
            return this.validateTopic(rootTopic);
        }
        catch (JsonParseException ex) {
            log.info("Invalid EasyMind format.", (Throwable)ex);
            return false;
        }
    }

    private boolean validateTopic(JsonNode topic) {
        if (log.isDebugEnabled()) {
            log.debug("Validate topic:" + topic.textValue());
        }
        if (topic.get("title") == null) {
            return false;
        }
        if (!this.isNumber(topic.get("timestamp"), true)) {
            return false;
        }
        if (!this.isBoolean(topic.get("collapsed"), true)) {
            return false;
        }
        if (!this.isURL(topic.get("hyperlink"), true)) {
            return false;
        }
        boolean validateStyle = this.validateStyle(topic);
        if (!validateStyle) {
            return false;
        }
        return this.validateSubTopics(topic);
    }

    private boolean validateStyle(JsonNode topic) {
        JsonNode style = topic.get("style");
        if (!this.isNumber(style.get("fontSize"), true)) {
            return false;
        }
        if (!this.isBoolean(style.get("fontBold"), true)) {
            return false;
        }
        if (!this.isBoolean(style.get("fontItalic"), true)) {
            return false;
        }
        if (!this.isBoolean(style.get("fontStrikeThrought"), true)) {
            return false;
        }
        if (!this.isColor(style.get("fontColor"), true)) {
            return false;
        }
        if (!this.isNumber(style.get("strokeWidth"), true)) {
            return false;
        }
        if (!this.isColor(style.get("strokeColor"), true)) {
            return false;
        }
        return this.isColor(style.get("color"), true);
    }

    private boolean validateSubTopics(JsonNode root) {
        ArrayNode subs = (ArrayNode)root.get("subtopics");
        if (subs != null) {
            for (JsonNode sub : subs) {
                boolean topicValid = this.validateTopic(sub);
                if (topicValid) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public byte[] export(String stringifiedMindmapJson, Long pageId, String mindmapName, Integer fileVersion) {
        return stringifiedMindmapJson.getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public String getContentType() {
        return "application/json";
    }

    @Override
    public String getExtension() {
        return "json";
    }
}

