/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.common.expimp.em;

import com.fasterxml.jackson.databind.JsonNode;
import cz.morosystems.namymap.common.expimp.SourceValidator;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Pattern;

public abstract class AbstractValidator
implements SourceValidator {
    private Pattern colorPattern = Pattern.compile("^#((?:[0-9a-fA-F]{3}){1,2}|(?:([0-9a-fA-F]{8})))$");

    protected boolean isNotDefined(JsonNode node) {
        return node == null || "".equals(node.textValue()) || "notDefined".equals(node.textValue());
    }

    protected boolean isColor(JsonNode node, boolean canBeNotDefined) {
        if (this.isNotDefined(node)) {
            return canBeNotDefined;
        }
        return this.colorPattern.matcher(node.textValue()).matches();
    }

    protected boolean isNumber(JsonNode node, boolean canBeNotDefined) {
        if (this.isNotDefined(node)) {
            return canBeNotDefined;
        }
        try {
            Long.parseLong(node.asText());
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    protected boolean isBoolean(JsonNode node, boolean canBeNotDefined) {
        if (this.isNotDefined(node)) {
            return canBeNotDefined;
        }
        return "true".equals(node.toString().toLowerCase().trim()) || "false".equals(node.toString().toLowerCase().trim());
    }

    protected boolean isURL(JsonNode node, boolean canBeNotDefined) {
        if (this.isNotDefined(node)) {
            return canBeNotDefined;
        }
        try {
            new URL(node.textValue());
        }
        catch (MalformedURLException e) {
            return false;
        }
        return true;
    }
}

