/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.common;

import com.fasterxml.jackson.databind.node.ObjectNode;
import cz.morosystems.namymap.common.Constants;
import cz.morosystems.namymap.common.enums.MindmapFormatVersion;
import java.io.IOException;
import org.apache.commons.lang3.Validate;

public final class InfrastructureUtil {
    private InfrastructureUtil() {
        throw new UnsupportedOperationException("Cannot create an instance of InfrastructureUtil.");
    }

    public static void addMindmapFormatVersion(ObjectNode rootNode) {
        Validate.notNull(rootNode);
        rootNode.put("formatVersion", MindmapFormatVersion.CURRENT.getValue());
    }

    public static String addMindmapFormatVersion(String stringifiedMindmapJson) throws IOException {
        if (stringifiedMindmapJson != null) {
            ObjectNode rootNode = (ObjectNode)Constants.OBJECT_MAPPER.readTree(stringifiedMindmapJson);
            InfrastructureUtil.addMindmapFormatVersion(rootNode);
            return rootNode.toString();
        }
        return null;
    }
}

