/**
 * It's used for adding "..." in confluence navbar. It's not used when you are adding macro on page.
 * This blueprint allows add mind map in "createEmpty" mode and "createFromTemplate"
 */
AJS.toInit(function($) {
	const NEW_DOCUMENT_INDEX = 0;
	const TEMPLATE_API = "{0}/plugins/servlet/namymaptemplate";
	const TEMPLATE_LIST_ACTION = "template_list";

	function onBlueprintSubmit(e, state) {
		if (window.sessionStorage) {
			// html element with options
			// "New document" -> create mode
			// list of templates -> template mode
			const selectElement = document.getElementById("templates");
			const selectedValue = selectElement.options[selectElement.selectedIndex].value;

			// edit doesn't mean edit mode
			sessionStorage.setItem("blueprintSubmitted", "true");
			if (selectElement.selectedIndex !== NEW_DOCUMENT_INDEX) {
				sessionStorage.setItem("blueprintTemplateKey", selectedValue);
			}
		}
	}

	function getTemplateList() {
		let templateList = null;
		const url = AJS.format(TEMPLATE_API, AJS.Confluence.getContextPath());
		jQuery.ajax({
			type: "POST",
			url: url,
			data: { templateAction: TEMPLATE_LIST_ACTION },
			success: function(result) {
				if (result.length) {
					templateList = result;
				}
			},
			async: false,
		});
		// we can do this because "async: false", TODO rewrite to async function
		return templateList;
	}

	function createSelectOption(text, value) {
		const optionElement = document.createElement("option");
		optionElement.text = text;
		optionElement.value = value;
		return optionElement;
	}
	
	function createBlueprintOptions(e, state) {
		const selectElement = document.getElementById("templates");

		const templateList = getTemplateList();

		const newDocumentOption = createSelectOption(AJS.I18n.getText("common.newMindmap"));
		selectElement.add(newDocumentOption, undefined);
		
		if (templateList != null) {
			for (let i = 0; i < templateList.length; i++) {
				selectElement.add(createSelectOption(templateList[i].name, templateList[i].key));
			}
		}
		// set select default value.
		selectElement.selectedIndex = NEW_DOCUMENT_INDEX;
	}

	Confluence.Blueprint.setWizard('cz.morosystems.atlassian.plugin.easymind:blueprint-item', function(wizard) {
        wizard.on("submit.namymapTemplate", onBlueprintSubmit);
        wizard.on("post-render.namymapTemplate", createBlueprintOptions);
    });
});
