/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal;

class TypePair<S, D> {
    private final Class<S> sourceType;
    private final Class<D> destinationType;
    private final String name;
    private final int hashCode;

    private TypePair(Class<S> sourceType, Class<D> destinationType, String name) {
        this.sourceType = sourceType;
        this.destinationType = destinationType;
        this.name = name;
        this.hashCode = this.computeHashCode();
    }

    static <T1, T2> TypePair<T1, T2> of(Class<T1> sourceType, Class<T2> destinationType, String name) {
        return new TypePair<T1, T2>(sourceType, destinationType, name);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof TypePair)) {
            return false;
        }
        TypePair otherPair = (TypePair)other;
        if (this.name == null ? otherPair.name != null : !this.name.equals(otherPair.name)) {
            return false;
        }
        return this.sourceType.equals(otherPair.sourceType) && this.destinationType.equals(otherPair.destinationType);
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        String str = this.sourceType.getName() + " to " + this.destinationType.getName();
        if (this.name != null) {
            str = str + " as " + this.name;
        }
        return str;
    }

    Class<D> getDestinationType() {
        return this.destinationType;
    }

    Class<S> getSourceType() {
        return this.sourceType;
    }

    private int computeHashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.sourceType.hashCode();
        result = 31 * result + this.destinationType.hashCode();
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }
}

