/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.server.servlet;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import cz.morosystems.namymap.common.enums.ImportExportFormat;
import cz.morosystems.namymap.common.expimp.ExportImportException;
import cz.morosystems.namymap.common.expimp.SourceValidator;
import cz.morosystems.namymap.server.NamymapUtil;
import cz.morosystems.namymap.server.service.dto.ValidationDto;
import cz.morosystems.namymap.server.servlet.ExportImportValidationServlet;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationServlet
extends ExportImportValidationServlet {
    private static final Logger log = LoggerFactory.getLogger(ValidationServlet.class);

    @Override
    protected void process(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Long pageId = this.getParameterLong(req, "pageId");
        String attachmentName = req.getParameter("attachmentName");
        try {
            if (pageId != null && attachmentName != null) {
                String format = req.getParameter("format");
                this.validateJson(format, resp, pageId, attachmentName);
            } else {
                this.validateUploadedFile(req, resp);
            }
        }
        catch (ExportImportException e) {
            log.error("Validation error: ", (Throwable)e);
            resp.sendError(400, "File validation error: " + e.getMessage());
        }
    }

    private void validateJson(String format, HttpServletResponse response, long pageId, String attachmentName) throws IOException {
        ContentEntityObject ceo = NamymapUtil.getContentEntityObject(pageId);
        Attachment attachment = ceo.getAttachmentNamed(attachmentName);
        SourceValidator validator = this.getValidator(ImportExportFormat.fromCodeDefaultEasyMind(format));
        boolean result = validator.validate(this.attachmentService.getAttachmentData(attachment));
        this.writeAsJsonToSuccessfulResponse(response, new ValidationDto(result));
    }

    private void validateUploadedFile(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String format = this.getParameter(request, "format");
        SourceValidator validator = this.getValidator(ImportExportFormat.fromCodeDefaultEasyMind(format));
        FileItem model = this.getMultipartParameter("model");
        boolean result = validator.validate(model.getInputStream());
        this.writeAsJsonToSuccessfulResponse(response, new ValidationDto(result));
    }
}

