/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.server.servlet;

import cz.morosystems.namymap.common.exception.NamymapException;
import cz.morosystems.namymap.server.model.NamymapTemplate;
import cz.morosystems.namymap.server.service.TemplateService;
import cz.morosystems.namymap.server.servlet.CommonWithDataServlet;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class TemplateServlet
extends CommonWithDataServlet {
    private static final Logger log = LoggerFactory.getLogger(TemplateServlet.class);
    @Autowired
    private TemplateService templateService;

    @Override
    protected void process(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String templateAction = this.getParameter(req, "templateAction");
        String templateKey = this.getParameter(req, "templateKey");
        if (StringUtils.isBlank((CharSequence)templateAction)) {
            resp.sendError(400, "Missing template action parameter.");
            return;
        }
        try {
            this.processTemplateAction(templateAction, templateKey, resp);
        }
        catch (NamymapException e) {
            resp.sendError(400, e.getMessage());
            log.error("Cannot process {} operation.", (Object)templateAction, (Object)e);
        }
    }

    private void processTemplateAction(String templateAction, String templateKey, HttpServletResponse resp) throws IOException {
        switch (StringUtils.lowerCase((String)templateAction)) {
            case "get_template": {
                Validate.notBlank((CharSequence)templateKey);
                NamymapTemplate template = this.templateService.getTemplate(templateKey);
                Validate.notNull((Object)template, (String)String.format("Template with key: %s has not been found", templateKey), (Object[])new Object[0]);
                this.writeAsJsonToSuccessfulResponse(resp, template.getMap());
                break;
            }
            case "template_list": {
                List<NamymapTemplate> templateList = this.templateService.getAllTemplates();
                this.writeAsJsonToSuccessfulResponse(resp, templateList);
                break;
            }
            default: {
                throw new NamymapException("Unsupported action parameter.");
            }
        }
    }
}

