/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.server.servlet;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import cz.morosystems.namymap.server.service.AttachmentService;
import cz.morosystems.namymap.server.service.dto.ConfluenceSpaceDto;
import cz.morosystems.namymap.server.service.dto.SearchDto;
import cz.morosystems.namymap.server.servlet.CommonWithDataServlet;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;

public class SearchAttachmentServlet
extends CommonWithDataServlet {
    @Autowired
    private AttachmentService attachmentService;

    @Override
    protected void process(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String spaceList = this.getParameter(req, "spaceList");
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (spaceList != null) {
            List<ConfluenceSpaceDto> availableSpaces = this.attachmentService.getAvailableSpaces(confluenceUser);
            this.writeAsJsonToSuccessfulResponse(resp, availableSpaces);
        } else {
            String searchParameter = this.getParameter(req, "search");
            String spaceKeyParameter = this.getParameter(req, "spaceKey");
            SearchDto searchDto = this.attachmentService.getSearchDto(searchParameter, spaceKeyParameter, confluenceUser);
            this.writeAsJsonToSuccessfulResponse(resp, searchDto);
        }
    }
}

