/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.server.servlet;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.User;
import cz.morosystems.namymap.common.InfrastructureUtil;
import cz.morosystems.namymap.common.exception.NamymapSecurityException;
import cz.morosystems.namymap.server.permission.PageEditObject;
import cz.morosystems.namymap.server.service.AttachmentService;
import cz.morosystems.namymap.server.service.dto.MindMapVersionDto;
import cz.morosystems.namymap.server.service.dto.SaveMindmapParamsDto;
import cz.morosystems.namymap.server.servlet.CommonWithDataServlet;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SaveMindmapServlet
extends CommonWithDataServlet {
    private static final Logger log = LoggerFactory.getLogger(SaveMindmapServlet.class);
    @Autowired
    private AttachmentService attachmentService;

    @Override
    protected void process(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        SaveMindmapParamsDto saveMindmapParams = this.getSaveMindmapParams(req);
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (saveMindmapParams.getStringifiedMindmapImage() == null || saveMindmapParams.getStringifiedMindmapJson() == null) {
            resp.sendError(400, String.format("Invalid parameters dataImage=%s, dataJson=%s", saveMindmapParams.getStringifiedMindmapImage(), saveMindmapParams.getStringifiedMindmapJson()));
            return;
        }
        if (saveMindmapParams.getPageId() == null) {
            resp.sendError(400, "Page ID cannot be null.");
            return;
        }
        try {
            PageEditObject eo = new PageEditObject(saveMindmapParams.getPageId());
            eo.checkUserPermission((User)AuthenticatedUserThreadLocal.get());
        }
        catch (NamymapSecurityException se) {
            log.error("Load Mind Map failed, unauthorized: ", (Throwable)se);
            resp.sendError(401, se.getMessage());
            return;
        }
        MindMapVersionDto mindMapVersionDto = this.attachmentService.saveMindMap(saveMindmapParams, confluenceUser);
        this.writeAsJsonToSuccessfulResponse(resp, mindMapVersionDto);
    }

    private SaveMindmapParamsDto getSaveMindmapParams(HttpServletRequest req) throws IOException {
        Long pageId = this.getParameterLong(req, "pageId");
        String mindmapName = this.getParameter(req, "mindmapName");
        String stringifiedMindmapImage = this.getParameter(req, "stringifiedMindmapImage");
        String stringifiedMindmapJson = this.getParameter(req, "stringifiedMindmapJson");
        String stringifiedMindmapJsonWithFormatVersion = InfrastructureUtil.addMindmapFormatVersion(stringifiedMindmapJson);
        return SaveMindmapParamsDto.builder().pageId(pageId).mindmapName(mindmapName).stringifiedMindmapJson(stringifiedMindmapJsonWithFormatVersion).stringifiedMindmapImage(stringifiedMindmapImage).build();
    }
}

