/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.server.servlet;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import cz.morosystems.namymap.common.enums.ImportExportFormat;
import cz.morosystems.namymap.common.exception.NamymapSecurityException;
import cz.morosystems.namymap.common.expimp.ExportDto;
import cz.morosystems.namymap.common.expimp.SourceExporter;
import cz.morosystems.namymap.server.service.ExportService;
import cz.morosystems.namymap.server.servlet.ExportImportValidationServlet;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ExportMapServlet
extends ExportImportValidationServlet {
    private static final Logger log = LoggerFactory.getLogger(ExportMapServlet.class);
    @Autowired
    private ExportService exportService;

    @Override
    protected void process(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Long pageId = this.getParameterLong(req, "pageId");
        String mindmapName = this.getParameter(req, "mindmapName");
        Integer version = this.getParameterInteger(req, "version");
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        try {
            this.checkReadPermissions(pageId, confluenceUser);
        }
        catch (NamymapSecurityException se) {
            log.error("Export Mind Map failed, unauthorized: ", (Throwable)se);
            resp.sendError(401, se.getMessage());
            return;
        }
        String format = this.getParameter(req, "format");
        SourceExporter exporter = this.getExporter(ImportExportFormat.fromCodeDefaultEasyMind(format));
        ExportDto export = this.exportService.getExport(pageId, mindmapName, version, exporter);
        resp.setHeader("Content-Disposition", String.format("attachment; filename=\"%s\"", export.getFileName()));
        this.writeAsByteArrayToSuccessfulResponse(resp, export.getData(), exporter.getContentType());
    }
}

