/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.server.servlet;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import cz.morosystems.namymap.common.exception.EasyMindException;
import cz.morosystems.namymap.common.exception.NamymapException;
import cz.morosystems.namymap.server.servlet.CommonServlet;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonWithDataServlet
extends CommonServlet {
    private static final Logger log = LoggerFactory.getLogger(CommonWithDataServlet.class);
    private Map<String, FileItem> multipartParams = new HashMap<String, FileItem>();

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (confluenceUser != null) {
            this.setRequestEncodingToUtf8(req);
            this.initMultipartParams(req);
            this.process(req, resp);
            this.clearServletState();
        } else {
            resp.sendError(401, "User not logged in.");
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (confluenceUser != null) {
            this.setRequestEncodingToUtf8(req);
            this.initMultipartParams(req);
            this.process(req, resp);
            this.clearServletState();
        } else {
            resp.sendError(401, "User not logged in.");
        }
    }

    private void setRequestEncodingToUtf8(@NonNull HttpServletRequest request) {
        if (request == null) {
            throw new NullPointerException("request");
        }
        try {
            request.setCharacterEncoding(StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new NamymapException("Cannot create common servlet data DTO due to unsupported character encoding.", e);
        }
    }

    private void initMultipartParams(@NonNull HttpServletRequest request) {
        if (request == null) {
            throw new NullPointerException("request");
        }
        if (this.containsMultipartData(request)) {
            this.multipartParams = CommonWithDataServlet.parseMultipartData(request);
        }
    }

    private boolean containsMultipartData(HttpServletRequest request) {
        Validate.notNull((Object)request);
        return StringUtils.startsWithIgnoreCase((CharSequence)request.getContentType(), (CharSequence)"multipart/");
    }

    private static Map<String, FileItem> parseMultipartData(HttpServletRequest request) {
        Validate.notNull((Object)request);
        try {
            List items = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory()).parseRequest(request);
            return CollectionUtils.isEmpty((Collection)items) ? new HashMap<String, FileItem>() : items.stream().map(item -> new AbstractMap.SimpleEntry<String, FileItem>(item.getFieldName(), (FileItem)item)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        catch (FileUploadException e) {
            throw new EasyMindException("Cannot parse multipart request.", e);
        }
    }

    Long getParameterLong(HttpServletRequest request, String paramName) {
        String parameter = this.getParameter(request, paramName);
        return parameter == null ? null : Long.valueOf(Long.parseLong(parameter));
    }

    Integer getParameterInteger(HttpServletRequest request, String paramName) {
        String parameter = this.getParameter(request, paramName);
        return parameter == null ? null : Integer.valueOf(Integer.parseInt(parameter));
    }

    Boolean getParameterBoolean(HttpServletRequest request, String paramName) {
        String parameter = this.getParameter(request, paramName);
        return parameter == null ? null : Boolean.valueOf(Boolean.parseBoolean(parameter));
    }

    String getParameter(HttpServletRequest request, String paramName) {
        Validate.notNull((Object)request);
        Validate.notBlank((CharSequence)paramName);
        String param = request.getParameter(paramName);
        if (StringUtils.isNotBlank((CharSequence)param) && !param.startsWith("$")) {
            return param;
        }
        if (this.containsMultipartData(request)) {
            return this.getMultipartParameterString(paramName);
        }
        return null;
    }

    private String getMultipartParameterString(String paramName) {
        FileItem fileItem = this.getMultipartParameter(paramName);
        try {
            return fileItem == null ? null : fileItem.getString(StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new EasyMindException(String.format("Cannot get a string value of multipart parameter %s due to unsupported encoding: %s", paramName, StandardCharsets.UTF_8.name()), e);
        }
    }

    FileItem getMultipartParameter(String paramName) {
        Validate.notBlank((CharSequence)paramName);
        Validate.notNull(this.multipartParams);
        return this.multipartParams.get(paramName);
    }

    private void clearServletState() {
        this.multipartParams = new HashMap<String, FileItem>();
    }

    protected abstract void process(HttpServletRequest var1, HttpServletResponse var2) throws ServletException, IOException;
}

