/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.server.servlet;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import cz.morosystems.namymap.common.exception.NamymapSecurityException;
import cz.morosystems.namymap.server.autosave.AutoSaveAction;
import cz.morosystems.namymap.server.autosave.PageAutoSaveData;
import cz.morosystems.namymap.server.autosave.impl.AutoSaveActionFactory;
import cz.morosystems.namymap.server.service.AutoSaveService;
import cz.morosystems.namymap.server.servlet.CommonWithDataServlet;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class AutoSaveServlet
extends CommonWithDataServlet {
    private static final Logger log = LoggerFactory.getLogger(AutoSaveServlet.class);
    @Autowired
    private AutoSaveService autoSave;

    @Override
    protected void process(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Long pageId = this.getParameterLong(req, "pageId");
        String mindmapName = this.getParameter(req, "mindmapName");
        String actionType = this.getParameter(req, "action");
        String mindMapContent = this.getParameter(req, "stringifiedMindmapJson");
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        Validate.notNull((Object)pageId);
        Validate.notNull((Object)mindmapName);
        try {
            AutoSaveAction saveAction = AutoSaveActionFactory.getInstance(actionType);
            PageAutoSaveData autoSaveData = new PageAutoSaveData(confluenceUser.getName(), mindmapName, mindMapContent, pageId);
            saveAction.processAutoSaveAction(this.autoSave, resp, autoSaveData);
        }
        catch (IllegalArgumentException e) {
            log.error("Auto-save failed, bad request: ", (Throwable)e);
            resp.sendError(400, e.getMessage());
        }
        catch (NamymapSecurityException e) {
            log.error("Auto-save failed, unauthorized: ", (Throwable)e);
            resp.sendError(401, e.getMessage());
        }
    }
}

