/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.server.service.impl;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.fasterxml.jackson.databind.ObjectMapper;
import cz.morosystems.namymap.common.EasyMindVersionConverter;
import cz.morosystems.namymap.common.exception.EasyMindException;
import cz.morosystems.namymap.server.model.AttachmentLoadObject;
import cz.morosystems.namymap.server.model.AttachmentObject;
import cz.morosystems.namymap.server.model.NamymapTemplate;
import cz.morosystems.namymap.server.service.TemplateService;
import cz.morosystems.namymap.server.service.dto.TemplateDto;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TemplateServiceImpl
implements TemplateService {
    private static final Logger log = LoggerFactory.getLogger(TemplateServiceImpl.class);
    private static final String KEY_TEMPLATES = "cz.morosystems.namymap.model.template.all";
    private final BandanaManager bandanaManager;

    @Autowired
    public TemplateServiceImpl(@ComponentImport @NonNull BandanaManager bandanaManager) {
        if (bandanaManager == null) {
            throw new NullPointerException("bandanaManager");
        }
        this.bandanaManager = bandanaManager;
    }

    @Override
    public List<NamymapTemplate> getAllTemplates() {
        return ((Map)Optional.ofNullable(this.getAllTemplatesHashMap()).orElse(new HashMap())).values().stream().sorted((o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName())).collect(Collectors.toList());
    }

    @Override
    public TemplateDto saveOrUpdateTemplate(NamymapTemplate template) {
        return this.saveOrUpdateTemplate(template.getKey(), template.getName(), template.getMap());
    }

    @Override
    public TemplateDto saveOrUpdateTemplate(String key, String name, String mindmap) {
        Validate.notBlank((CharSequence)mindmap);
        String updatedKey = StringUtils.isBlank((CharSequence)key) ? this.saveTemplate(name, mindmap) : this.updateTemplate(key, name, mindmap);
        return TemplateDto.builder().key(updatedKey).build();
    }

    @Override
    public AttachmentLoadObject getTemplateAttachmentLoadObject(String key) throws IOException {
        Validate.notBlank((CharSequence)key);
        NamymapTemplate template = this.getTemplate(key);
        AttachmentObject templateFile = new AttachmentObject();
        templateFile.setDate(new Date());
        templateFile.setFileVersion("0");
        templateFile.setJson(template.getMap());
        return AttachmentLoadObject.fromAttachmentObject(templateFile);
    }

    @Override
    public NamymapTemplate getTemplate(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            log.error("Parameter 'key' is required.");
            return null;
        }
        Map<String, NamymapTemplate> templates = this.getAllTemplatesHashMap();
        return templates.get(key);
    }

    @Override
    public void remove(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            log.error("Parameter 'key' is required.");
            return;
        }
        Map<String, NamymapTemplate> templates = this.getAllTemplatesHashMap();
        templates.remove(key);
        this.setAllTemplatesHashMap(templates);
    }

    @Override
    public void rename(String key, String name) {
        if (StringUtils.isBlank((CharSequence)key)) {
            log.error("Parameter 'key' is required.");
            return;
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            log.error("Parameter 'name' is required.");
            return;
        }
        Map<String, NamymapTemplate> templates = this.getAllTemplatesHashMap();
        NamymapTemplate nt = templates.get(key);
        nt.setName(name);
        this.setAllTemplatesHashMap(templates);
    }

    private Map<String, NamymapTemplate> getAllTemplatesHashMap() {
        Object o = this.bandanaManager.getValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, KEY_TEMPLATES);
        if (!(o instanceof HashMap)) {
            this.bandanaManager.removeValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, KEY_TEMPLATES);
            HashMap<String, NamymapTemplate> templates = new HashMap<String, NamymapTemplate>();
            this.setAllTemplatesHashMap(templates);
        }
        return ((HashMap)this.bandanaManager.getValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, KEY_TEMPLATES)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, TemplateServiceImpl::convertTemplateToCurrentVersion));
    }

    private static NamymapTemplate convertTemplateToCurrentVersion(@NonNull Map.Entry<String, NamymapTemplate> entrySet) {
        NamymapTemplate template;
        if (entrySet == null) {
            throw new NullPointerException("entrySet");
        }
        try {
            template = entrySet.getValue();
        }
        catch (ClassCastException ignored) {
            ObjectMapper oMapper = new ObjectMapper();
            Map tmp = oMapper.convertValue((Object)entrySet.getValue(), Map.class);
            template = new NamymapTemplate();
            template.setName((String)tmp.get("name"));
            template.setKey((String)tmp.get("key"));
            template.setMap((String)tmp.get("map"));
        }
        try {
            String convertedMap = EasyMindVersionConverter.convertFromString(template.getMap());
            template.setMap(convertedMap);
            return template;
        }
        catch (IOException e) {
            throw new EasyMindException("Cannot convert a mind map from old Easy Mind version.", e);
        }
    }

    private void setAllTemplatesHashMap(Map<String, NamymapTemplate> hashMap) {
        this.bandanaManager.setValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, KEY_TEMPLATES, hashMap);
    }

    private String saveTemplate(String name, String mindmap) {
        if (StringUtils.isBlank((CharSequence)name)) {
            log.error("Parameter 'name' is required.");
            return null;
        }
        String hashBase = name + new Date().getTime();
        String key = String.valueOf(hashBase.hashCode());
        NamymapTemplate newTemplate = new NamymapTemplate();
        newTemplate.setName(name);
        newTemplate.setMap(mindmap);
        newTemplate.setKey(key);
        Map<String, NamymapTemplate> templates = this.getAllTemplatesHashMap();
        templates.put(newTemplate.getKey(), newTemplate);
        this.setAllTemplatesHashMap(templates);
        return key;
    }

    private String updateTemplate(String key, String name, String mindmap) {
        Validate.notBlank((CharSequence)key);
        NamymapTemplate template = this.getTemplate(key);
        if (null != template) {
            if (!StringUtils.isBlank((CharSequence)name)) {
                template.setName(name);
            }
            template.setMap(mindmap);
            Map<String, NamymapTemplate> templates = this.getAllTemplatesHashMap();
            templates.remove(key);
            templates.put(key, template);
            this.setAllTemplatesHashMap(templates);
        }
        return key;
    }
}

