/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.server.service.impl;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import cz.morosystems.namymap.server.service.LicenseService;
import cz.morosystems.namymap.server.service.RompLcceService;
import cz.morosystems.namymap.server.service.dto.LicenseDto;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LicenseServiceImpl
implements LicenseService {
    private static final Logger log = LoggerFactory.getLogger(LicenseServiceImpl.class);
    private final transient PluginLicenseManager licenseManager;
    private final transient RompLcceService rompLcce;

    @Autowired
    public LicenseServiceImpl(@ComponentImport @NonNull PluginLicenseManager licenseManager, @NonNull RompLcceService rompLcce) {
        if (licenseManager == null) {
            throw new NullPointerException("licenseManager");
        }
        if (rompLcce == null) {
            throw new NullPointerException("rompLcce");
        }
        this.licenseManager = licenseManager;
        this.rompLcce = rompLcce;
    }

    @Override
    public LicenseDto getLicense() {
        LicenseDto pluginLicenseDto = new LicenseDto();
        if (this.rompLcce.isRompLcce()) {
            Option licenseOption = this.licenseManager.getLicense();
            if (licenseOption.isDefined()) {
                PluginLicense license = (PluginLicense)licenseOption.get();
                boolean isValid = !license.getError().isDefined() || license.getError().get() == LicenseError.EXPIRED && !license.isEvaluation();
                pluginLicenseDto.setValid(isValid);
            }
        } else {
            pluginLicenseDto.setValid(true);
        }
        return pluginLicenseDto;
    }
}

