/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.server.service.impl;

import com.atlassian.confluence.pages.Attachment;
import cz.morosystems.namymap.common.expimp.ExportDto;
import cz.morosystems.namymap.common.expimp.ExportImportUtils;
import cz.morosystems.namymap.common.expimp.SourceExporter;
import cz.morosystems.namymap.server.service.AttachmentService;
import cz.morosystems.namymap.server.service.ExportService;
import java.io.IOException;
import lombok.NonNull;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExportServiceImpl
implements ExportService {
    @Autowired
    private AttachmentService attachmentService;

    @Override
    public ExportDto getExport(long pageId, @NonNull String mindmapName, Integer version, SourceExporter exporter) throws IOException {
        if (mindmapName == null) {
            throw new NullPointerException("mindmapName");
        }
        Validate.notNull((Object)mindmapName);
        Validate.notNull((Object)exporter);
        Attachment attachment = this.attachmentService.loadModel(pageId, mindmapName, version);
        String json = this.attachmentService.getAttachmentDataAsJson(attachment);
        byte[] export = exporter.export(json, pageId, mindmapName, version);
        String fileName = ExportImportUtils.changeExtension(attachment.getFileName(), exporter.getExtension());
        return ExportDto.builder().fileName(fileName).data(export).build();
    }
}

