/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.server.service.impl;

import com.atlassian.confluence.core.BodyContent;
import com.atlassian.confluence.core.BodyType;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.Modification;
import com.atlassian.confluence.internal.search.v2.lucene.LuceneSearchResults;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.CommentManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.search.v2.ContentSearch;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchResults;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.query.BooleanQuery;
import com.atlassian.confluence.search.v2.query.ContentTypeQuery;
import com.atlassian.confluence.search.v2.query.InSpaceQuery;
import com.atlassian.confluence.search.v2.query.LabelQuery;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.SpaceStatus;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import cz.morosystems.namymap.common.CommonUtil;
import cz.morosystems.namymap.common.helper.ContentMacro;
import cz.morosystems.namymap.common.helper.MacroModifier;
import cz.morosystems.namymap.server.ContentSearchCriteria;
import cz.morosystems.namymap.server.model.ContentSearchResult;
import cz.morosystems.namymap.server.search.ContentSearchTransformer;
import cz.morosystems.namymap.server.service.ContentService;
import cz.morosystems.namymap.server.service.dto.MacroInfoDto;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ContentServiceImpl
implements ContentService {
    private static final Logger log = LoggerFactory.getLogger(ContentServiceImpl.class);
    private static final String PARAM_DEF_END = "</ac:parameter>";
    private static final String PARAM_NAME = "name";
    private static final String PARAM_MODEL_FN = "modelFN";
    private static final String PARAM_MODEL_PAGE_ID = "modelPageId";
    private final SearchManager searchManager;
    private final SpaceManager spaceManager;
    private final PageManager pageManager;
    private final CommentManager commentManager;

    @Autowired
    public ContentServiceImpl(@ComponentImport @NonNull SearchManager searchManager, @ComponentImport @NonNull SpaceManager spaceManager, @ComponentImport @NonNull PageManager pageManager, @ComponentImport @NonNull CommentManager commentManager) {
        if (searchManager == null) {
            throw new NullPointerException("searchManager");
        }
        if (spaceManager == null) {
            throw new NullPointerException("spaceManager");
        }
        if (pageManager == null) {
            throw new NullPointerException("pageManager");
        }
        if (commentManager == null) {
            throw new NullPointerException("commentManager");
        }
        this.searchManager = searchManager;
        this.spaceManager = spaceManager;
        this.pageManager = pageManager;
        this.commentManager = commentManager;
    }

    @Override
    public Set<ContentSearchResult> findConfluencePages(ContentSearchCriteria searchCriteria) {
        ArrayList<SearchQuery> searchQuery = new ArrayList<SearchQuery>();
        searchQuery.add((SearchQuery)new LabelQuery(searchCriteria.getFullTextString()));
        searchQuery.add((SearchQuery)new ContentTypeQuery(ContentTypeEnum.PAGE));
        return this.findConfluenceContent(searchCriteria, searchQuery);
    }

    @Override
    public void removeMacroFromPage(Long pageId, String mindmapName) {
        this.modifyMacroInPage(pageId, mindmapName, macro -> "");
    }

    @Override
    public void renameMacroInPage(Long pageId, String oldMindmapName, String newMindmapName, boolean sameNameForAttachment) {
        MacroModifier modifier = macro -> {
            String result = this.replaceMacroParameter(macro, PARAM_NAME, newMindmapName);
            return result;
        };
        this.modifyMacroInPage(pageId, oldMindmapName, modifier);
    }

    private String replaceMacroParameter(String macro, String name, String newValue) {
        Validate.notEmpty((CharSequence)name);
        Validate.notEmpty((CharSequence)newValue);
        Matcher matcher = this.getMacroParameterReplacePattern(name).matcher(macro);
        Validate.isTrue((boolean)matcher.matches());
        return matcher.replaceFirst("$1$2" + Matcher.quoteReplacement(newValue) + "$3$4");
    }

    private String emptyMacroParameter(String macro, String name) {
        Matcher matcher = this.getMacroParameterReplacePattern(name).matcher(macro);
        if (matcher.matches()) {
            return matcher.replaceFirst("$1" + Matcher.quoteReplacement(this.getMacroParameterSingleTag(name)) + "$4");
        }
        Validate.isTrue((boolean)macro.contains(this.getMacroParameterSingleTag(name)));
        return macro;
    }

    private Pattern getMacroParameterReplacePattern(String name) {
        String startTag = this.getMacroParameterStartTag(name);
        return Pattern.compile("^(.*)(" + Pattern.quote(startTag) + ")[^<]*(" + PARAM_DEF_END + ")(.*)$");
    }

    private Pattern getMacroParameterValueGetterPattern(String name) {
        String startTag = this.getMacroParameterStartTag(name);
        return Pattern.compile("^.*" + Pattern.quote(startTag) + "([^<]*)" + PARAM_DEF_END + ".*$");
    }

    private Optional<String> getMacroParameterValue(String macro, String paramName) {
        Matcher matcher = this.getMacroParameterValueGetterPattern(paramName).matcher(macro);
        if (matcher.matches()) {
            return Optional.ofNullable(StringUtils.trimToNull((String)matcher.group(1)));
        }
        Validate.isTrue((boolean)macro.contains(this.getMacroParameterSingleTag(paramName)));
        return Optional.empty();
    }

    private String getMacroParameterStartTag(String name) {
        return "<ac:parameter ac:name=\"" + name + "\">";
    }

    private String getMacroParameterSingleTag(String attributeName) {
        return "<ac:parameter ac:name=\"" + attributeName + "\" />";
    }

    private void modifyMacroInPage(Long pageId, String mindmapName, MacroModifier modifier) {
        Page page = this.pageManager.getPage(pageId.longValue());
        if (page == null) {
            page = this.pageManager.getBlogPost(pageId.longValue());
        }
        if (page == null) {
            return;
        }
        if (page.isUnpublished()) {
            return;
        }
        Modification modification = content -> {
            List contents = content.getBodyContents();
            this.modifyMacroInBodyContents(contents, mindmapName, modifier);
            content.setBodyContents(contents);
        };
        this.pageManager.saveNewVersion((ContentEntityObject)page, modification);
    }

    @Override
    public void removeMacroFromPageComments(Long pageId, String mindmapName) {
        List comments;
        Page page = this.pageManager.getPage(pageId.longValue());
        if (page != null && (comments = page.getComments()) != null) {
            for (Comment c : comments) {
                Modification modification = comment -> {
                    List contents = comment.getBodyContents();
                    this.modifyMacroInBodyContents(contents, mindmapName, macro -> "");
                    comment.setBodyContents(contents);
                };
                this.commentManager.saveNewVersion((ContentEntityObject)c, modification);
            }
        }
    }

    private void modifyMacroInBodyContents(List<BodyContent> contents, String mindmapName, MacroModifier modifier) {
        for (int i = 0; i < contents.size(); ++i) {
            Optional<String> actualBodyContent;
            BodyContent bc = contents.get(i);
            if (!bc.getBodyType().equals((Object)BodyType.XHTML) || !(actualBodyContent = CommonUtil.modifyMacroInBodyContent(bc.getBody(), mindmapName, modifier)).isPresent()) continue;
            if (actualBodyContent.get().isEmpty()) {
                contents.remove(i);
                break;
            }
            bc.setBody(actualBodyContent.get());
            break;
        }
    }

    private Optional<ContentMacro> getContentMacro(BodyContent bodyContent, String mindmapName) {
        if (bodyContent.getBodyType().equals((Object)BodyType.XHTML)) {
            return CommonUtil.getContentMacro(bodyContent.getBody(), mindmapName);
        }
        return Optional.empty();
    }

    @Override
    public Set<ContentSearchResult> findNamymapModel(ContentSearchCriteria searchCriteria) {
        ArrayList<SearchQuery> searchQuery = new ArrayList<SearchQuery>();
        searchQuery.add((SearchQuery)new LabelQuery("easyMindModel"));
        searchQuery.add((SearchQuery)new ContentTypeQuery(ContentTypeEnum.ATTACHMENT));
        return this.findConfluenceContent(searchCriteria, searchQuery);
    }

    private Set<ContentSearchResult> findConfluenceContent(ContentSearchCriteria searchCriteria, List<SearchQuery> searchQuery) {
        ArrayList<SearchQuery> queryList = new ArrayList<SearchQuery>(searchQuery);
        if (!searchCriteria.getSpaces().isEmpty()) {
            queryList.add((SearchQuery)new InSpaceQuery(searchCriteria.getSpaces()));
        }
        SearchQuery query = BooleanQuery.andQuery((SearchQuery[])queryList.toArray(new SearchQuery[0]));
        SearchSort sort = searchCriteria.getSort();
        ContentSearch search = new ContentSearch(query, sort);
        SearchResults searchResults = null;
        try {
            searchResults = this.searchManager.search((ISearch)search);
        }
        catch (InvalidSearchException e) {
            searchResults = LuceneSearchResults.EMPTY_RESULTS;
            log.debug("Could not perform search operation.", (Throwable)e);
        }
        return new ContentSearchTransformer().transform(searchResults.getAll());
    }

    @Override
    public Set<String> getAllSpaces() {
        return new HashSet<String>(this.spaceManager.getAllSpaceKeys(SpaceStatus.CURRENT));
    }

    @Override
    public MacroInfoDto getMacroInfo(Long pageId, String mindmapName) {
        Page page = this.pageManager.getPage(pageId.longValue());
        for (BodyContent bodyContent : page.getBodyContents()) {
            Optional<ContentMacro> originalContentMacro = this.getContentMacro(bodyContent, mindmapName);
            if (!originalContentMacro.isPresent()) continue;
            return this.getMacroInfoInternal(originalContentMacro.get().getMacro());
        }
        throw new IllegalStateException("Macro with given name not found: " + mindmapName);
    }

    private MacroInfoDto getMacroInfoInternal(String macro) {
        Long modelPageId = this.getMacroParameterValue(macro, PARAM_MODEL_PAGE_ID).map(Long::parseLong).orElse(null);
        String modelFileName = this.getMacroParameterValue(macro, PARAM_MODEL_FN).orElse(null);
        return new MacroInfoDto(modelPageId, modelFileName);
    }
}

