/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.server.service.impl;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.migration.app.tracker.AccessScope;
import com.atlassian.migration.app.tracker.CloudMigrationAccessor;
import com.atlassian.migration.app.tracker.MigrationDetailsV1;
import com.atlassian.migration.app.tracker.PaginatedMapping;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.fasterxml.jackson.databind.ObjectMapper;
import cz.morosystems.namymap.server.autosave.PageAutoSaveData;
import cz.morosystems.namymap.server.model.AttachmentObject;
import cz.morosystems.namymap.server.service.CloudMigrationService;
import cz.morosystems.namymap.server.service.TemplateService;
import cz.morosystems.namymap.server.service.dto.migration.DraftMigrationDto;
import cz.morosystems.namymap.server.service.dto.migration.DraftsByUserMigrationDto;
import cz.morosystems.namymap.server.service.dto.migration.TemplateMigrationDto;
import cz.morosystems.namymap.server.service.impl.CloudMigrationRegisterServiceImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CloudMigrationServiceImpl
implements CloudMigrationService {
    private static final Logger log = LoggerFactory.getLogger(CloudMigrationServiceImpl.class);
    private final CloudMigrationAccessor migrationAccessor;
    private final TemplateService templateService;
    private final BandanaManager bandanaManager;
    private final UserManager userManager;
    private final BandanaContext context = new ConfluenceBandanaContext("cz.morosystems.namymap.namymap-context");

    @Autowired
    public CloudMigrationServiceImpl(@NonNull CloudMigrationRegisterServiceImpl register, @NonNull TemplateService templateService, @ComponentImport @NonNull UserManager userManager, @ComponentImport @NonNull BandanaManager bandanaManager) {
        if (register == null) {
            throw new NullPointerException("register");
        }
        if (templateService == null) {
            throw new NullPointerException("templateService");
        }
        if (userManager == null) {
            throw new NullPointerException("userManager");
        }
        if (bandanaManager == null) {
            throw new NullPointerException("bandanaManager");
        }
        log.info("Migration service created");
        this.migrationAccessor = register.getCloudMigrationAccessor();
        this.templateService = templateService;
        this.bandanaManager = bandanaManager;
        this.userManager = userManager;
    }

    @Override
    public void onRegistrationAccepted() {
        log.info("Migration service registered");
    }

    @Override
    public void onStartAppMigration(String transferId, MigrationDetailsV1 migrationDetails) {
        log.info("Migration started {}", (Object)transferId);
        try {
            this.templateService.getAllTemplates().stream().map(template -> new TemplateMigrationDto(template.getKey(), template.getName(), template.getMap())).forEach(template -> {
                try (OutputStream firstDataStream = this.migrationAccessor.getCloudMigrationGateway().createAppData(transferId, "templates");){
                    log.info("Template {} migration", (Object)template.getTemplateName());
                    firstDataStream.write(new ObjectMapper().writeValueAsString(template).getBytes());
                }
                catch (IOException e) {
                    log.error("Error uploading files to the cloud", (Throwable)e);
                }
            });
            PaginatedMapping users = this.migrationAccessor.getCloudMigrationGateway().getPaginatedMapping(transferId, "identity:user", 5);
            Map<String, String> pages = this.getAllPagesMapping(transferId);
            while (users.next()) {
                users.getMapping().entrySet().stream().filter(entry -> ((String)entry.getKey()).contains("confluence.userkey")).map(entry -> {
                    String serverUserKey = ((String)entry.getKey()).substring(((String)entry.getKey()).indexOf(47) + 1);
                    UserProfile userProfile = this.userManager.getUserProfile(new UserKey(serverUserKey));
                    return userProfile == null ? null : new DraftsByUserMigrationDto((String)entry.getValue(), this.getAllDraftsByUser(userProfile.getUsername(), pages));
                }).filter(Objects::nonNull).forEach(autoSaveData -> {
                    try (OutputStream firstDataStream = this.migrationAccessor.getCloudMigrationGateway().createAppData(transferId, "drafts");){
                        firstDataStream.write(new ObjectMapper().writeValueAsString(autoSaveData).getBytes());
                    }
                    catch (IOException e) {
                        log.error("Error uploading files to the cloud", (Throwable)e);
                    }
                });
            }
        }
        catch (Exception e) {
            log.error("Migration failed", (Throwable)e);
        }
        log.info("Migration finished");
    }

    private Map<String, String> getAllPagesMapping(String transferId) {
        HashMap<String, String> mappings = new HashMap<String, String>();
        PaginatedMapping pages = this.migrationAccessor.getCloudMigrationGateway().getPaginatedMapping(transferId, "confluence:page", 50);
        while (pages.next()) {
            mappings.putAll(pages.getMapping());
        }
        return mappings;
    }

    private Set<DraftMigrationDto> getAllDraftsByUser(String serverUsername, Map<String, String> pageMappings) {
        return StreamSupport.stream(this.bandanaManager.getKeys(this.context).spliterator(), false).filter(key -> key.contains(serverUsername)).map(key -> {
            AttachmentObject attachmentObject;
            Object mapContent = this.bandanaManager.getValue(this.context, key);
            AttachmentObject attachmentObject2 = attachmentObject = mapContent instanceof AttachmentObject ? (AttachmentObject)mapContent : null;
            if (attachmentObject == null) {
                return null;
            }
            PageAutoSaveData pageAutoSaveData = PageAutoSaveData.fromKey(key, null);
            if (pageAutoSaveData == null) {
                return null;
            }
            String cloudPageId = (String)pageMappings.get(String.valueOf(pageAutoSaveData.getPageId()));
            if (cloudPageId == null) {
                return null;
            }
            return new DraftMigrationDto(Long.parseLong(cloudPageId), pageAutoSaveData.getName(), attachmentObject.getJson(), attachmentObject.getDate());
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Override
    public void onRegistrarRemoved() {
        log.info("Migration service deregister");
    }

    @Override
    public String getCloudAppKey() {
        return "cz.morosystems.atlassian.plugin.easymind";
    }

    @Override
    public String getServerAppKey() {
        return "cz.morosystems.atlassian.plugin.easymind";
    }

    @Override
    public Set<AccessScope> getDataAccessScopes() {
        return Stream.of(AccessScope.APP_DATA_UGC, AccessScope.APP_DATA_OTHER, AccessScope.PRODUCT_DATA_UGC, AccessScope.PRODUCT_DATA_OTHER, AccessScope.MIGRATION_TRACING_PRODUCT, AccessScope.MIGRATION_TRACING_IDENTITY).collect(Collectors.toCollection(HashSet::new));
    }

    public void afterPropertiesSet() {
        this.migrationAccessor.registerListener(this);
    }

    public void destroy() {
        this.migrationAccessor.deregisterListener(this);
    }
}

