/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.server.service.impl;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import cz.morosystems.namymap.common.CommonUtil;
import cz.morosystems.namymap.server.autosave.AutoSaveData;
import cz.morosystems.namymap.server.autosave.PageAutoSaveData;
import cz.morosystems.namymap.server.model.AttachmentObject;
import cz.morosystems.namymap.server.service.AutoSaveService;
import java.util.Date;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AutoSaveServiceImpl
implements AutoSaveService {
    private static final Logger log = LoggerFactory.getLogger(AutoSaveServiceImpl.class);
    private final BandanaManager bandanaManager;
    private BandanaContext context = new ConfluenceBandanaContext("cz.morosystems.namymap.namymap-context");

    @Autowired
    public AutoSaveServiceImpl(@ComponentImport @NonNull BandanaManager bandanaManager) {
        if (bandanaManager == null) {
            throw new NullPointerException("bandanaManager");
        }
        this.bandanaManager = bandanaManager;
    }

    @Override
    public void autoSaveMap(String userName, AutoSaveData autoSave) {
        AttachmentObject autoSaveObj = new AttachmentObject();
        autoSaveObj.setDate(new Date());
        autoSaveObj.setJson(autoSave.getContent());
        this.bandanaManager.setValue(this.context, autoSave.getKey(), (Object)autoSaveObj);
    }

    @Override
    public AttachmentObject getAutoSavedMap(String userName, AutoSaveData autoSave) {
        Object mapContent = this.bandanaManager.getValue(this.context, autoSave.getKey());
        return mapContent instanceof AttachmentObject ? (AttachmentObject)mapContent : null;
    }

    @Override
    public void deleteAutoSave(String userName, AutoSaveData autoSave) {
        this.bandanaManager.removeValue(this.context, autoSave.getKey());
    }

    @Override
    public void processAutoSavedVersion(String userName, Long pageId, String jsonFileName, String originalVersion) {
        PageAutoSaveData pageAutoSave = new PageAutoSaveData(userName, jsonFileName, null, pageId);
        AttachmentObject autoSavedVersion = this.getAutoSavedMap(userName, pageAutoSave);
        if (AutoSaveServiceImpl.isSameVersion(originalVersion, autoSavedVersion)) {
            this.deleteAutoSave(userName, pageAutoSave);
        }
    }

    private static boolean isSameVersion(String originalVersion, AttachmentObject autoSavedVersion) {
        return CommonUtil.isMindmapContentSame(originalVersion, autoSavedVersion != null ? autoSavedVersion.getJson() : null);
    }
}

