/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.server.service.impl;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.content.SpaceService;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.search.service.PredefinedSearchBuilder;
import com.atlassian.confluence.search.service.SearchQueryParameters;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchResult;
import com.atlassian.confluence.search.v2.SearchResults;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import cz.morosystems.namymap.common.CommonUtil;
import cz.morosystems.namymap.common.EasyMindVersionConverter;
import cz.morosystems.namymap.common.InfrastructureUtil;
import cz.morosystems.namymap.common.expimp.ExportImportUtils;
import cz.morosystems.namymap.common.expimp.SourceImporter;
import cz.morosystems.namymap.server.NamymapUtil;
import cz.morosystems.namymap.server.autosave.PageAutoSaveData;
import cz.morosystems.namymap.server.confluence.attachment.ConfluenceAttachment;
import cz.morosystems.namymap.server.confluence.attachment.ConfluenceAttachmentManager;
import cz.morosystems.namymap.server.model.AttachmentObject;
import cz.morosystems.namymap.server.service.AttachmentService;
import cz.morosystems.namymap.server.service.AutoSaveService;
import cz.morosystems.namymap.server.service.ContentService;
import cz.morosystems.namymap.server.service.dto.AttachmentDto;
import cz.morosystems.namymap.server.service.dto.ConfluenceSpaceDto;
import cz.morosystems.namymap.server.service.dto.MindMapVersionDto;
import cz.morosystems.namymap.server.service.dto.SaveMindmapParamsDto;
import cz.morosystems.namymap.server.service.dto.SearchDto;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.validation.constraints.NotNull;
import lombok.NonNull;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AttachmentServiceImpl
implements AttachmentService {
    private static final Logger log = LoggerFactory.getLogger(AttachmentServiceImpl.class);
    private final AutoSaveService autoSave;
    private final ContentService contentService;
    private final ConfluenceAttachmentManager attachmentManager;
    private final LabelManager labelManager;
    private final SearchManager searchManager;
    private final SpaceService spaceService;
    private final PredefinedSearchBuilder psb;

    @Autowired
    public AttachmentServiceImpl(@NonNull AutoSaveService autoSave, @NonNull ContentService contentService, @NonNull SpaceService spaceService, @NonNull ConfluenceAttachmentManager attachmentManager, @ComponentImport @NonNull LabelManager labelManager, @ComponentImport @NonNull SearchManager searchManager, @ComponentImport @NonNull PredefinedSearchBuilder psb) {
        if (autoSave == null) {
            throw new NullPointerException("autoSave");
        }
        if (contentService == null) {
            throw new NullPointerException("contentService");
        }
        if (spaceService == null) {
            throw new NullPointerException("spaceService");
        }
        if (attachmentManager == null) {
            throw new NullPointerException("attachmentManager");
        }
        if (labelManager == null) {
            throw new NullPointerException("labelManager");
        }
        if (searchManager == null) {
            throw new NullPointerException("searchManager");
        }
        if (psb == null) {
            throw new NullPointerException("psb");
        }
        this.autoSave = autoSave;
        this.contentService = contentService;
        this.attachmentManager = attachmentManager;
        this.labelManager = labelManager;
        this.searchManager = searchManager;
        this.spaceService = spaceService;
        this.psb = psb;
    }

    @Override
    public MindMapVersionDto saveMindMap(@NonNull SaveMindmapParamsDto params, @NonNull ConfluenceUser confluenceUser) {
        if (params == null) {
            throw new NullPointerException("params");
        }
        if (confluenceUser == null) {
            throw new NullPointerException("confluenceUser");
        }
        Validate.notBlank((CharSequence)params.getMindmapName());
        Validate.notBlank((CharSequence)params.getStringifiedMindmapJson());
        Validate.notNull((Object)params.getStringifiedMindmapImage());
        ContentEntityObject page = NamymapUtil.getContentEntityObject(params.getPageId());
        byte[] mindmapImagePng = CommonUtil.convertBase64ImageUrlToPng(params.getStringifiedMindmapImage());
        Attachment savedJsonObject = this.saveMindMapAsAttachments(params.getMindmapName(), mindmapImagePng, params.getStringifiedMindmapJson(), page);
        this.labelManager.addLabel((Labelable)savedJsonObject, new Label("easyMindModel"));
        PageAutoSaveData pageAutoSaveData = new PageAutoSaveData(confluenceUser.getName(), params.getMindmapName(), null, params.getPageId());
        this.autoSave.deleteAutoSave(confluenceUser.getName(), pageAutoSaveData);
        return MindMapVersionDto.from(savedJsonObject);
    }

    private Attachment createImageAttachment(String fileName, ContentEntityObject page) {
        String imageFileName = CommonUtil.getMindmapImageAttachmentName(fileName);
        Attachment imageAttachment = this.attachmentManager.loadAttachment(page, imageFileName);
        if (imageAttachment == null) {
            imageAttachment = this.attachmentManager.createNewAttachment(page, imageFileName, "Auto-generated by EasyMind application. DO NOT REMOVE!", "image/png");
        }
        return imageAttachment;
    }

    private Attachment createJsonAttachment(String fileName, ContentEntityObject page) {
        String jsonFileName = CommonUtil.getMindmapJsonAttachmentName(fileName);
        Attachment jsonAttachment = this.attachmentManager.loadAttachment(page, jsonFileName);
        if (jsonAttachment == null) {
            jsonAttachment = this.attachmentManager.createNewAttachment(page, jsonFileName, "Auto-generated by EasyMind application. DO NOT REMOVE!", "application/namymap+json");
        }
        return jsonAttachment;
    }

    private Attachment saveMindMapAsAttachments(String fileName, byte[] mapImage, String mapJson, ContentEntityObject page) {
        Attachment imageAttachment = this.createImageAttachment(fileName, page);
        Attachment jsonAttachment = this.createJsonAttachment(fileName, page);
        this.attachmentManager.saveAttachments(page, Arrays.asList(new ConfluenceAttachment(imageAttachment, new ByteArrayInputStream(mapImage)), new ConfluenceAttachment(jsonAttachment, new ByteArrayInputStream(mapJson.getBytes(StandardCharsets.UTF_8)))));
        return jsonAttachment;
    }

    @Override
    public Attachment loadImage(long pageId, @NonNull String mindmapName, Integer version) {
        if (mindmapName == null) {
            throw new NullPointerException("mindmapName");
        }
        return this.loadAttachment(pageId, CommonUtil.getMindmapImageAttachmentName(mindmapName), version);
    }

    @Override
    public Attachment loadImage(Long contentEntityObjectId, String mindmapName) {
        return this.loadImage(contentEntityObjectId, mindmapName, null);
    }

    @Override
    public Attachment loadModel(long pageId, @NonNull String mindmapName, Integer version) {
        if (mindmapName == null) {
            throw new NullPointerException("mindmapName");
        }
        return this.loadAttachment(pageId, CommonUtil.getMindmapJsonAttachmentName(mindmapName), version);
    }

    @Override
    public Attachment loadModel(long pageId, @NonNull String mindmapName) {
        if (mindmapName == null) {
            throw new NullPointerException("mindmapName");
        }
        return this.loadModel(pageId, mindmapName, null);
    }

    @Override
    public Set<Integer> getHistoricalVersion(Long contentEntityObjectId, String fileName) {
        TreeSet<Integer> versionList = new TreeSet<Integer>();
        ContentEntityObject ceo = NamymapUtil.getContentEntityObject(contentEntityObjectId);
        List<Attachment> versions = this.attachmentManager.getHistoricalVersions(ceo, fileName);
        for (Attachment attach : versions) {
            versionList.add(attach.getVersion());
        }
        return versionList;
    }

    @Override
    public boolean existsAttachment(long contentEntityObjectId, String fileName) {
        Attachment attachment = this.loadAttachment(contentEntityObjectId, fileName, null);
        return attachment != null;
    }

    private Attachment loadAttachment(long contentEntityObjectId, String fileName, Integer version) {
        ContentEntityObject ceo = NamymapUtil.getContentEntityObject(contentEntityObjectId);
        return version != null ? this.attachmentManager.loadAttachment(ceo, fileName, version) : this.attachmentManager.loadAttachment(ceo, fileName);
    }

    @Override
    public List<AttachmentDto> getAttachments(long pageId) {
        ContentEntityObject content = NamymapUtil.getContentEntityObject(pageId);
        return this.attachmentManager.getLatestVersionsOfAttachments(content).stream().map(attachment -> new AttachmentDto(attachment.getFileName(), attachment.getFileSize())).collect(Collectors.toList());
    }

    @Override
    public List<SearchResult> searchAttachments(String searchs, String space) {
        SearchQueryParameters params = new SearchQueryParameters(StringUtils.appendIfMissing((String)searchs, (CharSequence)"*", (CharSequence[])new CharSequence[0]));
        params.setContentType(ContentTypeEnum.ATTACHMENT);
        params.setSpaceKey(space);
        ISearch search = this.psb.buildSiteSearch(params, 0, 50);
        try {
            SearchResults searchResults = this.searchManager.search(search);
            return searchResults.getAll().stream().filter(item -> item.getLabels(null).contains("easyMindModel".toLowerCase())).collect(Collectors.toList());
        }
        catch (InvalidSearchException e) {
            log.debug("Could not perform search operation.", (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public void removeMindMap(long pageId, @NonNull String mindmapName, boolean removeMacro) {
        if (mindmapName == null) {
            throw new NullPointerException("mindmapName");
        }
        if (removeMacro) {
            this.contentService.removeMacroFromPage(pageId, mindmapName);
            this.contentService.removeMacroFromPageComments(pageId, mindmapName);
        }
        this.removeMindMapFromAttachments(pageId, mindmapName);
    }

    @Override
    public void removeMindMapFromAttachments(long pageId, @NonNull String mindmapName) {
        if (mindmapName == null) {
            throw new NullPointerException("mindmapName");
        }
        ContentEntityObject ceo = NamymapUtil.getContentEntityObject(pageId);
        this.attachmentManager.removeAttachment(ceo, mindmapName);
    }

    @Override
    public Attachment getAttachmentForDownloadPath(String url) {
        return this.attachmentManager.getAttachmentForDownloadPath(url);
    }

    @Override
    public void renameAttachment(Long contentEntityObjectId, String oldFileName, String newFileName) {
        ContentEntityObject ceo = NamymapUtil.getContentEntityObject(contentEntityObjectId);
        this.attachmentManager.renameAttachment(ceo, oldFileName, newFileName);
    }

    @Override
    public void copyMindMapAttachments(Long contentEntityObjectId, @NotNull String currName, @NotNull String newName) {
        ContentEntityObject ceo = NamymapUtil.getContentEntityObject(contentEntityObjectId);
        Attachment image = this.loadImage(ceo.getId(), currName);
        Attachment model = this.loadModel(ceo.getId(), currName);
        try {
            Attachment savedJsonObject = this.saveMindMapAsAttachments(newName, IOUtils.toByteArray((InputStream)this.getAttachmentData(image)), this.getAttachmentDataAsJson(model), ceo);
            this.labelManager.addLabel((Labelable)savedJsonObject, new Label("easyMindModel"));
        }
        catch (IOException e) {
            log.error("Could not copy attachments.", (Throwable)e);
        }
    }

    @Override
    public InputStream getAttachmentData(Attachment attachment) {
        Validate.notNull((Object)attachment);
        return this.attachmentManager.getAttachmentData(attachment);
    }

    @Override
    public String getAttachmentDataAsJson(Attachment attachment) throws IOException {
        Validate.notNull((Object)attachment);
        InputStream attachmentData = this.getAttachmentData(attachment);
        return attachmentData == null ? null : EasyMindVersionConverter.convertFromInputStream(attachmentData);
    }

    @Override
    public BufferedImage tryRetrieveImageFromLocalConfluence(String imageUrlParam) throws IOException {
        Validate.notBlank((CharSequence)imageUrlParam);
        BufferedImage loadedImage = null;
        String path = NamymapUtil.getAttachmentDownloadPath(imageUrlParam);
        Attachment attachment = this.getAttachmentForDownloadPath(path);
        if (attachment != null) {
            loadedImage = ImageIO.read(this.getAttachmentData(attachment));
        }
        return loadedImage;
    }

    @Override
    public AttachmentObject loadMindmapAsAttachmentObject(long pageId, @NonNull String mindmapName, Integer version, ConfluenceUser confluenceUser) throws IOException {
        if (mindmapName == null) {
            throw new NullPointerException("mindmapName");
        }
        Validate.notBlank((CharSequence)mindmapName);
        Attachment attachment = this.loadModel(pageId, mindmapName, version);
        AttachmentObject attachmentObject = new AttachmentObject();
        attachmentObject.setDate(attachment.getCreationDate());
        attachmentObject.setFileVersion(String.valueOf(attachment.getVersion()));
        attachmentObject.setJson(this.getAttachmentDataAsJson(attachment));
        if (confluenceUser != null) {
            this.autoSave.processAutoSavedVersion(confluenceUser.getName(), pageId, mindmapName, attachmentObject.getJson());
        }
        return attachmentObject;
    }

    @Override
    public List<ConfluenceSpaceDto> getAvailableSpaces(ConfluenceUser confluenceUser) {
        PageResponse spacePageResponse;
        Validate.notNull((Object)confluenceUser);
        int start = 0;
        int limit = 10;
        ArrayList<ConfluenceSpaceDto> allSpaces = new ArrayList<ConfluenceSpaceDto>();
        do {
            spacePageResponse = this.spaceService.find(new Expansion[0]).fetchMany((PageRequest)new SimplePageRequest(start, limit));
            spacePageResponse.getResults().stream().map(ConfluenceSpaceDto::fromSpaceDTO).collect(Collectors.toCollection(() -> allSpaces));
            start += limit;
        } while (spacePageResponse.hasMore());
        return allSpaces;
    }

    @Override
    public SearchDto getSearchDto(String searchString, String space, ConfluenceUser confluenceUser) {
        Validate.notNull((Object)confluenceUser);
        List<SearchResult> searchResults = this.searchAttachments(StringUtils.lowerCase((String)searchString), space);
        return SearchDto.fromSearchResults(searchResults, confluenceUser);
    }

    @Override
    public void importFile(long pageId, SourceImporter importer, InputStream itemInputStream, String fileName) throws IOException {
        Validate.notNull((Object)importer);
        Validate.notNull((Object)itemInputStream);
        Validate.notBlank((CharSequence)fileName);
        String importedContent = importer.importMindMap(itemInputStream);
        String attachmentContent = InfrastructureUtil.addMindmapFormatVersion(importedContent);
        Validate.notNull((Object)attachmentContent);
        ContentEntityObject page = NamymapUtil.getContentEntityObject(pageId);
        String freeFileName = this.findFreeName(page, fileName);
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm");
        Attachment attachment = new Attachment(freeFileName, "application/json", (long)attachmentContent.length(), String.format("EasyMind Imported Attachment (%s)", dateFormat.format(new Date())));
        this.attachmentManager.saveAttachments(page, Collections.singletonList(new ConfluenceAttachment(attachment, new ByteArrayInputStream(attachmentContent.getBytes(StandardCharsets.UTF_8)))));
    }

    private String findFreeName(ContentEntityObject page, String fileName) {
        return ExportImportUtils.getUniqueFileName(fileName, uniqueFileNameCandidate -> this.isAttachmentNameUnique(page, (String)uniqueFileNameCandidate));
    }

    private boolean isAttachmentNameUnique(ContentEntityObject page, String attachmentName) {
        Attachment attachment = this.attachmentManager.loadAttachment(page, attachmentName);
        return attachment == null;
    }
}

