/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.server.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.ConversionContextOutputType;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.macro.CustomHtmlEditorPlaceholder;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.macro.ResourceAware;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import cz.morosystems.namymap.common.exception.NamymapException;
import cz.morosystems.namymap.server.NamymapUtil;
import cz.morosystems.namymap.server.macro.NamymapMacroDisplay;
import cz.morosystems.namymap.server.model.MindmapStorage;
import cz.morosystems.namymap.server.service.AttachmentService;
import cz.morosystems.namymap.server.service.LicenseService;
import java.util.Map;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class NamymapMacro
implements Macro,
CustomHtmlEditorPlaceholder,
ResourceAware {
    private static final Logger log = LoggerFactory.getLogger(NamymapMacro.class);
    private final AttachmentService attachmentService;
    private final BootstrapManager bootstrapManager;
    private final LicenseService licenseService;

    @Autowired
    public NamymapMacro(@NonNull AttachmentService attachmentService, @ComponentImport @NonNull BootstrapManager bootstrapManager, @NonNull LicenseService licenseService) {
        if (attachmentService == null) {
            throw new NullPointerException("attachmentService");
        }
        if (bootstrapManager == null) {
            throw new NullPointerException("bootstrapManager");
        }
        if (licenseService == null) {
            throw new NullPointerException("licenseService");
        }
        this.attachmentService = attachmentService;
        this.bootstrapManager = bootstrapManager;
        this.licenseService = licenseService;
    }

    public String execute(Map<String, String> params, String bodyContent, ConversionContext context) throws MacroExecutionException {
        if (ConversionContextOutputType.DISPLAY.value().equals(context.getOutputType())) {
            return new NamymapMacroDisplay(this.licenseService).execute(params, bodyContent, context, this);
        }
        if (ConversionContextOutputType.PDF.value().equals(context.getOutputType()) || ConversionContextOutputType.WORD.value().equals(context.getOutputType())) {
            return new NamymapMacroDisplay(this.licenseService, true).execute(params, bodyContent, context, this);
        }
        return "Context output type: " + context.getOutputType() + " This is wrong type.";
    }

    public Map<String, Object> initVelocityContext() {
        Map velocityContext = MacroUtils.defaultVelocityContext();
        String baseURL = this.bootstrapManager.getWebAppContextPath();
        velocityContext.put("webAppContextPath", baseURL);
        return velocityContext;
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    public String getCustomPlaceholder(Map<String, String> params, String body, ConversionContext context) {
        Map<String, Object> contextMap = this.initVelocityContext();
        MindmapStorage mindmapStorage = MindmapStorage.fromMacroParams(params, this.getPage(context));
        String widthParam = params.get("width");
        Attachment pngAttachment = this.getImageAttachment(mindmapStorage.getPageId(), mindmapStorage.getMindmapName());
        String pngUrl = null;
        if (pngAttachment != null) {
            pngUrl = pngAttachment.getDownloadPath();
        }
        NamymapUtil.setMacroWidthToContextMap(contextMap, widthParam, pngAttachment);
        contextMap.put("pngUrl", pngUrl);
        return VelocityUtils.getRenderedTemplate((String)"templates/macro/page-edit-macro.vm", contextMap);
    }

    public Attachment getImageAttachment(Long contentObjectId, String mindmapName) {
        Attachment pngAttachment = null;
        if (mindmapName != null) {
            try {
                pngAttachment = this.attachmentService.loadImage(contentObjectId, mindmapName);
            }
            catch (NamymapException e) {
                log.warn("Cannot get image attachment for macro {}", (Object)mindmapName, (Object)e);
            }
        }
        return pngAttachment;
    }

    public Attachment getModelAttachment(long pageId, String mindmapName) {
        Attachment model = null;
        if (mindmapName != null) {
            try {
                model = this.attachmentService.loadModel(pageId, mindmapName);
            }
            catch (NamymapException e) {
                log.warn("Cannot get model attachment for macro {}", (Object)mindmapName, (Object)e);
            }
        }
        return model;
    }

    public ContentEntityObject getPage(ConversionContext context) {
        ContentEntityObject originalPage = context.getPageContext().getEntity();
        return originalPage instanceof Comment ? ((Comment)originalPage).getContainer() : originalPage;
    }

    public String getResourcePath() {
        return "";
    }

    public void setResourcePath(String s) {
    }
}

