/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.server.export;

import com.atlassian.confluence.pages.Attachment;
import cz.morosystems.namymap.common.expimp.ExportImportException;
import cz.morosystems.namymap.common.expimp.SourceExporter;
import cz.morosystems.namymap.server.service.AttachmentService;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;

public class EasyMindPNGExporter
implements SourceExporter {
    private AttachmentService attachmentService;

    public EasyMindPNGExporter(AttachmentService attachmentService) {
        this.attachmentService = attachmentService;
    }

    @Override
    public byte[] export(String stringifiedMindmapJson, Long pageId, String mindmapName, Integer fileVersion) {
        try {
            Attachment attachment = this.attachmentService.loadImage(pageId, mindmapName, fileVersion);
            InputStream attachmentData = this.attachmentService.getAttachmentData(attachment);
            return IOUtils.toByteArray((InputStream)attachmentData);
        }
        catch (Exception e) {
            throw new ExportImportException("Unable to export PNG image :" + e.getMessage(), e);
        }
    }

    @Override
    public String getContentType() {
        return "image/png";
    }

    @Override
    public String getExtension() {
        return "png";
    }
}

