/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.server.confluence.attachment;

import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.SavableAttachment;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.Lists;
import cz.morosystems.namymap.common.exception.NamymapException;
import cz.morosystems.namymap.server.confluence.attachment.ConfluenceAttachment;
import cz.morosystems.namymap.server.confluence.attachment.ConfluenceAttachmentManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.activation.MimetypesFileTypeMap;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class ConfluenceAttachmentManagerImpl
implements ConfluenceAttachmentManager {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceAttachmentManagerImpl.class);
    private static final String ATTACHMENT_URL_PATH = "/download/attachments/";
    private final AttachmentManager attachManager;
    private final ContentEntityManager contentEntityManager;
    private MimetypesFileTypeMap mimeType = new MimetypesFileTypeMap();

    @Autowired
    public ConfluenceAttachmentManagerImpl(@ComponentImport @NonNull AttachmentManager attachManager, @ComponentImport @Qualifier(value="contentEntityManager") @NonNull ContentEntityManager contentEntityManager) {
        if (attachManager == null) {
            throw new NullPointerException("attachManager");
        }
        if (contentEntityManager == null) {
            throw new NullPointerException("contentEntityManager");
        }
        this.attachManager = attachManager;
        this.contentEntityManager = contentEntityManager;
    }

    @Override
    public Attachment createNewAttachment(ContentEntityObject contentObject, String fileName, String fileComment, String mimeType) {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        Attachment newAttachment = new Attachment(fileName, mimeType, 0L, fileComment);
        newAttachment.setCreator(confluenceUser);
        newAttachment.setCreationDate(new Date());
        newAttachment.setLastModifier(confluenceUser);
        newAttachment.setLastModificationDate(newAttachment.getCreationDate());
        newAttachment.setContainer(contentObject);
        return newAttachment;
    }

    @Override
    public List<Attachment> getLatestVersionsOfAttachments(ContentEntityObject content) {
        if (content == null) {
            return Lists.newLinkedList();
        }
        List confluenceAttachments = this.attachManager.getLatestVersionsOfAttachments(content);
        return CollectionUtils.isNotEmpty((Collection)confluenceAttachments) ? confluenceAttachments : Lists.newLinkedList();
    }

    @Override
    public Attachment loadAttachment(ContentEntityObject contentObject, String fileName) {
        return this.loadAttachment(contentObject, fileName, 0);
    }

    @Override
    public Attachment loadAttachment(ContentEntityObject contentObject, String fileName, int version) {
        Attachment attachment = null;
        if (contentObject != null && StringUtils.isNotBlank((CharSequence)fileName)) {
            attachment = this.attachManager.getAttachment(contentObject, fileName, version);
        }
        return attachment;
    }

    @Override
    public void saveAttachments(ContentEntityObject contentObject, List<ConfluenceAttachment> attachments) {
        List savableAttachments = attachments.stream().map(attachment -> this.createSavableAttachment(contentObject, (ConfluenceAttachment)attachment)).collect(Collectors.toList());
        try {
            this.attachManager.saveAttachments(savableAttachments);
        }
        catch (IOException e) {
            throw new NamymapException("Error saving attachment", e);
        }
    }

    private SavableAttachment createSavableAttachment(ContentEntityObject contentObject, ConfluenceAttachment attachment) {
        SavableAttachment savableAttachment;
        Attachment previousVersion = null;
        if (attachment.getAttachment().isPersistent()) {
            try {
                previousVersion = (Attachment)attachment.getAttachment().clone();
            }
            catch (Exception e) {
                throw new NamymapException("Cannot create attachment clone", e);
            }
        }
        contentObject.addAttachment(attachment.getAttachment());
        ByteArrayInputStream io = null;
        try {
            byte[] content = IOUtils.toByteArray((InputStream)attachment.getContent());
            io = new ByteArrayInputStream(content);
            attachment.getAttachment().setFileSize((long)content.length);
            savableAttachment = new SavableAttachment(attachment.getAttachment(), previousVersion, (InputStream)new ByteArrayInputStream(content));
        }
        catch (IOException e) {
            try {
                throw new NamymapException("Error creating attachment", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(io);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)io);
        return savableAttachment;
    }

    @Override
    public List<Attachment> loadAttachments(ContentEntityObject contentObject, String mimeType) {
        ArrayList<Attachment> findList = new ArrayList<Attachment>();
        for (Attachment att : this.attachManager.getAllVersionsOfAttachments(contentObject)) {
            if (!att.getMediaType().equals(mimeType)) continue;
            findList.add(att);
        }
        return findList;
    }

    @Override
    public Set<String> loadAttachedMindMaps(ContentEntityObject contentObject) {
        TreeSet<String> maps = new TreeSet<String>();
        List<Attachment> attachments = this.loadAttachments(contentObject, this.mimeType.getContentType(".json"));
        for (Attachment attach : attachments) {
            maps.add(attach.getFileName().substring(0, attach.getFileName().indexOf(".json")));
        }
        return maps;
    }

    @Override
    public List<Attachment> getHistoricalVersions(ContentEntityObject contentObject, String fileName) {
        Attachment currentVersion = this.loadAttachment(contentObject, fileName);
        List<Object> versionList = new ArrayList<Attachment>();
        if (currentVersion != null) {
            versionList = this.attachManager.getAllVersions(currentVersion);
        }
        return versionList;
    }

    @Override
    public void removeAttachment(ContentEntityObject contentObject, String fileName) {
        if (contentObject != null && StringUtils.isNotBlank((CharSequence)fileName)) {
            Attachment attachment = this.attachManager.getAttachment(contentObject, fileName);
            if (attachment != null) {
                this.attachManager.removeAttachmentFromServer(attachment);
                contentObject.removeAttachment(attachment);
            }
            if ((attachment = this.attachManager.getAttachment(contentObject, fileName + ".png")) != null) {
                this.attachManager.removeAttachmentFromServer(attachment);
                contentObject.removeAttachment(attachment);
            }
        }
    }

    @Override
    public Attachment getAttachmentForDownloadPath(String url) {
        long id = this.getContentEntityObjectId(url);
        String attachmentName = this.getAttachmentNameFromDownloadPath(url);
        ContentEntityObject ceo = this.contentEntityManager.getById(id);
        if (ceo == null) {
            log.warn("No content entity id: " + id);
            return null;
        }
        return this.attachManager.getAttachment(ceo, attachmentName);
    }

    private long getContentEntityObjectId(String url) {
        int start = url.indexOf(ATTACHMENT_URL_PATH) + ATTACHMENT_URL_PATH.length();
        int end = url.indexOf(47, start);
        String contentId = url.substring(start, end);
        return Long.parseLong(contentId);
    }

    private String getAttachmentNameFromDownloadPath(String url) {
        int start = url.indexOf(ATTACHMENT_URL_PATH) + ATTACHMENT_URL_PATH.length() + 2;
        int end = url.indexOf(63);
        start = url.indexOf(47, start) + 1;
        if (end < 0) {
            end = url.length();
        }
        return url.substring(start, end);
    }

    @Override
    public void renameAttachment(ContentEntityObject contentObject, String oldFileName, String newFileName) {
        Attachment attachment = this.attachManager.getAttachment(contentObject, oldFileName);
        this.attachManager.moveAttachment(attachment, newFileName, contentObject);
    }

    @Override
    public InputStream getAttachmentData(Attachment attachment) {
        return this.attachManager.getAttachmentData(attachment);
    }
}

