/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.server.confluence.action;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.actions.PageAware;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.webresource.WebResourceManager;
import cz.morosystems.namymap.server.confluence.action.NamymapEditorAction;
import cz.morosystems.namymap.server.service.ContentService;
import cz.morosystems.namymap.server.service.LicenseService;
import cz.morosystems.namymap.server.service.UserService;
import java.util.Base64;
import lombok.NonNull;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class NamymapRemoveAction
extends NamymapEditorAction
implements PageAware {
    private static final Logger log = LoggerFactory.getLogger(NamymapRemoveAction.class);
    private static final long serialVersionUID = -2136179415495851905L;
    private AbstractPage page;
    private final transient ContentService contentService;

    @Autowired
    public NamymapRemoveAction(@ComponentImport @NonNull WebResourceManager webResourceManager, @NonNull LicenseService licenseService, @NonNull UserService userService, @NonNull ContentService contentService, @ComponentImport @NonNull BootstrapManager bootstrapManager) {
        super(webResourceManager, licenseService, userService, bootstrapManager);
        if (webResourceManager == null) {
            throw new NullPointerException("webResourceManager");
        }
        if (licenseService == null) {
            throw new NullPointerException("licenseService");
        }
        if (userService == null) {
            throw new NullPointerException("userService");
        }
        if (contentService == null) {
            throw new NullPointerException("contentService");
        }
        if (bootstrapManager == null) {
            throw new NullPointerException("bootstrapManager");
        }
        this.contentService = contentService;
    }

    @Override
    public String execute() throws Exception {
        log.info("Execute action:" + this.getPageId());
        this.removeMacro();
        return "success";
    }

    @Override
    public String getActionName() {
        return "NamymapRemoveAction";
    }

    public AbstractPage getPage() {
        return this.page;
    }

    public void setPage(AbstractPage page) {
        this.page = page;
    }

    public boolean isLatestVersionRequired() {
        return true;
    }

    public boolean isPageRequired() {
        return true;
    }

    public boolean isViewPermissionRequired() {
        return false;
    }

    private void removeMacro() {
        this.contentService.removeMacroFromPage(Long.parseLong(this.getPageId()), this.getMindmapName());
        this.contentService.removeMacroFromPageComments(Long.parseLong(this.getPageId()), this.getMindmapName());
    }

    @Override
    public String getMindmapName() {
        Validate.notBlank((CharSequence)super.getMindmapName());
        return new String(Base64.getUrlDecoder().decode(super.getMindmapName()));
    }
}

