/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.server.autosave.impl;

import com.atlassian.user.User;
import cz.morosystems.namymap.server.autosave.AbstractAutoSaveHttpAction;
import cz.morosystems.namymap.server.autosave.AutoSaveData;
import cz.morosystems.namymap.server.model.AttachmentLoadObject;
import cz.morosystems.namymap.server.model.AttachmentObject;
import cz.morosystems.namymap.server.permission.NamymapPermissionManager;
import cz.morosystems.namymap.server.service.AutoSaveService;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadAutoSaveHttpAction
extends AbstractAutoSaveHttpAction {
    private static final Logger log = LoggerFactory.getLogger(LoadAutoSaveHttpAction.class);

    protected LoadAutoSaveHttpAction() {
    }

    @Override
    protected void processInternalAutoSaveAction(AutoSaveService autoSave, HttpServletResponse resp, AutoSaveData autoSaveData) throws IOException {
        AttachmentObject autoSavedObject = autoSave.getAutoSavedMap(autoSaveData.getUserName(), autoSaveData);
        if (autoSavedObject != null) {
            PrintWriter out = resp.getWriter();
            out.write(AttachmentLoadObject.fromAttachmentObject(autoSavedObject).toJsonString());
            out.flush();
            out.close();
            resp.setStatus(200);
        } else {
            log.warn("No draft available.");
            resp.setStatus(204);
        }
    }

    @Override
    protected void checkUserPermission(User user, AutoSaveData autoSave) {
        NamymapPermissionManager.checkLoadAutoSavePermission(user, autoSave);
    }
}

