/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.server.action;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import cz.morosystems.namymap.server.model.NamymapTemplate;
import cz.morosystems.namymap.server.service.TemplateService;
import java.util.List;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ShowNamymapAdminAction
extends ConfluenceActionSupport {
    private final transient TemplateService templateService;
    private String templateAction;
    private String removeKey;
    private String renameName;
    private String renameKey;
    private List<NamymapTemplate> templates;
    private String templateName;
    private String editorURL;
    private String adminURL;

    @Autowired
    public ShowNamymapAdminAction(@NonNull TemplateService templateService) {
        if (templateService == null) {
            throw new NullPointerException("templateService");
        }
        this.templateService = templateService;
    }

    public String execute() {
        String baseURL = this.getBootstrapManager().getWebAppContextPath();
        this.editorURL = baseURL + "/plugins/namymap/shownamymapeditor.action";
        this.adminURL = baseURL + "/admin/plugin-repository/namymappluginadmin.action";
        if ("create".equals(this.templateAction)) {
            this.templateService.saveOrUpdateTemplate(null, this.templateName, null);
        }
        if ("rename".equals(this.templateAction) && StringUtils.isNotBlank((CharSequence)this.renameKey) && StringUtils.isNotBlank((CharSequence)this.renameName)) {
            this.templateService.rename(this.renameKey, this.renameName);
        }
        if ("remove".equals(this.templateAction) && StringUtils.isNotBlank((CharSequence)this.removeKey)) {
            this.templateService.remove(this.removeKey);
        }
        this.templates = this.templateService.getAllTemplates();
        return "success";
    }

    public void setTemplateAction(String templateAction) {
        this.templateAction = templateAction;
    }

    public void setRemoveKey(String removeKey) {
        this.removeKey = removeKey;
    }

    public void setRenameName(String renameName) {
        this.renameName = renameName;
    }

    public void setRenameKey(String renameKey) {
        this.renameKey = renameKey;
    }

    public List<NamymapTemplate> getTemplates() {
        return this.templates;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public String getEditorURL() {
        return this.editorURL;
    }

    public String getAdminURL() {
        return this.adminURL;
    }
}

