/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.server;

import com.atlassian.confluence.content.service.DraftService;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.Draft;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.spring.container.ContainerManager;
import cz.morosystems.namymap.server.MacroWidth;
import cz.morosystems.namymap.server.model.EditorParametersDto;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamymapUtil {
    private static final Logger log = LoggerFactory.getLogger(NamymapUtil.class);
    private static final DraftService ds = (DraftService)ContainerManager.getComponent((String)"draftService", DraftService.class);
    private static final PageManager pm = (PageManager)ContainerManager.getComponent((String)"pageManager", PageManager.class);

    private NamymapUtil() {
    }

    private static Draft getDraft(long draftId) {
        String draftSpaceKey;
        Draft draft = null;
        try {
            draft = ds.getDraft(draftId);
        }
        catch (Exception e) {
            log.warn("No draft found with id:" + draftId + ", " + e.getMessage(), (Throwable)e);
        }
        if (draft != null && StringUtils.isNotBlank((CharSequence)(draftSpaceKey = draft.getDraftSpaceKey())) && draftSpaceKey.toLowerCase().startsWith("%7e")) {
            draft.setDraftSpaceKey("~" + draftSpaceKey.substring(3));
        }
        return draft;
    }

    public static ContentEntityObject getContentEntityObject(long contentEntityObjectId) {
        Page ceo = pm.getPage(contentEntityObjectId);
        if (ceo == null) {
            ceo = pm.getBlogPost(contentEntityObjectId);
        }
        if (ceo == null) {
            ceo = NamymapUtil.getDraft(contentEntityObjectId);
        }
        return ceo;
    }

    public static Page getPage(long pageId) {
        return pm.getPage(pageId);
    }

    public static int getImageWidth(int prefferedWidth, Attachment pngAttachment) {
        int width = prefferedWidth;
        try {
            if (pngAttachment != null) {
                BufferedImage bi = ImageIO.read(pngAttachment.getContentsAsStream());
                width = prefferedWidth > bi.getWidth() ? 0 : prefferedWidth;
            }
        }
        catch (IOException e) {
            log.error("Error reading image", (Throwable)e);
        }
        return width;
    }

    public static String generateShowEditorURL(String baseURL, EditorParametersDto params) {
        Validate.isTrue((params.getMindmapPreload() == null ? 1 : 0) != 0);
        Validate.isTrue((!params.isCopyMode() ? 1 : 0) != 0);
        Validate.isTrue((!params.isImportMode() ? 1 : 0) != 0);
        Validate.isTrue((params.getTemplateAction() == null ? 1 : 0) != 0);
        Validate.notNull((Object)params.getPageId());
        Validate.notNull((Object)params.getMindmapName());
        Validate.notNull((Object)params.getLastPage());
        String result = baseURL + "/plugins/namymap/shownamymapeditor.action?" + "mindmapName" + "=" + HtmlUtil.urlEncode((String)params.getMindmapName()) + "&" + "lastPage" + "=" + HtmlUtil.urlEncode((String)params.getLastPage()) + "&" + "pageId" + "=" + params.getPageId() + "&" + "isViewMode" + "=" + params.isViewMode();
        if (params.getLegacyExternalStorage() != null) {
            result = result + "&" + "legacyExternalStoragePageId" + "=" + params.getLegacyExternalStorage().getPageId() + "&" + "legacyExternalStorageMindmapName" + "=" + HtmlUtil.urlEncode((String)params.getLegacyExternalStorage().getMindmapName());
        }
        return result;
    }

    public static String generateRemoveURL(String baseURL, String lastPage, long pageId, String mindmapName) {
        return baseURL + "/plugins/namymap/removenamymap.action?" + "mindmapName" + "=" + Base64.getUrlEncoder().encodeToString(mindmapName.getBytes(StandardCharsets.UTF_8)) + "&lastPage=" + HtmlUtil.urlEncode((String)lastPage) + "&pageId=" + pageId;
    }

    public static <T> T getNotNullOrSecondary(T primaryObject, T secondaryObject) {
        return primaryObject != null ? primaryObject : secondaryObject;
    }

    public static String prepareUrl(String url) {
        int splitIndex = url.substring(7).indexOf(47) + 7;
        String host = url.substring(0, splitIndex);
        String param = url.substring(splitIndex + 1);
        String[] params = param.split("/");
        StringBuilder urlBuilder = new StringBuilder(host);
        try {
            for (String s : params) {
                urlBuilder.append("/").append(URLEncoder.encode(s, "UTF-8").replace("+", "%20"));
            }
        }
        catch (UnsupportedEncodingException e) {
            log.error("Error when encode image url param.", (Throwable)e);
        }
        return urlBuilder.toString();
    }

    public static String getAttachmentDownloadPath(String url) {
        Validate.notBlank((CharSequence)url);
        return url.substring(url.indexOf(47));
    }

    public static void setMacroWidthToContextMap(Map<String, Object> contextMap, String widthParam, Attachment pngAttachment) {
        MacroWidth macroWidth = MacroWidth.valueOf(widthParam);
        if (macroWidth.getIsInPercent()) {
            contextMap.put("pngWidth", macroWidth.getWidth());
            contextMap.put("pngWidthInPercent", macroWidth.getIsInPercent());
        } else {
            int width = NamymapUtil.getImageWidth(macroWidth.getWidth(), pngAttachment);
            if (width > 0) {
                contextMap.put("pngWidth", width);
            }
        }
    }
}

