/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.common.expimp.xmind.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import cz.morosystems.namymap.common.Marker;
import cz.morosystems.namymap.common.expimp.ExportImportUtils;
import cz.morosystems.namymap.common.expimp.xmind.MarkerMapping;
import cz.morosystems.namymap.common.expimp.xmind.XmindUtils;
import cz.morosystems.namymap.common.expimp.xmind.format.TopicProperties;
import cz.morosystems.namymap.common.expimp.xmind.guts.xml.Topic;
import cz.morosystems.namymap.common.expimp.xmind.json.EasyImage;
import cz.morosystems.namymap.common.expimp.xmind.json.EasySideChildren;
import cz.morosystems.namymap.common.expimp.xmind.json.EasyStyle;
import cz.morosystems.namymap.common.expimp.xmind.json.FloatingProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@JsonIgnoreProperties(ignoreUnknown=true)
public class EasyTopic
implements Serializable {
    private static final String TYPE_ATTACHED = "attached";
    private String id = "T" + XmindUtils.getEasyMindId();
    private Long timestamp;
    private String title;
    private String type;
    private List<EasyTopic> subtopics;
    private boolean collapsed;
    private EasyStyle style;
    private List<Marker> markers;
    private String hyperlink = "notDefined";
    private EasyImage image;
    private String note;
    private List<String> labels;
    private FloatingProperties floatingProperties;
    private EasySideChildren sideChildren;

    public EasyTopic() {
        this.timestamp = System.currentTimeMillis();
        this.type = TYPE_ATTACHED;
        this.labels = new ArrayList<String>();
        this.markers = new ArrayList<Marker>();
        this.subtopics = new ArrayList<EasyTopic>();
        this.style = new EasyStyle();
    }

    public EasyTopic(Topic topic, TopicProperties styleProperties) {
        this.timestamp = Long.valueOf(topic.getTimestamp());
        String topicTitle = topic.getTitle();
        if (topicTitle.contains("&#13;..")) {
            Pattern pattern = Pattern.compile("&#13;..");
            Matcher matcher = pattern.matcher(topicTitle);
            topicTitle = matcher.replaceAll("\\n");
        }
        this.title = topicTitle;
        this.type = TYPE_ATTACHED;
        this.subtopics = new ArrayList<EasyTopic>();
        if (null != topic.getBranch() && "folded".equals(topic.getBranch())) {
            this.collapsed = true;
        }
        this.style = new EasyStyle(styleProperties, topic.getStructure());
        this.markers = new LinkedList<Marker>();
        if (null != topic.getMarkerReferences()) {
            topic.getMarkerReferences().getMarkerRef().stream().map(marker -> MarkerMapping.XMIND_MARKERS.get(marker.getId())).filter(Objects::nonNull).forEach(marker -> this.markers.add((Marker)((Object)marker)));
        }
        if (null != topic.getHref()) {
            this.hyperlink = ExportImportUtils.getValidHyperlink(topic.getHref());
        }
        if (topic.getNotes() != null) {
            this.note = topic.getNotes().getPlain();
        }
        this.labels = new ArrayList<String>();
        if (null != topic.getLabels()) {
            this.labels.addAll(topic.getLabels().getLabel());
        }
    }

    @JsonProperty
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty
    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Object timestamp) {
        this.timestamp = timestamp instanceof Number ? Long.valueOf(((Number)timestamp).longValue()) : Long.valueOf(XmindUtils.getLong((String)timestamp));
    }

    @JsonProperty
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @JsonProperty
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @JsonProperty
    public List<EasyTopic> getSubtopics() {
        return this.subtopics;
    }

    public void setSubtopics(List<EasyTopic> subtopics) {
        this.subtopics = subtopics;
    }

    @JsonProperty
    public boolean isCollapsed() {
        return this.collapsed;
    }

    public void setCollapsed(boolean collapsed) {
        this.collapsed = collapsed;
    }

    @JsonProperty
    public EasyStyle getStyle() {
        return this.style;
    }

    public void setStyle(EasyStyle style) {
        this.style = style;
    }

    @JsonProperty
    public List<Marker> getMarkers() {
        return this.markers;
    }

    public void setMarkers(List<Marker> markers) {
        this.markers = markers;
    }

    @JsonProperty(value="label")
    public List<String> getLabels() {
        return this.labels;
    }

    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    @JsonProperty
    public String getHyperlink() {
        return this.hyperlink;
    }

    public void setHyperlink(String hyperlink) {
        this.hyperlink = hyperlink;
    }

    @JsonProperty
    public Object getImage() {
        if (this.image == null) {
            return "notDefined";
        }
        return this.image;
    }

    public void setImage(EasyImage image) {
        this.image = image;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public FloatingProperties getFloatingProperties() {
        return this.floatingProperties;
    }

    public void setFloatingProperties(FloatingProperties coordinates) {
        this.floatingProperties = coordinates;
    }

    @JsonProperty
    public EasySideChildren getSideChildren() {
        return this.sideChildren;
    }

    public void setSideChildren(EasySideChildren sideChildren) {
        this.sideChildren = sideChildren;
    }
}

