/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.common.expimp.xmind.guts.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import cz.morosystems.namymap.common.exception.EasyMindException;
import cz.morosystems.namymap.common.expimp.xmind.XmindParsingException;
import cz.morosystems.namymap.common.expimp.xmind.XmindUtils;
import cz.morosystems.namymap.common.expimp.xmind.guts.AbstractXmindParser;
import cz.morosystems.namymap.common.expimp.xmind.guts.ShapeType;
import cz.morosystems.namymap.common.expimp.xmind.guts.StrokeType;
import cz.morosystems.namymap.common.expimp.xmind.guts.XmindJsonModelMapperInitializer;
import cz.morosystems.namymap.common.expimp.xmind.guts.json.Creator;
import cz.morosystems.namymap.common.expimp.xmind.guts.json.Properties;
import cz.morosystems.namymap.common.expimp.xmind.guts.json.Style;
import cz.morosystems.namymap.common.expimp.xmind.guts.json.Topic;
import cz.morosystems.namymap.common.expimp.xmind.guts.json.XmindContentJson;
import cz.morosystems.namymap.common.expimp.xmind.guts.json.XmindMetadataJson;
import cz.morosystems.namymap.common.expimp.xmind.guts.json.XmindParser;
import cz.morosystems.namymap.common.expimp.xmind.json.EasyDocument;
import cz.morosystems.namymap.common.expimp.xmind.json.EasyStyle;
import cz.morosystems.namymap.common.expimp.xmind.json.EasyTopic;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.modelmapper.ModelMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.MimeType;

public class XMindJsonParser
extends AbstractXmindParser
implements XmindParser {
    private static final Logger log = LoggerFactory.getLogger(XMindJsonParser.class);
    private static final String WHITE_COLOR = "#FFFFFF";
    private static final String BLACK_COLOR = "#000000";
    private static final String DEFAULT_STROKE_WIDTH = "1";
    private static final String MANIFEST = "{\"file-entries\":{\"content.json\":{},\"metadata.json\":{}}}";
    final ObjectMapper mapper = new ObjectMapper();

    @Override
    public String parseXMind(InputStream is) throws XmindParsingException {
        try {
            return this.parseXmindMap(is);
        }
        catch (IOException e) {
            log.error("Error occurred while parsing Xmind map.", (Throwable)e);
            throw new XmindParsingException("Error occurred while parsing Xmind map.", e);
        }
    }

    @Override
    public boolean isValidFormat(InputStream is) {
        try {
            this.parseXmindMap(is);
        }
        catch (IOException e) {
            log.error("Error occurred while validating Xmind format.", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public byte[] parseEasyMind(InputStream easyMindStream) throws XmindParsingException {
        String xmindId = XmindUtils.randomString(26);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(baos));){
            ModelMapper modelMapper = XmindJsonModelMapperInitializer.initializeModelMapperForEasyMindExport();
            ObjectMapper objectMapper = this.initObjectMapperForDeserialization();
            EasyDocument easyDocument = objectMapper.readValue(easyMindStream, EasyDocument.class);
            if (Objects.isNull(easyDocument.getBackgroundColor())) {
                easyDocument.setBackgroundColor(BLACK_COLOR);
            }
            XmindContentJson xmindContent = modelMapper.map((Object)easyDocument, XmindContentJson.class);
            XmindMetadataJson metadataJson = this.createXmindMetadata();
            metadataJson.setActiveSheetId(xmindContent.getId());
            xmindContent.setId(xmindId);
            metadataJson.setActiveSheetId(xmindId);
            this.setDefaultTheme(xmindContent);
            this.createZipEntry("content.json", objectMapper.writeValueAsBytes(Arrays.asList(xmindContent)), zos);
            this.createZipEntry("metadata.json", objectMapper.writeValueAsBytes(metadataJson), zos);
            this.createZipEntry("manifest.json", objectMapper.writeValueAsBytes(objectMapper.readTree(MANIFEST)), zos);
            AtomicInteger counter = new AtomicInteger(1);
            this.createResourceEntry(counter, xmindContent.getRootTopic(), zos);
            zos.flush();
            baos.flush();
        }
        catch (IOException e) {
            log.error("Unable to parse given EasyMind stream.", (Throwable)e);
            throw new XmindParsingException("Unable to parse given EasyMind stream.", e);
        }
        return baos.toByteArray();
    }

    private void setDefaultTheme(XmindContentJson xmindContentJson) {
        xmindContentJson.getDefaultStyles().getDefaultMainTopicStyle().getProperties().setFillColor(WHITE_COLOR);
        xmindContentJson.getDefaultStyles().getDefaultMainTopicStyle().getProperties().setFontColor(BLACK_COLOR);
        xmindContentJson.getDefaultStyles().getDefaultMainTopicStyle().getProperties().setBorderLineColor(BLACK_COLOR);
        xmindContentJson.getDefaultStyles().getDefaultMainTopicStyle().getProperties().setBorderLineWidth(DEFAULT_STROKE_WIDTH);
        xmindContentJson.getDefaultStyles().getDefaultCentralTopicStyle().getProperties().setFillColor(BLACK_COLOR);
        xmindContentJson.getDefaultStyles().getDefaultCentralTopicStyle().getProperties().setFontColor(WHITE_COLOR);
        xmindContentJson.getDefaultStyles().getDefaultCentralTopicStyle().getProperties().setBorderLineColor(BLACK_COLOR);
        xmindContentJson.getDefaultStyles().getDefaultFloatingTopic().getProperties().setFillColor(BLACK_COLOR);
        xmindContentJson.getDefaultStyles().getDefaultFloatingTopic().getProperties().setFontColor(WHITE_COLOR);
        xmindContentJson.getDefaultStyles().getDefaultFloatingTopic().getProperties().setBorderLineColor(BLACK_COLOR);
        xmindContentJson.getDefaultStyles().getDefaultSubTopicStyle().getProperties().setFillColor(WHITE_COLOR);
        xmindContentJson.getDefaultStyles().getDefaultSubTopicStyle().getProperties().setFontColor(BLACK_COLOR);
        xmindContentJson.getDefaultStyles().getDefaultSubTopicStyle().getProperties().setShape(ShapeType.UNDERLINE.getXmindShape());
    }

    private XmindMetadataJson createXmindMetadata() {
        XmindMetadataJson metadata = new XmindMetadataJson();
        metadata.setCreator(new Creator("EasyMind", "12.0.0"));
        return metadata;
    }

    private void createZipEntry(String sourceName, byte[] value, ZipOutputStream zos) throws IOException {
        ZipEntry entry = new ZipEntry(sourceName);
        zos.putNextEntry(entry);
        zos.write(value);
        zos.closeEntry();
        zos.flush();
    }

    private void createResourceEntry(AtomicInteger counter, Topic topic, ZipOutputStream zos) {
        if (Objects.nonNull(topic.getImage())) {
            this.writeResourceEntry(counter, topic, zos);
        }
        if (Objects.nonNull(topic.getChildren()) && !topic.getChildren().getAttached().isEmpty()) {
            topic.getChildren().getAttached().forEach(attached -> this.createResourceEntry(counter, (Topic)attached, zos));
        }
        if (Objects.nonNull(topic.getChildren()) && !topic.getChildren().getDetached().isEmpty()) {
            topic.getChildren().getDetached().forEach(detached -> this.createResourceEntry(counter, (Topic)detached, zos));
        }
    }

    private void writeResourceEntry(AtomicInteger counter, Topic topic, ZipOutputStream zos) {
        String base64 = topic.getImage().getSrc();
        if (Objects.isNull(base64)) {
            return;
        }
        String regex = "data:(image/.+);base64,(.+)";
        Matcher matcher = Pattern.compile(regex).matcher(base64);
        if (matcher.matches()) {
            try {
                String mimeType = matcher.group(1);
                String data = matcher.group(2);
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                bytes.write(Base64.getDecoder().decode(data));
                String fileExtension = "svg+xml".equals(mimeType.split("/")[1]) ? "svg" : MimeType.valueOf((String)mimeType).getSubtype();
                String fileName = "image_" + counter.getAndIncrement() + "." + fileExtension;
                this.createZipEntry("resources" + File.separator + fileName, bytes.toByteArray(), zos);
                topic.getImage().setSrc("xap:resources" + File.separator + fileName);
                return;
            }
            catch (IOException e) {
                log.error("Cannot convert image from EasyMind!", (Throwable)e);
            }
        } else {
            log.error("Cannot convert image from EasyMind! Url does not mach given regex '{}'", (Object)regex);
        }
        topic.getImage().setSrc("");
    }

    private String parseXmindMap(InputStream xmindStream) throws IOException {
        ZipEntry entry;
        ByteArrayOutputStream baos = this.readBytes(xmindStream);
        ModelMapper modelMapper = this.getModelMapper(baos);
        ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(baos.toByteArray()));
        while ((entry = zis.getNextEntry()) != null) {
            if (!"content.json".equals(entry.getName())) continue;
            XmindContentJson xmindContentJson = this.parseContentJson(zis);
            EasyDocument easyDocument = modelMapper.map((Object)xmindContentJson, EasyDocument.class);
            easyDocument.setName("Document");
            EasyTopic rootTopic = easyDocument.getRootTopic();
            if (Objects.isNull(easyDocument.getBackgroundColor())) {
                easyDocument.setBackgroundColor(WHITE_COLOR);
            }
            this.initStylesWithDefaultEasyMindProperties(xmindContentJson);
            this.mapPropertiesToEasyStyle(modelMapper, xmindContentJson.getRootTopic(), rootTopic);
            if (Objects.nonNull(xmindContentJson.getRootTopic().getChildren())) {
                rootTopic.setSubtopics(this.mapMainTopicIntoEasyTopic(modelMapper, xmindContentJson.getRootTopic().getChildren().getAttached(), xmindContentJson));
            }
            return this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString(easyDocument);
        }
        throw new EasyMindException(String.format("Cannot parse Xmind map. Stream does not contain '%s'.", "content.json"));
    }

    private ModelMapper getModelMapper(ByteArrayOutputStream bytes) throws IOException {
        Map<String, ByteArrayOutputStream> topicResources = this.getResources(bytes.toByteArray());
        if (topicResources.isEmpty()) {
            return XmindJsonModelMapperInitializer.initializeModelMapperForXmindImport();
        }
        return XmindJsonModelMapperInitializer.initializeModelMapperForXmindImportWithResources(topicResources);
    }

    private ByteArrayOutputStream readBytes(InputStream xmindStream) throws IOException {
        int read;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((read = xmindStream.read(buffer)) != -1) {
            baos.write(buffer, 0, read);
        }
        return baos;
    }

    private Map<String, ByteArrayOutputStream> getResources(byte[] bytes) throws IOException {
        HashMap<String, ByteArrayOutputStream> topicResources = new HashMap<String, ByteArrayOutputStream>();
        byte[] buffer = new byte[1024];
        try (ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new ByteArrayInputStream(bytes)));){
            ZipEntry entry;
            while (Objects.nonNull(entry = zis.getNextEntry())) {
                int read;
                String entryName = entry.getName();
                if (!entryName.contains("resources") || entryName.indexOf("/") == entryName.length() - 1) continue;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                while ((read = zis.read(buffer)) != -1) {
                    baos.write(buffer, 0, read);
                }
                String key = entryName.substring(entryName.indexOf("/") + 1);
                topicResources.put(key, baos);
            }
        }
        return topicResources;
    }

    private void initStylesWithDefaultEasyMindProperties(XmindContentJson xmindContentJson) {
        this.initStylesWithDefaultEasyMindProperties(xmindContentJson.getDefaultStyles().getDefaultCentralTopicStyle().getProperties(), BLACK_COLOR, ShapeType.RRECT.getXmindShape());
        this.initStylesWithDefaultEasyMindProperties(xmindContentJson.getDefaultStyles().getDefaultMainTopicStyle().getProperties(), WHITE_COLOR, ShapeType.RRECT.getXmindShape());
        this.initStylesWithDefaultEasyMindProperties(xmindContentJson.getDefaultStyles().getDefaultSubTopicStyle().getProperties(), WHITE_COLOR, ShapeType.UNDERLINE.getXmindShape());
    }

    private void initStylesWithDefaultEasyMindProperties(Properties properties, String defaultFill, String defaultShape) {
        properties.setBorderLineWidth(DEFAULT_STROKE_WIDTH);
        properties.setBorderLineColor(BLACK_COLOR);
        properties.setLineClass(StrokeType.CURVE.getXmindStroke());
        properties.setFillColor(defaultFill);
        properties.setShape(defaultShape);
    }

    private XmindContentJson parseContentJson(ZipInputStream zis) throws IOException {
        try (InputStreamReader isr = new InputStreamReader(this.getInputStream(zis), Charset.forName("UTF-8"));){
            XmindContentJson xmindContentJson;
            try (BufferedReader br = new BufferedReader(isr);){
                StringBuilder line = new StringBuilder(br.readLine().replaceFirst("\\[", ""));
                int indexOfLastArrayToken = line.lastIndexOf("]");
                line.replace(indexOfLastArrayToken, indexOfLastArrayToken, "");
                xmindContentJson = this.mapper.readValue(line.toString(), XmindContentJson.class);
            }
            return xmindContentJson;
        }
    }

    private List<EasyTopic> mapMainTopicIntoEasyTopic(ModelMapper mapper, List<Topic> topics, XmindContentJson xmindContentJson) {
        Style defaultMainTopicsStyle = xmindContentJson.getDefaultStyles().getDefaultMainTopicStyle();
        Style defaultSubTopicStyle = xmindContentJson.getDefaultStyles().getDefaultSubTopicStyle();
        List<String> multiLineColorList = this.getMultiLineColorList(xmindContentJson);
        AtomicInteger counter = new AtomicInteger(0);
        return topics.stream().map(item -> {
            int index = counter.getAndIncrement();
            if (index == multiLineColorList.size() - 1) {
                counter.set(0);
            }
            if (!multiLineColorList.isEmpty()) {
                String fillColor = (String)multiLineColorList.get(index);
                defaultMainTopicsStyle.getProperties().setFillColor(fillColor);
                defaultSubTopicStyle.getProperties().setFillColor(fillColor);
            }
            EasyTopic mainTopic = this.mapXmindTopicToEasyTopic(mapper, (Topic)item, defaultMainTopicsStyle);
            if (Objects.nonNull(item.getChildren())) {
                mainTopic.setSubtopics(this.mapSubTopicsIntoEasyTopic(mapper, item.getChildren().attached, defaultSubTopicStyle));
            }
            this.initEasyMindDefaultStyles(mainTopic.getStyle(), WHITE_COLOR, ShapeType.RRECT.getEasyMindShape());
            return mainTopic;
        }).collect(Collectors.toList());
    }

    private List<String> getMultiLineColorList(XmindContentJson xmindContentJson) {
        if (Objects.isNull(xmindContentJson.getDefaultStyles()) || Objects.isNull(xmindContentJson.getDefaultStyles().getMap())) {
            return Collections.emptyList();
        }
        Properties props = xmindContentJson.getDefaultStyles().getMap().getProperties();
        if (Objects.isNull(props.getMultiLineColors())) {
            return Collections.emptyList();
        }
        return Arrays.asList(props.getMultiLineColors().split("\\s"));
    }

    private void initEasyMindDefaultStyles(EasyStyle easyStyle, String defaultBackground, String shapeType) {
        easyStyle.setStrokeWidth(DEFAULT_STROKE_WIDTH);
        if ("notDefined".equals(easyStyle.getStrokeColor())) {
            easyStyle.setStrokeColor(BLACK_COLOR);
        }
        if ("notDefined".equals(easyStyle.getFillColor())) {
            easyStyle.setFillColor(defaultBackground);
        }
        if ("notDefined".equals(easyStyle.getStrokeType())) {
            easyStyle.setStrokeType(StrokeType.CURVE.getEasyMindStroke());
        }
        if ("notDefined".equals(easyStyle.getShape())) {
            easyStyle.setShape(shapeType);
        }
    }

    private List<EasyTopic> mapSubTopicsIntoEasyTopic(ModelMapper mapper, List<Topic> topics, Style defaultSubTopicStyle) {
        return topics.stream().map(item -> {
            EasyTopic topic = this.mapSubTopicAsEasyTopic(mapper, (Topic)item, defaultSubTopicStyle);
            this.initEasyMindDefaultStyles(topic.getStyle(), WHITE_COLOR, ShapeType.UNDERLINE.getEasyMindShape());
            return topic;
        }).collect(Collectors.toList());
    }

    private EasyTopic mapSubTopicAsEasyTopic(ModelMapper mapper, Topic item, Style defaultSubTopicStyle) {
        EasyTopic easyTopic = this.mapXmindTopicToEasyTopic(mapper, item, defaultSubTopicStyle);
        if (Objects.nonNull(item.getChildren())) {
            easyTopic.setSubtopics(this.mapSubTopicsIntoEasyTopic(mapper, item.getChildren().attached, defaultSubTopicStyle));
        }
        return easyTopic;
    }

    private EasyTopic mapXmindTopicToEasyTopic(ModelMapper mapper, Topic item, Style defaultTopicStyle) {
        EasyTopic easyTopic = mapper.map((Object)item, EasyTopic.class);
        this.mapPropertiesToEasyStyle(mapper, item, easyTopic);
        this.setDefaultStyle(mapper, item, easyTopic, defaultTopicStyle);
        return easyTopic;
    }

    private void mapPropertiesToEasyStyle(ModelMapper mapper, Topic item, EasyTopic easyTopic) {
        if (Objects.nonNull(item.getStyle())) {
            easyTopic.setStyle(mapper.map((Object)item.getStyle().getProperties(), EasyStyle.class));
        }
    }

    private void setDefaultStyle(ModelMapper mapper, Topic topic, EasyTopic easyTopic, Style defaultStyle) {
        if (Objects.isNull(topic.getStyle())) {
            easyTopic.setStyle(mapper.map((Object)defaultStyle.getProperties(), EasyStyle.class));
        } else {
            EasyStyle easyStyle = easyTopic.getStyle();
            Properties topicStyleProperties = topic.getStyle().getProperties();
            Properties defaultProperties = defaultStyle.getProperties();
            if (Objects.isNull(topicStyleProperties.getFillColor()) && "notDefined".equals(easyStyle.getFillColor())) {
                easyStyle.setFillColor(defaultProperties.getFillColor());
            }
            if (Objects.isNull(topicStyleProperties.getBorderLineWidth()) && "notDefined".equals(easyStyle.getStrokeWidth())) {
                easyStyle.setStrokeWidth(ShapeType.getEasyMindShapeByXmind(defaultProperties.getBorderLineWidth()));
            }
            if (Objects.isNull(topicStyleProperties.getBorderLineColor()) && "notDefined".equals(easyStyle.getStrokeColor())) {
                easyStyle.setStrokeColor(defaultProperties.getBorderLineColor());
            }
            if (Objects.isNull(topicStyleProperties.getLineClass()) && "notDefined".equals(easyStyle.getStrokeType())) {
                easyStyle.setStrokeType(StrokeType.getEasyMindStrokeByXmind(defaultProperties.getLineClass()));
            }
            if (Objects.isNull(topicStyleProperties.getShape()) && "notDefined".equals(easyStyle.getShape())) {
                easyStyle.setShape(ShapeType.getEasyMindShapeByXmind(defaultProperties.getShape()));
            }
        }
    }
}

