/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.common.expimp.xmind.guts;

import cz.morosystems.namymap.common.Marker;
import cz.morosystems.namymap.common.expimp.xmind.MarkerMapping;
import cz.morosystems.namymap.common.expimp.xmind.XmindUtils;
import cz.morosystems.namymap.common.expimp.xmind.guts.ShapeType;
import cz.morosystems.namymap.common.expimp.xmind.guts.StrokeType;
import cz.morosystems.namymap.common.expimp.xmind.guts.StructureType;
import cz.morosystems.namymap.common.expimp.xmind.guts.json.Image;
import cz.morosystems.namymap.common.expimp.xmind.guts.json.Note;
import cz.morosystems.namymap.common.expimp.xmind.guts.json.Position;
import cz.morosystems.namymap.common.expimp.xmind.guts.json.Properties;
import cz.morosystems.namymap.common.expimp.xmind.guts.json.Relation;
import cz.morosystems.namymap.common.expimp.xmind.guts.json.Topic;
import cz.morosystems.namymap.common.expimp.xmind.guts.json.XmindContentJson;
import cz.morosystems.namymap.common.expimp.xmind.json.Coordinates;
import cz.morosystems.namymap.common.expimp.xmind.json.EasyDocument;
import cz.morosystems.namymap.common.expimp.xmind.json.EasyImage;
import cz.morosystems.namymap.common.expimp.xmind.json.EasyRelation;
import cz.morosystems.namymap.common.expimp.xmind.json.EasyStyle;
import cz.morosystems.namymap.common.expimp.xmind.json.EasyTopic;
import java.io.ByteArrayOutputStream;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.modelmapper.AbstractConverter;
import org.modelmapper.Condition;
import org.modelmapper.Conditions;
import org.modelmapper.ModelMapper;
import org.modelmapper.TypeMap;

public class XmindJsonModelMapperInitializer {
    private static final String STYLE_BOLD = "bold";
    private static final String STYLE_ITALIC = "italic";
    private static final String STYLE_LINE_THROUGH = " line-through";
    private static final Condition<String, String> notDefinedCondition = mappingContext -> !"notDefined".equals(mappingContext.getSource());
    private static final Condition<Boolean, String> notFalse = mappingContext -> !Boolean.FALSE.equals(mappingContext.getSource());

    private XmindJsonModelMapperInitializer() {
    }

    public static ModelMapper initializeModelMapperForXmindImportWithResources(Map<String, ByteArrayOutputStream> topicResources) {
        ModelMapper modelMapper = new ModelMapper();
        XmindJsonModelMapperInitializer.initImageToEasyImageMapping(modelMapper, topicResources);
        XmindJsonModelMapperInitializer.initializeCommonModelMapperForXmindImport(modelMapper);
        return modelMapper;
    }

    public static ModelMapper initializeModelMapperForXmindImport() {
        ModelMapper modelMapper = new ModelMapper();
        return XmindJsonModelMapperInitializer.initializeCommonModelMapperForXmindImport(modelMapper);
    }

    private static ModelMapper initializeCommonModelMapperForXmindImport(ModelMapper modelMapper) {
        modelMapper.getConfiguration().setPropertyCondition(Conditions.isNotNull());
        XmindJsonModelMapperInitializer.initTopicToEasyTopicMapping(modelMapper);
        XmindJsonModelMapperInitializer.initPropertiesToEasyTopic(modelMapper);
        XmindJsonModelMapperInitializer.initXmindContentToEasyDocumentMapping(modelMapper);
        XmindJsonModelMapperInitializer.initPropertyToEasyStyleMapping(modelMapper);
        XmindJsonModelMapperInitializer.initRelationToEasyRelationMapping(modelMapper);
        return modelMapper;
    }

    public static ModelMapper initializeModelMapperForEasyMindExport() {
        ModelMapper modelMapper = new ModelMapper();
        modelMapper.getConfiguration().setPropertyCondition(Conditions.isNotNull());
        modelMapper.getConfiguration().setPropertyCondition(notDefinedCondition);
        XmindJsonModelMapperInitializer.initializeEasyStyleToPropertiesMapping(modelMapper);
        XmindJsonModelMapperInitializer.initializeEasyTopicToTopicMapping(modelMapper);
        XmindJsonModelMapperInitializer.initEasyDocumentToXmindContentMapping(modelMapper);
        XmindJsonModelMapperInitializer.initEasyRelationToRelationMapping(modelMapper);
        XmindJsonModelMapperInitializer.initEasyImageToImageMapping(modelMapper);
        return modelMapper;
    }

    private static void initXmindContentToEasyDocumentMapping(ModelMapper modelMapper) {
        TypeMap<Class<XmindContentJson>, EasyDocument> map = modelMapper.createTypeMap(XmindContentJson.class, EasyDocument.class);
        map.addMapping(XmindContentJson::getTitle, EasyDocument::setName);
        map.addMappings(mapper -> mapper.map(src -> src.getStyle().getProperties().getFillColor(), EasyDocument::setBackgroundColor));
        map.addMappings(mapper -> mapper.map(src -> src.getRootTopic().getChildren().getDetached(), EasyDocument::setFloatingTopics));
    }

    private static void initPropertyToEasyStyleMapping(ModelMapper modelMapper) {
        TypeMap<Properties, EasyStyle> typeMap = modelMapper.typeMap(Properties.class, EasyStyle.class);
        typeMap.addMapping(Properties::getBorderLineColor, EasyStyle::setStrokeColor);
        typeMap.addMappings(mapper -> mapper.using(ctx -> XmindUtils.getIntegerValue((String)ctx.getSource())).map(Properties::getFontSize, EasyStyle::setFontSize));
        typeMap.addMappings(mapper -> mapper.using(ctx -> ShapeType.getEasyMindShapeByXmind((String)ctx.getSource())).map(Properties::getShape, EasyStyle::setShape));
        typeMap.addMappings(mapper -> mapper.using(ctx -> StrokeType.getEasyMindStrokeByXmind((String)ctx.getSource())).map(Properties::getLineClass, EasyStyle::setStrokeType));
        typeMap.addMappings(mapper -> mapper.using(ctx -> XmindUtils.getIntegerValue((String)ctx.getSource())).map(Properties::getBorderLineWidth, EasyStyle::setStrokeWidth));
    }

    private static void initEasyDocumentToXmindContentMapping(ModelMapper modelMapper) {
        TypeMap<EasyDocument, XmindContentJson> map = modelMapper.typeMap(EasyDocument.class, XmindContentJson.class);
        map.addMapping(EasyDocument::getName, XmindContentJson::setTitle);
        map.addMappings(mapper -> mapper.map(EasyDocument::getBackgroundColor, (des, v) -> des.getStyle().getProperties().setFillColor((String)v)));
        map.addMappings(mapper -> mapper.map(EasyDocument::getFloatingTopics, (des, v) -> des.getRootTopic().getChildren().setDetached((List<Topic>)v)));
    }

    private static void initializeEasyTopicToTopicMapping(ModelMapper modelMapper) {
        TypeMap<Class<EasyTopic>, Topic> typeMap = modelMapper.createTypeMap(EasyTopic.class, Topic.class);
        typeMap.addMappings(mapper -> mapper.map(EasyTopic::getFloatingProperties, Topic::setPosition));
        typeMap.addMappings(mapper -> mapper.map(EasyTopic::getStyle, (topic, v) -> topic.getStyle().setProperties((Properties)v)));
        typeMap.addMappings(mapper -> mapper.map(EasyTopic::getSubtopics, (topic, v) -> topic.getChildren().setAttached((List<Topic>)v)));
        typeMap.addMappings(mapper -> mapper.map(EasyTopic::getNote, (topic, v) -> topic.getNotes().getPlain().setContent((String)v)));
        typeMap.addMappings(mapper -> mapper.map(EasyTopic::getNote, (topic, v) -> topic.getNotes().getRealHTML().setContent((String)v)));
        typeMap.addMappings(mapper -> mapper.using(new EasyMindMarkerToXmindMarkerConverter()).map(EasyTopic::getMarkers, Topic::setMarkers));
        typeMap.addMappings(mapper -> mapper.when(ctx -> ctx.getSource() instanceof EasyImage).map(EasyTopic::getImage, Topic::setImage));
        typeMap.addMappings(mapper -> mapper.using(ctx -> StructureType.getXMindStructure((String)ctx.getSource())).map(easyTopic -> easyTopic.getFloatingProperties().getLayout(), Topic::setStructureClass));
    }

    private static void initTopicToEasyTopicMapping(ModelMapper modelMapper) {
        TypeMap<Topic, EasyTopic> typeMap = modelMapper.typeMap(Topic.class, EasyTopic.class);
        typeMap.addMappings(mapper -> mapper.map(Topic::getPosition, EasyTopic::setFloatingProperties));
        typeMap.addMappings(mapper -> mapper.using(new XmindMarkerToEasyMindMarkerConverter()).map(Topic::getMarkers, EasyTopic::setMarkers));
        typeMap.addMappings(mapper -> mapper.using(mappingContext -> ((Note)mappingContext.getSource()).getPlain().getContent()).map(Topic::getNotes, EasyTopic::setNote));
        typeMap.addMappings(mapper -> mapper.map(topic -> topic.getStyle().getProperties(), (easyTopic, easyStyle) -> easyTopic.setStyle((EasyStyle)easyStyle)));
        typeMap.addMappings(mapper -> mapper.map(src -> src.getChildren().getAttached(), EasyTopic::setSubtopics));
        typeMap.addMappings(mapper -> mapper.using(ctx -> StructureType.getEasyMindStructure((String)ctx.getSource())).map(Topic::getStructureClass, (easyTopic, v) -> easyTopic.getFloatingProperties().setLayout((String)v)));
    }

    private static void initializeEasyStyleToPropertiesMapping(ModelMapper modelMapper) {
        TypeMap<EasyStyle, Properties> typeMap = modelMapper.typeMap(EasyStyle.class, Properties.class);
        typeMap.addMappings(mapper -> mapper.when(notFalse).using(ctx -> STYLE_BOLD).map(EasyStyle::isFontBold, Properties::setFontWeight));
        typeMap.addMappings(mapper -> mapper.when(notFalse).using(ctx -> STYLE_ITALIC).map(EasyStyle::isFontItalic, Properties::setTextStyle));
        typeMap.addMappings(mapper -> mapper.when(notFalse).using(ctx -> STYLE_LINE_THROUGH).map(EasyStyle::isFontStrikeThrought, Properties::setTextDecoration));
        typeMap.addMapping(EasyStyle::getStrokeColor, Properties::setBorderLineColor);
        typeMap.addMapping(EasyStyle::getStrokeType, Properties::setLineClass);
        typeMap.addMapping(EasyStyle::getStrokeWidth, Properties::setBorderLineWidth);
        typeMap.addMappings(mapper -> mapper.using(ctx -> ShapeType.getXmindShapeByEasyMind((String)ctx.getSource())).map(EasyStyle::getShape, Properties::setShape));
    }

    private static void initPropertiesToEasyTopic(ModelMapper modelMapper) {
        TypeMap<Properties, EasyStyle> typeMap = modelMapper.typeMap(Properties.class, EasyStyle.class);
        typeMap.addMappings(mapper -> mapper.when(ctx -> STYLE_BOLD.equals(ctx.getSource())).using(ctx -> (boolean)Boolean.TRUE).map(Properties::getFontWeight, EasyStyle::setFontBold));
        typeMap.addMappings(mapper -> mapper.when(ctx -> STYLE_ITALIC.equals(ctx.getSource())).using(ctx -> (boolean)Boolean.TRUE).map(Properties::getTextStyle, EasyStyle::setFontItalic));
        typeMap.addMappings(mapper -> mapper.when(ctx -> STYLE_LINE_THROUGH.equals(ctx.getSource())).using(ctx -> (boolean)Boolean.TRUE).map(Properties::getTextDecoration, EasyStyle::setFontStrikeThrought));
        typeMap.addMapping(Properties::getBorderLineColor, EasyStyle::setStrokeColor);
        typeMap.addMapping(Properties::getLineClass, EasyStyle::setStrokeType);
        typeMap.addMapping(Properties::getBorderLineWidth, EasyStyle::setStrokeWidth);
        typeMap.addMappings(mapper -> mapper.using(ctx -> StructureType.getXMindStructure((String)ctx.getSource())).map(Properties::getShape, EasyStyle::setShape));
    }

    private static void initEasyRelationToRelationMapping(ModelMapper modelMapper) {
        TypeMap<EasyRelation, Relation> typeMap = modelMapper.typeMap(EasyRelation.class, Relation.class);
        typeMap.addMappings(mapper -> mapper.map(EasyRelation::getControlFrom, (relation, v) -> relation.getControlPoints().setFrom((Position)v)));
        typeMap.addMappings(mapper -> mapper.map(EasyRelation::getControlTo, (relation, v) -> relation.getControlPoints().setTo((Position)v)));
        typeMap.addMappings(mapper -> mapper.map(EasyRelation::getColor, (relation, v) -> relation.getStyle().getProperties().setLineColor((String)v)));
    }

    private static void initRelationToEasyRelationMapping(ModelMapper modelMapper) {
        TypeMap<Relation, EasyRelation> typeMap = modelMapper.typeMap(Relation.class, EasyRelation.class);
        typeMap.addMappings(mapper -> mapper.map(relation -> relation.getControlPoints().getFrom(), (easyRelation, v) -> easyRelation.setControlFrom((Coordinates)v)));
        typeMap.addMappings(mapper -> mapper.map(relation -> relation.getControlPoints().getTo(), (easyRelation, v) -> easyRelation.setControlTo((Coordinates)v)));
        typeMap.addMappings(mapper -> mapper.map(relation -> relation.getStyle().getProperties().getLineColor(), EasyRelation::setColor));
    }

    private static void initImageToEasyImageMapping(ModelMapper modelMapper, Map<String, ByteArrayOutputStream> topicResources) {
        TypeMap<Image, EasyImage> typeMap = modelMapper.typeMap(Image.class, EasyImage.class);
        typeMap.addMappings(mapper -> mapper.using(new XmindImageToEasyMindImageConverter(topicResources)).map(Image::getSrc, EasyImage::setUrl));
    }

    private static void initEasyImageToImageMapping(ModelMapper modelMapper) {
        TypeMap<EasyImage, Image> typeMap = modelMapper.typeMap(EasyImage.class, Image.class);
        typeMap.addMappings(mapper -> mapper.map(EasyImage::getUrl, Image::setSrc));
    }

    private static class XmindImageToEasyMindImageConverter
    extends AbstractConverter<String, String> {
        private static final String SVG_MIME = "image/svg+xml";
        private Map<String, ByteArrayOutputStream> topicResources;

        public XmindImageToEasyMindImageConverter(Map<String, ByteArrayOutputStream> topicResources) {
            this.topicResources = topicResources;
        }

        @Override
        protected String convert(String src) {
            ByteArrayOutputStream bytes;
            String fileName = src.substring(src.indexOf("/") + 1);
            String prefix = "data:";
            String mime = "";
            if ((Objects.nonNull(this.topicResources) || !this.topicResources.isEmpty()) && Objects.nonNull(bytes = this.topicResources.get(fileName)) && Objects.nonNull(mime = fileName.endsWith(".svg") ? SVG_MIME : URLConnection.guessContentTypeFromName(fileName))) {
                return prefix + mime + ";base64," + Base64.getEncoder().encodeToString(bytes.toByteArray());
            }
            return "";
        }
    }

    private static class XmindMarkerToEasyMindMarkerConverter
    extends AbstractConverter<List<cz.morosystems.namymap.common.expimp.xmind.guts.json.Marker>, List<Marker>> {
        private XmindMarkerToEasyMindMarkerConverter() {
        }

        @Override
        protected List<Marker> convert(List<cz.morosystems.namymap.common.expimp.xmind.guts.json.Marker> markers) {
            ArrayList<Marker> easyMindMarkers = new ArrayList<Marker>();
            markers.stream().map(marker -> MarkerMapping.XMIND_MARKERS.get(marker.getMarkerId())).filter(Objects::nonNull).forEach(marker -> easyMindMarkers.add((Marker)((Object)marker)));
            return easyMindMarkers;
        }
    }

    private static class EasyMindMarkerToXmindMarkerConverter
    extends AbstractConverter<List<Marker>, List<cz.morosystems.namymap.common.expimp.xmind.guts.json.Marker>> {
        private EasyMindMarkerToXmindMarkerConverter() {
        }

        @Override
        protected List<cz.morosystems.namymap.common.expimp.xmind.guts.json.Marker> convert(List<Marker> markers) {
            ArrayList<cz.morosystems.namymap.common.expimp.xmind.guts.json.Marker> xmindMarkers = new ArrayList<cz.morosystems.namymap.common.expimp.xmind.guts.json.Marker>();
            markers.stream().map(item -> MarkerMapping.XMIND_MARKERS.entrySet().stream().filter(entry -> ((Marker)((Object)((Object)((Object)entry.getValue())))).equals(item)).map(Map.Entry::getKey).findFirst().orElse("")).forEach(item -> {
                if (!item.isEmpty()) {
                    cz.morosystems.namymap.common.expimp.xmind.guts.json.Marker marker = new cz.morosystems.namymap.common.expimp.xmind.guts.json.Marker();
                    marker.setMarkerId((String)item);
                    xmindMarkers.add(marker);
                }
            });
            return xmindMarkers;
        }
    }
}

