/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.common.expimp.xmind;

import cz.morosystems.namymap.common.expimp.ExportImportException;
import cz.morosystems.namymap.common.expimp.ExportImportValidationHandler;
import cz.morosystems.namymap.common.expimp.SourceExporter;
import cz.morosystems.namymap.common.expimp.xmind.XmindParserResolver;
import cz.morosystems.namymap.common.expimp.xmind.XmindParsingException;
import cz.morosystems.namymap.common.expimp.xmind.guts.json.XmindParser;
import cz.morosystems.namymap.common.expimp.xmind.guts.xml.XmindXmlExporter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMindExporterImporterValidator
implements ExportImportValidationHandler {
    private static final Logger log = LoggerFactory.getLogger(XMindExporterImporterValidator.class);
    private final SourceExporter xmindExporter;

    public XMindExporterImporterValidator() {
        this.xmindExporter = XmindXmlExporter.initXmindXmlExporter();
    }

    public XMindExporterImporterValidator(SourceExporter xmindExporter) {
        Objects.requireNonNull(xmindExporter, "Given exporter must not be NULL!");
        this.xmindExporter = xmindExporter;
    }

    @Override
    public String importMindMap(InputStream in) {
        try {
            ByteArrayOutputStream streamInMemory = this.readIntoMemory(in);
            XmindParser xmindParser = XmindParserResolver.resolveParserByInputStream(new ByteArrayInputStream(streamInMemory.toByteArray()));
            String string = xmindParser.parseXMind(new ByteArrayInputStream(streamInMemory.toByteArray()));
            return string;
        }
        catch (XmindParsingException | IOException e) {
            throw new ExportImportException("Unable to parse xmind format :" + e.getMessage(), e);
        }
        finally {
            this.closeStream(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean validate(InputStream in) {
        try {
            ByteArrayOutputStream streamInMemory = this.readIntoMemory(in);
            XmindParser xmindParser = XmindParserResolver.resolveParserByInputStream(new ByteArrayInputStream(streamInMemory.toByteArray()));
            boolean bl = xmindParser.isValidFormat(new ByteArrayInputStream(streamInMemory.toByteArray()));
            return bl;
        }
        catch (IOException e) {
            log.error("Cannot resolve Xmind parser.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.closeStream(in);
        }
    }

    @Override
    public byte[] export(String stringifiedMindmapJson, Long pageId, String mindmapName, Integer fileVersion) {
        return this.xmindExporter.export(stringifiedMindmapJson, pageId, mindmapName, fileVersion);
    }

    @Override
    public String getContentType() {
        return this.xmindExporter.getContentType();
    }

    @Override
    public String getExtension() {
        return this.xmindExporter.getExtension();
    }

    private void closeStream(InputStream in) {
        if (Objects.nonNull(in)) {
            try {
                in.close();
            }
            catch (IOException e) {
                log.error("Error while closing stream.", (Throwable)e);
            }
        }
    }

    private ByteArrayOutputStream readIntoMemory(InputStream in) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[2048];
        while (in.read(buffer) != -1) {
            baos.write(buffer);
        }
        baos.flush();
        return baos;
    }
}

