/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.common.expimp.freeplane.entity;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import cz.morosystems.namymap.common.expimp.freeplane.entity.EasyStyle;
import cz.morosystems.namymap.common.expimp.freeplane.entity.FreePlaneCloud;
import cz.morosystems.namymap.common.expimp.freeplane.entity.FreePlaneEdge;
import cz.morosystems.namymap.common.expimp.freeplane.entity.FreePlaneFont;
import cz.morosystems.namymap.common.expimp.freeplane.entity.FreePlaneIcon;
import java.util.List;

@JacksonXmlRootElement
public class FreePlaneStyleNode {
    private String text;
    private String localizedText;
    private String position;
    private String color;
    private String backgroundColor;
    private String style;
    private FreePlaneEdge edge;
    private FreePlaneCloud cloud;
    private List<FreePlaneStyleNode> stylenode;
    private FreePlaneFont font;
    private FreePlaneIcon icon;

    public FreePlaneStyleNode() {
    }

    public FreePlaneStyleNode(String text) {
        this.text = text;
    }

    public FreePlaneStyleNode(String text, EasyStyle style, String strokeType) {
        this.text = text;
        this.edge = new FreePlaneEdge(strokeType, style.getStrokeColor(), style.getStrokeWidth());
        if (style.hasFont()) {
            this.font = new FreePlaneFont(style.getFontSize(), style.isFontBold(), style.isFontItalic(), style.getFontFamily());
        }
        if (!style.getFontColor().matches("notDefined")) {
            this.color = style.getFontColor();
        }
        if (!style.getFillColor().matches("notDefined")) {
            this.backgroundColor = style.getFillColor();
        }
        if ("underline".equals(style.getShape())) {
            this.style = "fork";
        } else if (style.getShape().matches("notDefined") || "rrect".equals(style.getShape())) {
            this.style = "bubble";
        }
    }

    public FreePlaneStyleNode(List<FreePlaneStyleNode> userStyles) {
        this.stylenode = userStyles;
    }

    @JacksonXmlProperty(isAttribute=true, localName="TEXT")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @JacksonXmlProperty(isAttribute=true, localName="LOCALIZED_TEXT")
    public String getLocalizedText() {
        return this.localizedText;
    }

    public void setLocalizedText(String localizedText) {
        this.localizedText = localizedText;
    }

    @JacksonXmlProperty(isAttribute=true, localName="COLOR")
    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    @JacksonXmlProperty(isAttribute=true, localName="BACKGROUND_COLOR")
    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    @JacksonXmlProperty(isAttribute=true, localName="STYLE")
    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    @JacksonXmlProperty(localName="edge")
    public FreePlaneEdge getEdge() {
        return this.edge;
    }

    public void setEgde(FreePlaneEdge edge) {
        this.edge = edge;
    }

    @JacksonXmlProperty(localName="cloud")
    public FreePlaneCloud getCloud() {
        return this.cloud;
    }

    public void setCloud(FreePlaneCloud cloud) {
        this.cloud = cloud;
    }

    @JacksonXmlProperty(isAttribute=true, localName="POSITION")
    public String getPosition() {
        return this.position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    @JacksonXmlElementWrapper(useWrapping=false)
    public List<FreePlaneStyleNode> getStylenode() {
        return this.stylenode;
    }

    public void setStylenode(List<FreePlaneStyleNode> stylenode) {
        this.stylenode = stylenode;
    }

    @JacksonXmlProperty
    public FreePlaneFont getFont() {
        return this.font;
    }

    public void setFont(FreePlaneFont font) {
        this.font = font;
    }

    @JacksonXmlProperty
    public FreePlaneIcon getIcon() {
        return this.icon;
    }

    public void setIcon(FreePlaneIcon icon) {
        this.icon = icon;
    }
}

