/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.common.expimp.freeplane.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import cz.morosystems.namymap.common.Marker;
import cz.morosystems.namymap.common.expimp.ExportImportUtils;
import cz.morosystems.namymap.common.expimp.freeplane.MarkerMapping;
import cz.morosystems.namymap.common.expimp.freeplane.entity.EasyImage;
import cz.morosystems.namymap.common.expimp.freeplane.entity.EasyStyle;
import cz.morosystems.namymap.common.expimp.freeplane.entity.FreePlaneNode;
import cz.morosystems.namymap.common.expimp.freeplane.entity.FreePlaneStyleNode;
import cz.morosystems.namymap.common.expimp.freeplane.guts.FreePlaneParser;
import cz.morosystems.namymap.common.expimp.xmind.XmindUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class EasyTopic {
    private String id;
    private Long timestamp;
    private String title;
    private String type;
    private List<EasyTopic> subtopics;
    private boolean collapsed;
    private EasyStyle style;
    private List<Marker> markers;
    private String hyperlink = "notDefined";
    private EasyImage easyImage;
    private String note;

    public EasyTopic() {
    }

    public EasyTopic(FreePlaneNode topic, FreePlaneStyleNode freeplaneStyle, String structureType) {
        this.id = "T" + FreePlaneParser.getEasyMindId();
        this.timestamp = topic.getModified();
        this.title = topic.getText() != null ? topic.getText() : topic.getLocalizedText();
        this.type = "attached";
        this.subtopics = new ArrayList<EasyTopic>();
        this.style = null != topic.getFont() ? new EasyStyle(topic) : new EasyStyle(freeplaneStyle);
        if (null != structureType) {
            this.style.setTopicStructureType(structureType);
        }
        this.markers = new LinkedList<Marker>();
        if (CollectionUtils.isNotEmpty(topic.getIcon())) {
            List easyMindMarkers = topic.getIcon().stream().map(icon -> MarkerMapping.FREE_PLANE_MARKERS.get(icon.getBuiltin())).filter(Objects::nonNull).collect(Collectors.groupingBy(Marker::getGroup)).values().stream().map(markersPerGroup -> (Marker)((Object)((Object)markersPerGroup.get(0)))).collect(Collectors.toList());
            this.markers.addAll(easyMindMarkers);
        }
        if (null != topic.getLink()) {
            this.hyperlink = ExportImportUtils.getValidHyperlink(topic.getLink());
        }
        if (topic.getNote() != null) {
            this.note = topic.getNote().getText();
        }
    }

    @JsonProperty
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty
    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Object timestamp) {
        this.timestamp = timestamp instanceof Number ? Long.valueOf(((Number)timestamp).longValue()) : Long.valueOf(XmindUtils.getLong((String)timestamp));
    }

    @JsonProperty
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @JsonProperty
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @JsonProperty
    public List<EasyTopic> getSubtopics() {
        return this.subtopics;
    }

    public void setSubtopics(List<EasyTopic> subtopics) {
        this.subtopics = subtopics;
    }

    @JsonProperty
    public boolean isCollapsed() {
        return this.collapsed;
    }

    public void setCollapsed(boolean collapsed) {
        this.collapsed = collapsed;
    }

    @JsonProperty
    public EasyStyle getStyle() {
        return this.style;
    }

    public void setStyle(EasyStyle style) {
        this.style = style;
    }

    @JsonProperty
    public List<Marker> getMarkers() {
        return this.markers;
    }

    public void setMarkers(List<Marker> markers) {
        this.markers = markers;
    }

    @JsonProperty
    public String getHyperlink() {
        return this.hyperlink;
    }

    public void setHyperlink(String hyperlink) {
        this.hyperlink = hyperlink;
    }

    @JsonProperty
    public Object getImage() {
        if (this.easyImage == null) {
            return "notDefined";
        }
        return this.easyImage;
    }

    public void setImage(EasyImage image) {
        this.easyImage = image;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }
}

