/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.common.expimp.freeplane.entity;

import com.fasterxml.jackson.annotation.JsonProperty;
import cz.morosystems.namymap.common.expimp.freeplane.entity.FreePlaneEdge;
import cz.morosystems.namymap.common.expimp.freeplane.entity.FreePlaneFont;
import cz.morosystems.namymap.common.expimp.freeplane.entity.FreePlaneNode;
import cz.morosystems.namymap.common.expimp.freeplane.entity.FreePlaneStyleNode;

public class EasyStyle {
    private String fontSize = "notDefined";
    private String fontFamily = "notDefined";
    private Boolean fontBold = Boolean.FALSE;
    private Boolean fontItalic = Boolean.FALSE;
    private Boolean fontStrikeThrought = Boolean.FALSE;
    private String fontColor = "notDefined";
    private String strokeWidth = "notDefined";
    private String strokeColor = "notDefined";
    private String strokeType = "notDefined";
    private String fillColor = "notDefined";
    private String shape = "notDefined";
    private String topicStructureType = "map";

    public EasyStyle() {
    }

    public EasyStyle(FreePlaneNode topic) {
        this.setFont(topic.getFont());
        if (null != topic.getEdge()) {
            this.setEdge(topic.getEdge());
        }
        if (null != topic.getColor()) {
            this.fontColor = topic.getColor();
        }
        if (null != topic.getBackgroundColor()) {
            this.fillColor = topic.getBackgroundColor();
        }
        if (null != topic.getStyle()) {
            this.setStyleShape(topic.getStyle());
        }
    }

    public EasyStyle(FreePlaneStyleNode node) {
        this.setFont(node.getFont());
        if (null != node.getEdge()) {
            this.setEdge(node.getEdge());
        }
        if (null != node.getBackgroundColor()) {
            this.fillColor = node.getBackgroundColor();
        }
        if (null != node.getColor()) {
            this.fontColor = node.getColor();
        }
        if (null != node.getStyle()) {
            this.setStyleShape(node.getStyle());
        }
    }

    private void setFont(FreePlaneFont font) {
        if (font != null) {
            if (null != font.getSize()) {
                this.fontSize = font.getSize().toString();
            }
            if (null != font.isBold() && font.isBold().booleanValue()) {
                this.fontBold = Boolean.TRUE;
            }
            if (null != font.isItalic() && font.isItalic().booleanValue()) {
                this.fontItalic = Boolean.TRUE;
            }
            if (null != font.getName()) {
                this.fontFamily = font.getName();
            }
        }
    }

    private void setEdge(FreePlaneEdge edge) {
        if (edge != null) {
            if (null != edge.getWidth()) {
                this.strokeWidth = edge.getWidth().toString();
            }
            if (null != edge.getColor()) {
                this.strokeColor = edge.getColor();
            }
            if ("bezier".equals(edge.getStyle())) {
                this.strokeType = "curve";
            } else if ("horizontal".equals(edge.getStyle())) {
                this.strokeType = "elbow";
            }
        }
    }

    private void setStyleShape(String shape) {
        if ("fork".equals(shape)) {
            this.shape = "underline";
        } else if ("bubble".equals(shape)) {
            this.shape = "rrect";
        }
    }

    public boolean hasFont() {
        return this.fontBold != false || this.fontItalic != false || !this.fontSize.matches("notDefined") || !this.fontFamily.matches("notDefined");
    }

    @JsonProperty
    public String getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(String fontSize) {
        this.fontSize = fontSize;
    }

    @JsonProperty
    public Boolean isFontBold() {
        return this.fontBold;
    }

    public void setFontBold(Boolean fontBold) {
        this.fontBold = fontBold;
    }

    @JsonProperty
    public Boolean isFontItalic() {
        return this.fontItalic;
    }

    public void setFontItalic(Boolean fontItalic) {
        this.fontItalic = fontItalic;
    }

    @JsonProperty
    public Boolean isFontStrikeThrought() {
        return this.fontStrikeThrought;
    }

    public void setFontStrikeThrought(Boolean fontStrikeThrought) {
        this.fontStrikeThrought = fontStrikeThrought;
    }

    @JsonProperty
    public String getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(String fontColor) {
        this.fontColor = fontColor;
    }

    @JsonProperty
    public String getStrokeWidth() {
        return this.strokeWidth;
    }

    public void setStrokeWidth(String strokeWidth) {
        this.strokeWidth = strokeWidth;
    }

    @JsonProperty
    public String getStrokeColor() {
        return this.strokeColor;
    }

    public void setStrokeColor(String strokeColor) {
        this.strokeColor = strokeColor;
    }

    @JsonProperty
    public String getStrokeType() {
        return this.strokeType;
    }

    public void setStrokeType(String strokeType) {
        this.strokeType = strokeType;
    }

    @JsonProperty
    public String getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(String fillColor) {
        this.fillColor = fillColor;
    }

    @JsonProperty
    public String getShape() {
        return this.shape;
    }

    public void setShape(String shape) {
        this.shape = shape;
    }

    @JsonProperty
    public String getTopicStructureType() {
        return this.topicStructureType;
    }

    public void setTopicStructureType(String topicStructureType) {
        this.topicStructureType = topicStructureType;
    }

    @JsonProperty
    public String getFontFamily() {
        return this.fontFamily;
    }

    public void setFontFamily(String fontFamily) {
        this.fontFamily = fontFamily;
    }
}

