/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.common.expimp.freemind.guts;

import cz.morosystems.namymap.common.Marker;
import cz.morosystems.namymap.common.expimp.freemind.MarkerMapping;
import cz.morosystems.namymap.common.expimp.freemind.model.MindNode;
import cz.morosystems.namymap.common.expimp.freemind.model.impl.FreeMindRootDto;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class FreeMindToJsonConverter {
    public String convertToJson(FreeMindRootDto freeMindRoot) {
        Validate.notNull((Object)freeMindRoot);
        JSONObject jsonDocument = new JSONObject();
        jsonDocument.put("id", this.generateEasyMindId(true));
        jsonDocument.put("name", "FreeMindImport-" + new Date().getTime() + "-v" + freeMindRoot.getVersion());
        jsonDocument.put("backgroundColor", "#f7f7f7");
        jsonDocument.put("theme", "notDefined");
        MindNode rootNode = freeMindRoot.getRootNode();
        JSONObject jsonRootTopic = this.convertNode(rootNode);
        jsonDocument.put("rootTopic", jsonRootTopic);
        return jsonDocument.toJSONString();
    }

    private JSONObject convertNode(MindNode mindNode) {
        JSONObject jsonTopic = new JSONObject();
        jsonTopic.put("id", this.generateEasyMindId());
        jsonTopic.put("title", mindNode.getText());
        jsonTopic.put("type", "attached");
        jsonTopic.put("timestamp", "notDefined");
        jsonTopic.put("collapsed", Boolean.FALSE);
        jsonTopic.put("hyperlink", "notDefined");
        jsonTopic.put("image", "notDefined");
        if (mindNode.getNote() != null) {
            jsonTopic.put("note", mindNode.getNote());
        }
        jsonTopic.put("style", this.createStyle(mindNode));
        jsonTopic.put("markers", this.mapToEasyMindMarkers(mindNode));
        JSONArray jsonSubtopics = new JSONArray();
        mindNode.getChildrenNodes().stream().map(this::convertNode).forEach(jsonSubtopics::add);
        jsonTopic.put("subtopics", jsonSubtopics);
        return jsonTopic;
    }

    private JSONArray mapToEasyMindMarkers(MindNode mindNode) {
        Validate.notNull((Object)mindNode);
        JSONArray result = new JSONArray();
        mindNode.getIcons().stream().map(MarkerMapping.FREE_MIND_MARKERS::get).filter(Objects::nonNull).collect(Collectors.groupingBy(Marker::getGroup)).values().stream().map(markers -> ((Marker)((Object)((Object)markers.get(0)))).name()).forEach(result::add);
        return result;
    }

    private JSONObject createStyle(MindNode mindNode) {
        JSONObject jsonStyle = new JSONObject();
        jsonStyle.put("fontSize", mindNode.getFontSizeDef());
        jsonStyle.put("fontBold", mindNode.getFontBoldDef());
        jsonStyle.put("fontItalic", mindNode.getFontItalicDef());
        jsonStyle.put("fontStrikeThrought", "notDefined");
        jsonStyle.put("fontColor", mindNode.getColorDef());
        jsonStyle.put("fontFamily", mindNode.getFontNameDef());
        jsonStyle.put("strokeWidth", "notDefined");
        jsonStyle.put("strokeColor", "notDefined");
        jsonStyle.put("strokeType", "notDefined");
        jsonStyle.put("fillColor", mindNode.getBackgroundColor());
        jsonStyle.put("shape", "notDefined");
        jsonStyle.put("topicStructureType", "map");
        return jsonStyle;
    }

    private String generateEasyMindId() {
        return this.generateEasyMindId(false);
    }

    private String generateEasyMindId(boolean document) {
        String randId = "T";
        if (document) {
            randId = "D";
        }
        Date date = new Date();
        randId = randId + date.getTime() + "_";
        SecureRandom random = new SecureRandom();
        String randStr = new BigInteger(70, random).toString();
        String numStr = randStr.substring(0, 17);
        randId = randId + numStr;
        return randId;
    }
}

