/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.common.expimp.freemind.guts;

import cz.morosystems.namymap.common.CommonUtil;
import cz.morosystems.namymap.common.expimp.freemind.model.MindArrowlink;
import cz.morosystems.namymap.common.expimp.freemind.model.MindCloud;
import cz.morosystems.namymap.common.expimp.freemind.model.MindNode;
import cz.morosystems.namymap.common.expimp.freemind.model.impl.FreeMindArrowlink;
import cz.morosystems.namymap.common.expimp.freemind.model.impl.FreeMindCloud;
import cz.morosystems.namymap.common.expimp.freemind.model.impl.FreeMindNode;
import cz.morosystems.namymap.common.expimp.freemind.model.impl.FreeMindRootDto;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.stream.StreamSupport;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class FreeMindParser {
    private static final String MAP = "map";
    private static final String NODE = "node";
    private static final String ICON = "icon";
    private static final String FONT = "font";
    private static final String EDGE = "edge";
    private static final String HOOK = "hook";
    private static final String CLOUD = "cloud";
    private static final String ARROWLINK = "arrowlink";
    private static final String RICHCONTENT = "richcontent";
    private static final String MAP_VERSION = "version";
    private static final String NODE_ID = "ID";
    private static final String NODE_TEXT = "TEXT";
    private static final String NODE_CREATED = "CREATED";
    private static final String NODE_MODIFIED = "MODIFIED";
    private static final String NODE_STYLE = "STYLE";
    private static final String NODE_COLOR = "COLOR";
    private static final String NODE_BACKGROUND_COLOR = "BACKGROUND_COLOR";
    private static final String NODE_POSITION = "POSITION";
    private static final String NODE_FOLDED = "FOLDED";
    private static final String NODE_LINK = "LINK";
    private static final String NODE_VSHIFT = "VSHIFT";
    private static final String NODE_HGAP = "HGAP";
    private static final String NODE_VGAP = "VGAP";
    private static final String NODE_ENCRYPTED_CONTENT = "ENCRYPTED_CONTENT";
    private static final String ICON_BUILTIN = "BUILTIN";
    private static final String FONT_NAME = "NAME";
    private static final String FONT_SIZE = "SIZE";
    private static final String FONT_BOLD = "BOLD";
    private static final String FONT_ITALIC = "ITALIC";
    private static final String EDGE_COLOR = "COLOR";
    private static final String EDGE_STYLE = "STYLE";
    private static final String EDGE_WIDTH = "WIDTH";
    private static final String HOOK_EQUATION = "EQUATION";
    private static final String CLOUD_STYLE = "STYLE";
    private static final String CLOUD_COLOR = "COLOR";
    private static final String CLOUD_WIDTH = "WIDTH";
    private static final String ARROWLINK_ID = "ID";
    private static final String ARROWLINK_COLOR = "COLOR";
    private static final String ARROWLINK_STYLE = "STYLE";
    private static final String ARROWLINK_DESTINATION = "DESTINATION";
    private static final String ARROWLINK_REFERENCETEXT = "REFERENCETEXT";
    private static final String ARROWLINK_STARTINCLINATION = "STARTINCLINATION";
    private static final String ARROWLINK_ENDINCLINATION = "ENDINCLINATION";
    private static final String ARROWLINK_STARTARROW = "STARTARROW";
    private static final String ARROWLINK_ENDARROW = "ENDARROW";
    private static final String ARROWLINK_WIDTH = "WIDTH";
    private static final String RICHCONTENT_TYPE = "TYPE";
    private static final String NODE_TYPE = "NODE";
    private static final String NOTE_TYPE = "NOTE";

    public FreeMindRootDto readFromStream(InputStream in) throws XMLStreamException {
        FreeMindRootDto freeMindRoot = new FreeMindRootDto();
        LinkedList<FreeMindNode> nodeStack = new LinkedList<FreeMindNode>();
        FreeMindNode mindNode = null;
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        XMLEventReader eventReader = inputFactory.createXMLEventReader(in);
        StringWriter richContentWriter = null;
        String richContentType = null;
        while (eventReader.hasNext()) {
            EndElement endElement;
            String elementName;
            XMLEvent event = eventReader.nextEvent();
            if (richContentWriter != null) {
                if (event.isEndElement() && RICHCONTENT.equals(event.asEndElement().getName().getLocalPart())) {
                    if (NODE_TYPE.equals(richContentType)) {
                        mindNode.setText(CommonUtil.convertHtmlToPlainText(richContentWriter.toString(), true));
                    } else if (NOTE_TYPE.equals(richContentType)) {
                        mindNode.setNote(CommonUtil.convertHtmlToPlainText(richContentWriter.toString(), false));
                    }
                    richContentWriter = null;
                    richContentType = null;
                } else {
                    event.writeAsEncodedUnicode(richContentWriter);
                    continue;
                }
            }
            if (event.isStartElement()) {
                Attribute attribute;
                Iterator<Attribute> attributes;
                Attribute attribute2;
                Iterator<Attribute> attributes2;
                StartElement startElement = event.asStartElement();
                elementName = startElement.getName().getLocalPart();
                if (NODE.equals(elementName)) {
                    mindNode = new FreeMindNode();
                    if (!nodeStack.isEmpty()) {
                        MindNode parentNode = (MindNode)nodeStack.getLast();
                        parentNode.getChildrenNodes().add(mindNode);
                        mindNode.setParentNode(parentNode);
                    } else {
                        freeMindRoot.setRootNode(mindNode);
                    }
                    nodeStack.addLast(mindNode);
                    attributes2 = startElement.getAttributes();
                    while (attributes2.hasNext()) {
                        attribute2 = attributes2.next();
                        this.readNodeAtribute(mindNode, attribute2);
                    }
                } else if (MAP.equals(elementName)) {
                    attributes2 = startElement.getAttributes();
                    while (attributes2.hasNext()) {
                        attribute2 = attributes2.next();
                        if (!MAP_VERSION.equals(attribute2.getName().toString())) continue;
                        freeMindRoot.setVersion(attribute2.getValue());
                    }
                } else if (ICON.equals(elementName)) {
                    attributes2 = startElement.getAttributes();
                    while (attributes2.hasNext()) {
                        attribute2 = attributes2.next();
                        if (!ICON_BUILTIN.equals(attribute2.getName().toString())) continue;
                        mindNode.getIcons().add(attribute2.getValue());
                    }
                } else if (FONT.equals(elementName)) {
                    attributes2 = startElement.getAttributes();
                    while (attributes2.hasNext()) {
                        attribute2 = attributes2.next();
                        this.readFontAtribute(mindNode, attribute2);
                    }
                } else if (EDGE.equals(elementName)) {
                    attributes2 = startElement.getAttributes();
                    while (attributes2.hasNext()) {
                        attribute2 = attributes2.next();
                        this.readEdgeAtribute(mindNode, attribute2);
                    }
                } else if (HOOK.equals(elementName)) {
                    attributes2 = startElement.getAttributes();
                    while (attributes2.hasNext()) {
                        attribute2 = attributes2.next();
                        if (!HOOK_EQUATION.equals(attribute2.getName().toString())) continue;
                        mindNode.setHookEquation(attribute2.getValue());
                    }
                } else if (CLOUD.equals(elementName)) {
                    FreeMindCloud mindCloud = new FreeMindCloud();
                    mindNode.setCloud(mindCloud);
                    attributes = startElement.getAttributes();
                    while (attributes.hasNext()) {
                        attribute = attributes.next();
                        this.readCloudAtribute(mindCloud, attribute);
                    }
                } else if (ARROWLINK.equals(elementName)) {
                    FreeMindArrowlink mindArrowlink = new FreeMindArrowlink();
                    mindNode.getArrowlinks().add(mindArrowlink);
                    mindArrowlink.setParentNode(mindNode);
                    attributes = startElement.getAttributes();
                    while (attributes.hasNext()) {
                        attribute = attributes.next();
                        this.readArrowlinkAtribute(mindArrowlink, attribute);
                    }
                } else if (RICHCONTENT.equals(elementName)) {
                    richContentWriter = new StringWriter();
                    richContentType = this.getRichContentType(startElement);
                }
            }
            if (!event.isEndElement() || !NODE.equals(elementName = (endElement = event.asEndElement()).getName().getLocalPart())) continue;
            nodeStack.removeLast();
        }
        return freeMindRoot;
    }

    private String getRichContentType(StartElement startElement) {
        Iterable iterable = startElement::getAttributes;
        return StreamSupport.stream(iterable.spliterator(), false).filter(attribute -> RICHCONTENT_TYPE.equals(attribute.getName().toString())).map(Attribute::getValue).findFirst().orElse(NODE_TYPE);
    }

    private void readNodeAtribute(FreeMindNode mindNode, Attribute attribute) {
        if ("ID".equals(attribute.getName().toString())) {
            mindNode.setId(attribute.getValue());
        } else if (NODE_TEXT.equals(attribute.getName().toString())) {
            mindNode.setText(attribute.getValue());
        } else if (NODE_CREATED.equals(attribute.getName().toString())) {
            mindNode.setCreated(attribute.getValue());
        } else if (NODE_MODIFIED.equals(attribute.getName().toString())) {
            mindNode.setModified(attribute.getValue());
        } else if ("STYLE".equals(attribute.getName().toString())) {
            mindNode.setStyle(attribute.getValue());
        } else if ("COLOR".equals(attribute.getName().toString())) {
            mindNode.setColor(attribute.getValue());
        } else if (NODE_BACKGROUND_COLOR.equals(attribute.getName().toString())) {
            mindNode.setBackgroundColor(attribute.getValue());
        } else if (NODE_POSITION.equals(attribute.getName().toString())) {
            mindNode.setPosition(attribute.getValue());
        } else if (NODE_FOLDED.equals(attribute.getName().toString())) {
            mindNode.setFolded(Boolean.valueOf(attribute.getValue()));
        } else if (NODE_LINK.equals(attribute.getName().toString())) {
            mindNode.setLink(attribute.getValue());
        } else if (NODE_VSHIFT.equals(attribute.getName().toString())) {
            mindNode.setVshift(new Integer(attribute.getValue()));
        } else if (NODE_HGAP.equals(attribute.getName().toString())) {
            mindNode.setHgap(new Integer(attribute.getValue()));
        } else if (NODE_VGAP.equals(attribute.getName().toString())) {
            mindNode.setVgap(new Integer(attribute.getValue()));
        } else if (NODE_ENCRYPTED_CONTENT.equals(attribute.getName().toString())) {
            mindNode.setEncryptedContent(attribute.getValue());
        }
    }

    private void readFontAtribute(FreeMindNode mindNode, Attribute attribute) {
        if (FONT_NAME.equals(attribute.getName().toString())) {
            mindNode.setFontName(attribute.getValue());
        } else if (FONT_SIZE.equals(attribute.getName().toString())) {
            mindNode.setFontSize(new Integer(attribute.getValue()));
        } else if (FONT_BOLD.equals(attribute.getName().toString())) {
            mindNode.setFontBold(Boolean.valueOf(attribute.getValue()));
        } else if (FONT_ITALIC.equals(attribute.getName().toString())) {
            mindNode.setFontItalic(Boolean.valueOf(attribute.getValue()));
        }
    }

    private void readEdgeAtribute(FreeMindNode mindNode, Attribute attribute) {
        if ("COLOR".equals(attribute.getName().toString())) {
            mindNode.setEdgeColor(attribute.getValue());
        } else if ("STYLE".equals(attribute.getName().toString())) {
            mindNode.setEdgeStyle(attribute.getValue());
        } else if ("WIDTH".equals(attribute.getName().toString())) {
            mindNode.setEdgeWidth(attribute.getValue());
        }
    }

    private void readCloudAtribute(FreeMindCloud mindCloud, Attribute attribute) {
        if ("STYLE".equals(attribute.getName().toString())) {
            mindCloud.setStyle(attribute.getValue());
        } else if ("COLOR".equals(attribute.getName().toString())) {
            mindCloud.setColor(attribute.getValue());
        } else if ("WIDTH".equals(attribute.getName().toString())) {
            mindCloud.setWidth(new Integer(attribute.getValue()));
        }
    }

    private void readArrowlinkAtribute(MindArrowlink arrowlink, Attribute attribute) {
        if ("ID".equals(attribute.getName().toString())) {
            arrowlink.setId(attribute.getValue());
        } else if ("COLOR".equals(attribute.getName().toString())) {
            arrowlink.setColor(attribute.getValue());
        } else if ("STYLE".equals(attribute.getName().toString())) {
            arrowlink.setStyle(attribute.getValue());
        } else if (ARROWLINK_DESTINATION.equals(attribute.getName().toString())) {
            arrowlink.setDestination(attribute.getValue());
        } else if (ARROWLINK_REFERENCETEXT.equals(attribute.getName().toString())) {
            arrowlink.setReferencetext(attribute.getValue());
        } else if (ARROWLINK_STARTINCLINATION.equals(attribute.getName().toString())) {
            arrowlink.setStartinclination(attribute.getValue());
        } else if (ARROWLINK_ENDINCLINATION.equals(attribute.getName().toString())) {
            arrowlink.setEndinclination(attribute.getValue());
        } else if (ARROWLINK_STARTARROW.equals(attribute.getName().toString())) {
            arrowlink.setStartarrow(attribute.getValue());
        } else if (ARROWLINK_ENDARROW.equals(attribute.getName().toString())) {
            arrowlink.setEndtarrow(attribute.getValue());
        } else if ("WIDTH".equals(attribute.getName().toString())) {
            arrowlink.setWidth(new Integer(attribute.getValue()));
        }
    }

    public void writeToStream(FreeMindRootDto freeMindRoot, OutputStream out) throws XMLStreamException {
        MindNode mindRootNode = freeMindRoot.getRootNode();
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        XMLEventWriter eventWriter = outputFactory.createXMLEventWriter(out);
        XMLEventFactory eventFactory = XMLEventFactory.newInstance();
        StartElement configStartElement = eventFactory.createStartElement("", "", MAP);
        eventWriter.add(configStartElement);
        Attribute testProp = eventFactory.createAttribute(MAP_VERSION, "1.0.1");
        eventWriter.add(testProp);
        this.createNodeElement(eventWriter, eventFactory, mindRootNode, 1);
        eventWriter.add(eventFactory.createEndElement("", "", MAP));
        eventWriter.close();
    }

    private void createNodeElement(XMLEventWriter eventWriter, XMLEventFactory eventFactory, MindNode mindNode, int deepIndex) throws XMLStreamException {
        StartElement sElement = eventFactory.createStartElement("", "", NODE);
        eventWriter.add(sElement);
        if (mindNode.getId() != null) {
            eventWriter.add(eventFactory.createAttribute("ID", mindNode.getId()));
        }
        if (mindNode.getText() != null) {
            eventWriter.add(eventFactory.createAttribute(NODE_TEXT, mindNode.getText()));
        }
        if (mindNode.getCreated() != null) {
            eventWriter.add(eventFactory.createAttribute(NODE_CREATED, mindNode.getCreated()));
        }
        if (mindNode.getModified() != null) {
            eventWriter.add(eventFactory.createAttribute(NODE_MODIFIED, mindNode.getModified()));
        }
        if (mindNode.getStyle() != null) {
            eventWriter.add(eventFactory.createAttribute("STYLE", mindNode.getStyle()));
        }
        if (mindNode.getColor() != null) {
            eventWriter.add(eventFactory.createAttribute("COLOR", mindNode.getColor()));
        }
        if (mindNode.getBackgroundColor() != null) {
            eventWriter.add(eventFactory.createAttribute(NODE_BACKGROUND_COLOR, mindNode.getBackgroundColor()));
        }
        if (mindNode.getPosition() != null) {
            eventWriter.add(eventFactory.createAttribute(NODE_POSITION, mindNode.getPosition()));
        }
        if (mindNode.getFolded() != null) {
            eventWriter.add(eventFactory.createAttribute(NODE_FOLDED, mindNode.getFolded().toString()));
        }
        if (mindNode.getLink() != null) {
            eventWriter.add(eventFactory.createAttribute(NODE_LINK, mindNode.getLink()));
        }
        if (mindNode.getVshift() != null) {
            eventWriter.add(eventFactory.createAttribute(NODE_VSHIFT, mindNode.getVshift().toString()));
        }
        if (mindNode.getHgap() != null) {
            eventWriter.add(eventFactory.createAttribute(NODE_HGAP, mindNode.getHgap().toString()));
        }
        if (mindNode.getVgap() != null) {
            eventWriter.add(eventFactory.createAttribute(NODE_VGAP, mindNode.getVgap().toString()));
        }
        if (mindNode.getEncryptedContent() != null) {
            eventWriter.add(eventFactory.createAttribute(NODE_ENCRYPTED_CONTENT, mindNode.getEncryptedContent()));
        }
        this.createFontElementIfNeed(eventWriter, eventFactory, mindNode, deepIndex);
        int nextDeepIndex = deepIndex + 1;
        this.createEdgeElementIfNeed(eventWriter, eventFactory, mindNode, nextDeepIndex);
        this.createRichcontentElementIfNeed(eventWriter, eventFactory, mindNode);
        this.createNoteElement(eventWriter, eventFactory, mindNode);
        this.createCloudElementIfNeed(eventWriter, eventFactory, mindNode, nextDeepIndex);
        this.createHookElementIfNeed(eventWriter, eventFactory, mindNode, nextDeepIndex);
        for (MindArrowlink arrowlink : mindNode.getArrowlinks()) {
            this.createArrowlinkElement(eventWriter, eventFactory, arrowlink);
        }
        for (String iconName : mindNode.getIcons()) {
            this.createIconElement(eventWriter, eventFactory, iconName, nextDeepIndex);
        }
        for (MindNode childrenNode : mindNode.getChildrenNodes()) {
            this.createNodeElement(eventWriter, eventFactory, childrenNode, nextDeepIndex);
        }
        EndElement eElement = eventFactory.createEndElement("", "", NODE);
        eventWriter.add(eElement);
    }

    private void createArrowlinkElement(XMLEventWriter eventWriter, XMLEventFactory eventFactory, MindArrowlink mindArrowlink) throws XMLStreamException {
        StartElement sElement = eventFactory.createStartElement("", "", ARROWLINK);
        eventWriter.add(sElement);
        if (mindArrowlink.getId() != null) {
            eventWriter.add(eventFactory.createAttribute("ID", mindArrowlink.getId()));
        }
        if (mindArrowlink.getColor() != null) {
            eventWriter.add(eventFactory.createAttribute("COLOR", mindArrowlink.getColor()));
        }
        if (mindArrowlink.getStyle() != null) {
            eventWriter.add(eventFactory.createAttribute("STYLE", mindArrowlink.getStyle()));
        }
        if (mindArrowlink.getDestination() != null) {
            eventWriter.add(eventFactory.createAttribute(ARROWLINK_DESTINATION, mindArrowlink.getDestination()));
        }
        if (mindArrowlink.getReferencetext() != null) {
            eventWriter.add(eventFactory.createAttribute(ARROWLINK_REFERENCETEXT, mindArrowlink.getReferencetext()));
        }
        if (mindArrowlink.getStartinclination() != null) {
            eventWriter.add(eventFactory.createAttribute(ARROWLINK_STARTINCLINATION, mindArrowlink.getStartinclination()));
        }
        if (mindArrowlink.getEndinclination() != null) {
            eventWriter.add(eventFactory.createAttribute(ARROWLINK_ENDINCLINATION, mindArrowlink.getEndinclination()));
        }
        if (mindArrowlink.getStartarrow() != null) {
            eventWriter.add(eventFactory.createAttribute(ARROWLINK_STARTARROW, mindArrowlink.getStartarrow()));
        }
        if (mindArrowlink.getEndtarrow() != null) {
            eventWriter.add(eventFactory.createAttribute(ARROWLINK_ENDARROW, mindArrowlink.getEndtarrow()));
        }
        if (mindArrowlink.getWidth() != null) {
            eventWriter.add(eventFactory.createAttribute("WIDTH", mindArrowlink.getWidth().toString()));
        }
        EndElement eElement = eventFactory.createEndElement("", "", ARROWLINK);
        eventWriter.add(eElement);
    }

    private void createIconElement(XMLEventWriter eventWriter, XMLEventFactory eventFactory, String iconName, int deepIndex) throws XMLStreamException {
        StartElement sElement = eventFactory.createStartElement("", "", ICON);
        eventWriter.add(sElement);
        eventWriter.add(eventFactory.createAttribute(ICON_BUILTIN, iconName));
        EndElement eElement = eventFactory.createEndElement("", "", ICON);
        eventWriter.add(eElement);
    }

    public void createFontElementIfNeed(XMLEventWriter eventWriter, XMLEventFactory eventFactory, MindNode mindNode, int deepIndex) throws XMLStreamException {
        if (mindNode.getFontName() != null || mindNode.getFontSize() != null || mindNode.getFontBold() != null || mindNode.getFontItalic() != null) {
            this.createFontElement(eventWriter, eventFactory, mindNode, deepIndex);
        }
    }

    private void createFontElement(XMLEventWriter eventWriter, XMLEventFactory eventFactory, MindNode mindNode, int deepIndex) throws XMLStreamException {
        StartElement sElement = eventFactory.createStartElement("", "", FONT);
        eventWriter.add(sElement);
        if (mindNode.getFontName() != null) {
            eventWriter.add(eventFactory.createAttribute(FONT_NAME, mindNode.getFontName()));
        }
        if (mindNode.getFontSize() != null) {
            eventWriter.add(eventFactory.createAttribute(FONT_SIZE, mindNode.getFontSize().toString()));
        }
        if (mindNode.getFontBold() != null) {
            eventWriter.add(eventFactory.createAttribute(FONT_BOLD, mindNode.getFontBold().toString()));
        }
        if (mindNode.getFontItalic() != null) {
            eventWriter.add(eventFactory.createAttribute(FONT_ITALIC, mindNode.getFontItalic().toString()));
        }
        EndElement eElement = eventFactory.createEndElement("", "", FONT);
        eventWriter.add(eElement);
    }

    private void createEdgeElementIfNeed(XMLEventWriter eventWriter, XMLEventFactory eventFactory, MindNode mindNode, int deepIndex) throws XMLStreamException {
        if (mindNode.getEdgeColor() != null || mindNode.getEdgeStyle() != null || mindNode.getEdgeWidth() != null) {
            this.createEdgeElement(eventWriter, eventFactory, mindNode, deepIndex);
        }
    }

    private void createEdgeElement(XMLEventWriter eventWriter, XMLEventFactory eventFactory, MindNode mindNode, int deepIndex) throws XMLStreamException {
        StartElement sElement = eventFactory.createStartElement("", "", EDGE);
        eventWriter.add(sElement);
        if (mindNode.getEdgeColor() != null) {
            eventWriter.add(eventFactory.createAttribute("COLOR", mindNode.getEdgeColor()));
        }
        if (mindNode.getEdgeStyle() != null) {
            eventWriter.add(eventFactory.createAttribute("STYLE", mindNode.getEdgeStyle()));
        }
        if (mindNode.getEdgeWidth() != null) {
            eventWriter.add(eventFactory.createAttribute("WIDTH", mindNode.getEdgeWidth()));
        }
        EndElement eElement = eventFactory.createEndElement("", "", EDGE);
        eventWriter.add(eElement);
    }

    private void createRichcontentElementIfNeed(XMLEventWriter eventWriter, XMLEventFactory eventFactory, MindNode mindNode) throws XMLStreamException {
        if (mindNode.getRichcontentType() != null || mindNode.getRichcontentText() != null) {
            this.createRichcontentElement(eventWriter, eventFactory, mindNode);
        }
    }

    private void createNoteElement(XMLEventWriter eventWriter, XMLEventFactory eventFactory, MindNode mindNode) throws XMLStreamException {
        if (mindNode.getNote() != null) {
            StartElement sElement = eventFactory.createStartElement("", "", RICHCONTENT);
            eventWriter.add(sElement);
            eventWriter.add(eventFactory.createAttribute(RICHCONTENT_TYPE, NOTE_TYPE));
            eventWriter.add(eventFactory.createCharacters(mindNode.getNote()));
            EndElement eElement = eventFactory.createEndElement("", "", RICHCONTENT);
            eventWriter.add(eElement);
        }
    }

    private void createRichcontentElement(XMLEventWriter eventWriter, XMLEventFactory eventFactory, MindNode mindNode) throws XMLStreamException {
        StartElement sElement = eventFactory.createStartElement("", "", RICHCONTENT);
        eventWriter.add(sElement);
        if (mindNode.getRichcontentType() != null) {
            eventWriter.add(eventFactory.createAttribute(RICHCONTENT_TYPE, mindNode.getRichcontentType()));
        }
        if (mindNode.getRichcontentText() != null) {
            Characters characters = eventFactory.createCharacters(mindNode.getRichcontentText());
            eventWriter.add(characters);
        }
        EndElement eElement = eventFactory.createEndElement("", "", RICHCONTENT);
        eventWriter.add(eElement);
    }

    private void createCloudElementIfNeed(XMLEventWriter eventWriter, XMLEventFactory eventFactory, MindNode mindNode, int deepIndex) throws XMLStreamException {
        MindCloud mindCloud = mindNode.getCloud();
        if (mindCloud != null) {
            this.createCloudElement(eventWriter, eventFactory, mindCloud, deepIndex);
        }
    }

    private void createCloudElement(XMLEventWriter eventWriter, XMLEventFactory eventFactory, MindCloud mindCloud, int deepIndex) throws XMLStreamException {
        StartElement sElement = eventFactory.createStartElement("", "", CLOUD);
        eventWriter.add(sElement);
        if (mindCloud.getColor() != null) {
            eventWriter.add(eventFactory.createAttribute("COLOR", mindCloud.getColor()));
        }
        if (mindCloud.getStyle() != null) {
            eventWriter.add(eventFactory.createAttribute("STYLE", mindCloud.getStyle()));
        }
        if (mindCloud.getWidth() != null) {
            eventWriter.add(eventFactory.createAttribute("WIDTH", mindCloud.getWidth().toString()));
        }
        EndElement eElement = eventFactory.createEndElement("", "", CLOUD);
        eventWriter.add(eElement);
    }

    private void createHookElementIfNeed(XMLEventWriter eventWriter, XMLEventFactory eventFactory, MindNode mindNode, int deepIndex) throws XMLStreamException {
        if (mindNode.getHookEquation() != null) {
            this.createHookElement(eventWriter, eventFactory, mindNode, deepIndex);
        }
    }

    private void createHookElement(XMLEventWriter eventWriter, XMLEventFactory eventFactory, MindNode mindNode, int deepIndex) throws XMLStreamException {
        StartElement sElement = eventFactory.createStartElement("", "", HOOK);
        eventWriter.add(sElement);
        if (mindNode.getHookEquation() != null) {
            eventWriter.add(eventFactory.createAttribute(HOOK_EQUATION, mindNode.getHookEquation()));
        }
        EndElement eElement = eventFactory.createEndElement("", "", HOOK);
        eventWriter.add(eElement);
    }
}

