/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.common.expimp;

import cz.morosystems.namymap.common.exception.EasyMindException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.function.Predicate;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public final class ExportImportUtils {
    private static final String DOT = ".";
    public static final String JSON_SUFFIX = ".json";

    private ExportImportUtils() {
        throw new UnsupportedOperationException("Cannot create an instance of utils class.");
    }

    public static String changeExtension(String filename, String extension) {
        Validate.notBlank((CharSequence)filename);
        Validate.notBlank((CharSequence)extension);
        if (filename.endsWith(DOT + extension)) {
            return filename;
        }
        int jsonSuffixPosition = filename.lastIndexOf(JSON_SUFFIX);
        if (jsonSuffixPosition > 0) {
            return filename.substring(0, jsonSuffixPosition - 1) + DOT + extension;
        }
        return filename + DOT + extension;
    }

    public static String getUniqueFileName(String nameBase, Predicate<String> nameUniquenessPredicate) {
        return ExportImportUtils.getUniqueFileName(nameBase, nameUniquenessPredicate, 0);
    }

    public static DocumentBuilderFactory createSecureDocumentBuilderFactory() {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        try {
            dbFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            dbFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (ParserConfigurationException e) {
            throw new EasyMindException("Could not initialize a secure DocumentBuilderFactory.", e);
        }
        return dbFactory;
    }

    private static String getUniqueFileName(String nameBase, Predicate<String> nameUniquenessPredicate, int minSuffix) {
        String suffixedName = ExportImportUtils.getSuffixedName(nameBase, minSuffix);
        if (nameUniquenessPredicate.test(suffixedName)) {
            return suffixedName;
        }
        return ExportImportUtils.getUniqueFileName(nameBase, nameUniquenessPredicate, minSuffix + 1);
    }

    private static String getSuffixedName(String nameBase, int suffix) {
        StringBuilder finalName = new StringBuilder(StringUtils.removeEnd((String)nameBase, (String)JSON_SUFFIX));
        if (suffix > 0) {
            finalName.append("_").append(suffix);
        }
        finalName.append(JSON_SUFFIX);
        return finalName.toString();
    }

    public static String getValidHyperlink(String url) {
        try {
            new URL(url);
            return url;
        }
        catch (MalformedURLException e) {
            return "notDefined";
        }
    }
}

