/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.common.enums;

import java.util.Optional;

public enum ImportExportFormat {
    EASY_MIND("easymind"),
    FREE_MIND("freemind"),
    FREE_PLANE("freeplane"),
    X_MIND("xmind"),
    XMIND_JSON("xmind_json"),
    IMG_PNG("pngimage");

    private final String code;

    private ImportExportFormat(String code) {
        this.code = code;
    }

    public static ImportExportFormat fromCode(String code) {
        for (ImportExportFormat format : ImportExportFormat.values()) {
            if (!format.code.equals(code)) continue;
            return format;
        }
        return null;
    }

    public static ImportExportFormat fromCodeDefaultEasyMind(String code) {
        ImportExportFormat format = ImportExportFormat.fromCode(code);
        return Optional.ofNullable(format).orElse(EASY_MIND);
    }

    public String getCode() {
        return this.code;
    }
}

