/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import cz.morosystems.namymap.common.Constants;
import cz.morosystems.namymap.common.InfrastructureUtil;
import cz.morosystems.namymap.common.Marker;
import cz.morosystems.namymap.common.enums.MindmapFormatVersion;
import cz.morosystems.namymap.common.expimp.em.MarkerMapping;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.commons.lang3.Validate;

public final class EasyMindVersionConverter {
    private EasyMindVersionConverter() {
        throw new UnsupportedOperationException("Cannot create an instance of EasyMindVersionConverter.");
    }

    public static String convertFromInputStream(InputStream inputStream) throws IOException {
        Validate.notNull((Object)inputStream);
        return EasyMindVersionConverter.convertFromJsonNode(Constants.OBJECT_MAPPER.readTree(inputStream));
    }

    public static String convertFromString(String content) throws IOException {
        if (content == null) {
            return null;
        }
        return EasyMindVersionConverter.convertFromJsonNode(Constants.OBJECT_MAPPER.readTree(content));
    }

    private static String convertFromJsonNode(JsonNode jsonNode) {
        Validate.notNull((Object)jsonNode);
        if (EasyMindVersionConverter.isExportedFromOutdatedVersion(jsonNode)) {
            return EasyMindVersionConverter.convertToCurrentFormat(jsonNode);
        }
        return jsonNode.toString();
    }

    private static boolean isExportedFromOutdatedVersion(JsonNode jsonNode) {
        Validate.notNull((Object)jsonNode);
        JsonNode pluginVersionNode = jsonNode.get("pluginVersion");
        JsonNode formatVersionNode = jsonNode.get("formatVersion");
        if (pluginVersionNode == null && formatVersionNode == null) {
            return true;
        }
        if (formatVersionNode == null) {
            return false;
        }
        Validate.isTrue((boolean)MindmapFormatVersion.VERSION_2_0_0.getValue().equals(formatVersionNode.asText()));
        Validate.isTrue((MindmapFormatVersion.CURRENT == MindmapFormatVersion.VERSION_2_0_0 ? 1 : 0) != 0);
        return false;
    }

    private static String convertToCurrentFormat(JsonNode jsonNode) {
        Validate.notNull((Object)jsonNode);
        InfrastructureUtil.addMindmapFormatVersion((ObjectNode)jsonNode);
        JsonNode rootTopic = jsonNode.get("rootTopic");
        EasyMindVersionConverter.convertOutdatedMarkersToCurrentFormat(rootTopic);
        EasyMindVersionConverter.convertOutdatedStylesToCurrentFormat(rootTopic);
        return jsonNode.toString();
    }

    private static void convertOutdatedMarkersToCurrentFormat(JsonNode topic) {
        ArrayNode currentMarkers = Constants.OBJECT_MAPPER.createArrayNode();
        for (JsonNode group : topic.get("markers")) {
            JsonNode markerId = group.get("url");
            Marker marker = MarkerMapping.OUTDATED_EASYMIND_MARKERS.get(markerId.textValue());
            Optional.ofNullable(marker).ifPresent(notNullMarker -> currentMarkers.add(notNullMarker.name()));
        }
        ((ObjectNode)topic).replace("markers", currentMarkers);
        for (JsonNode subtopic : topic.get("subtopics")) {
            EasyMindVersionConverter.convertOutdatedMarkersToCurrentFormat(subtopic);
        }
    }

    private static void convertOutdatedStylesToCurrentFormat(JsonNode topic) {
        EasyMindVersionConverter.convertOutdatedStylesToCurrentFormat(topic, "strokeWidth", null);
        EasyMindVersionConverter.convertOutdatedStylesToCurrentFormat(topic, "strokeColor", null);
        EasyMindVersionConverter.convertOutdatedStylesToCurrentFormat(topic, "topicStructureType", "map");
    }

    private static void convertOutdatedStylesToCurrentFormat(JsonNode topic, String styleProperty, String parentStylePropertyValue) {
        if (parentStylePropertyValue != null && EasyMindVersionConverter.getStylePropertyValue(topic, styleProperty) == null) {
            EasyMindVersionConverter.setStylePropertyValue(topic, styleProperty, parentStylePropertyValue);
        }
        for (JsonNode subtopic : topic.get("subtopics")) {
            String possiblyUpdatedStylePropertyValue = EasyMindVersionConverter.getStylePropertyValue(topic, styleProperty);
            EasyMindVersionConverter.convertOutdatedStylesToCurrentFormat(subtopic, styleProperty, possiblyUpdatedStylePropertyValue);
        }
    }

    private static String getStylePropertyValue(JsonNode topic, String property) {
        String propertyValue;
        JsonNode propertyNode;
        Validate.notNull((Object)topic);
        Validate.notBlank((CharSequence)property);
        JsonNode style = topic.get("style");
        if (style != null && (propertyNode = style.get(property)) != null && !"notDefined".equals(propertyValue = propertyNode.asText())) {
            return propertyValue;
        }
        return null;
    }

    private static void setStylePropertyValue(JsonNode topic, String styleProperty, String parentStylePropertyValue) {
        ObjectNode styleNode = (ObjectNode)topic.get("style");
        styleNode.set(styleProperty, new TextNode(parentStylePropertyValue));
    }
}

