/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.common;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import cz.morosystems.namymap.common.enums.MindmapFormatVersion;
import cz.morosystems.namymap.common.helper.ContentMacro;
import cz.morosystems.namymap.common.helper.MacroModifier;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.safety.Safelist;

public final class CommonUtil {
    public static final String CLOUD_MACRO_TEMPLATE = "<ac:structured-macro ac:name=\"EasyMind\" ac:schema-version=\"1\" data-layout=\"default\" ac:macro-id=\"%s\"><ac:parameter ac:name=\"name\">%s</ac:parameter></ac:structured-macro>";
    private static final String IMAGE_BASE64_DATA_PREFIX = "^data:image/([a-zA-Z0-9]+);base64,";
    private static final String STRUCTURED_MACRO_DEF_START = "<ac:structured-macro ac:name=\"EasyMind\"";
    private static final String STRUCTURED_MACRO_DEF_END = "</ac:structured-macro>";
    private static final String MACRO_DEF_START = "<ac:macro ac:name=\"EasyMind\">";
    private static final String MACRO_DEF_END = "</ac:macro>";
    private static final String MINDMAP_NAME_PARAM_DEF_START = "<ac:parameter ac:name=\"name\">";

    private CommonUtil() {
        throw new UnsupportedOperationException("Cannot create an instance of CommonUtil.");
    }

    public static String getMindmapImageAttachmentName(String mindmapName) {
        return mindmapName + ".png";
    }

    public static String getMindmapJsonAttachmentName(String mindmapName) {
        return mindmapName;
    }

    public static byte[] convertBase64ImageUrlToPng(String base64ImageUrl) {
        String base64Image = CommonUtil.extractBase64ImageFromUrl(base64ImageUrl);
        return Base64.decodeBase64((String)base64Image);
    }

    private static String extractBase64ImageFromUrl(String base64ImageUrl) {
        String[] dataImageSplitByBase64Prefix = base64ImageUrl.split(IMAGE_BASE64_DATA_PREFIX);
        Validate.isTrue((dataImageSplitByBase64Prefix.length >= 2 ? 1 : 0) != 0);
        return dataImageSplitByBase64Prefix[1];
    }

    public static String convertHtmlToPlainText(String html, boolean clean) {
        String result = "";
        if (StringUtils.isNotBlank((CharSequence)html)) {
            Document document = Jsoup.parse(html);
            String string = document.html();
            Safelist.none();
            result = Jsoup.clean(string, "", Safelist.none(), new Document.OutputSettings().prettyPrint(clean));
        }
        return result;
    }

    public static Optional<ContentMacro> getContentMacro(@NonNull String content, @NonNull String mindmapName) {
        if (content == null) {
            throw new NullPointerException("content");
        }
        if (mindmapName == null) {
            throw new NullPointerException("mindmapName");
        }
        int idx = content.indexOf(MINDMAP_NAME_PARAM_DEF_START + StringEscapeUtils.escapeHtml3((String)mindmapName));
        if (idx >= 0) {
            int end;
            int start;
            int structMacroBegin;
            String tmp = content.substring(0, idx);
            int macroBegin = tmp.lastIndexOf(MACRO_DEF_START);
            if (macroBegin > (structMacroBegin = tmp.lastIndexOf(STRUCTURED_MACRO_DEF_START))) {
                start = macroBegin;
                end = content.indexOf(MACRO_DEF_END, start) + MACRO_DEF_END.length();
            } else {
                start = structMacroBegin;
                end = content.indexOf(STRUCTURED_MACRO_DEF_END, start) + STRUCTURED_MACRO_DEF_END.length();
            }
            return Optional.of(new ContentMacro(content.substring(start, end), start, end));
        }
        return Optional.empty();
    }

    public static Optional<String> modifyMacroInBodyContent(@NonNull String content, @NonNull String mindmapName, @NonNull MacroModifier modifier) {
        if (content == null) {
            throw new NullPointerException("content");
        }
        if (mindmapName == null) {
            throw new NullPointerException("mindmapName");
        }
        if (modifier == null) {
            throw new NullPointerException("modifier");
        }
        Optional<ContentMacro> originalContentMacro = CommonUtil.getContentMacro(content, mindmapName);
        if (originalContentMacro.isPresent()) {
            String modifiedMacro = modifier.modify(originalContentMacro.get().getMacro());
            String modifiedContent = content.substring(0, originalContentMacro.get().getStart()) + modifiedMacro + content.substring(originalContentMacro.get().getEnd());
            return Optional.of(modifiedContent);
        }
        return Optional.empty();
    }

    public static byte[] getMindmapJsonBinaryWithFormatVersion(String mindmapJsonString) {
        return CommonUtil.getMindmapJsonStringWithFormatVersion(mindmapJsonString).getBytes(StandardCharsets.UTF_8);
    }

    private static String getMindmapJsonStringWithFormatVersion(String mindmapJsonString) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            Map<String, Object> mindmapJson = CommonUtil.parseJson(mindmapJsonString);
            mindmapJson.put("formatVersion", MindmapFormatVersion.CURRENT.getValue());
            return mapper.writeValueAsString(mindmapJson);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error in getMindmapJsonStringWithFormatVersion", e);
        }
    }

    public static boolean isMindmapContentSame(String jsonString1, String jsonString2) {
        String jsonString1ForComparison = CommonUtil.getMindmapJsonForComparison(jsonString1);
        String jsonString2ForComparison = CommonUtil.getMindmapJsonForComparison(jsonString2);
        return Objects.equals(jsonString1ForComparison, jsonString2ForComparison);
    }

    private static String getMindmapJsonForComparison(String jsonString) {
        if (jsonString == null) {
            return null;
        }
        try {
            Map<String, Object> json = CommonUtil.parseJson(jsonString);
            json.remove("pluginVersion");
            json.remove("formatVersion");
            ((Map)json.get("rootTopic")).remove("timestamp");
            return new ObjectMapper().writeValueAsString(json);
        }
        catch (IOException e) {
            throw new IllegalStateException("getMindmapJsonForComparison failed", e);
        }
    }

    public static Map<String, Object> parseJson(String jsonString) throws IOException {
        ObjectMapper jsonMapper = new ObjectMapper();
        TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
        return jsonMapper.readValue(jsonString, typeRef);
    }

    public static String getFirstFontFamilyFromStringList(String fontFamilyList) {
        if (!StringUtils.isBlank((CharSequence)fontFamilyList)) {
            return Stream.of(fontFamilyList.split(", ")).findFirst().filter(fontFamily -> !fontFamily.equals("default-font")).orElse("Arial");
        }
        return "Arial";
    }

    public static String truncateMindmanName(String mindmapName) {
        return mindmapName.length() > 50 ? mindmapName.substring(0, 50) + "..." : mindmapName;
    }
}

