/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.locale.converters;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.beanutils2.locale.BaseLocaleConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StringLocaleConverter
extends BaseLocaleConverter<String> {
    private static final Log LOG = LogFactory.getLog(StringLocaleConverter.class);

    public static Builder builder() {
        return new Builder();
    }

    private StringLocaleConverter(String defaultValue, Locale locale, String pattern, boolean useDefault, boolean locPattern) {
        super(defaultValue, locale, pattern, useDefault, locPattern);
    }

    private DecimalFormat getDecimalFormat(Locale locale, String pattern) {
        DecimalFormat numberFormat = (DecimalFormat)NumberFormat.getInstance(locale);
        if (pattern != null) {
            if (this.localizedPattern) {
                numberFormat.applyLocalizedPattern(pattern);
            } else {
                numberFormat.applyPattern(pattern);
            }
        } else {
            LOG.debug("No pattern provided, using default.");
        }
        return numberFormat;
    }

    @Override
    protected String parse(Object value, String pattern) throws ParseException {
        String result = null;
        result = value instanceof Integer || value instanceof Long || value instanceof BigInteger || value instanceof Byte || value instanceof Short ? this.getDecimalFormat(this.locale, pattern).format(((Number)value).longValue()) : (value instanceof Double || value instanceof BigDecimal || value instanceof Float ? this.getDecimalFormat(this.locale, pattern).format(((Number)value).doubleValue()) : (value instanceof Date ? new SimpleDateFormat(pattern, this.locale).format(value) : value.toString()));
        return result;
    }

    public static class Builder
    extends BaseLocaleConverter.Builder<Builder, String> {
        public StringLocaleConverter get() {
            return new StringLocaleConverter((String)this.defaultValue, this.locale, this.pattern, this.useDefault || this.defaultValue != null, this.localizedPattern);
        }
    }
}

